/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.map;

import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.utilities.ds.map.CoordHashMap;
import fr.neatmonster.nocheatplus.utilities.ds.map.CoordMap;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.map.MapUtil;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;

public abstract class BlockCache {
    private static final int ID_AIR = 0;
    private final CoordMap<BlockCacheNode> nodeMap = new CoordHashMap<BlockCacheNode>(23);
    protected int maxBlockY = 255;
    private final BlockCacheNode airNode = new BlockCacheNode(0);

    public BlockCache() {
        this.airNode.setData(0);
        this.airNode.setBounds(null);
    }

    public BlockCache(World world) {
        this.setAccess(world);
    }

    public abstract BlockCache setAccess(World var1);

    public abstract int fetchTypeId(int var1, int var2, int var3);

    public abstract int fetchData(int var1, int var2, int var3);

    public abstract double[] fetchBounds(int var1, int var2, int var3);

    public abstract boolean standsOnEntity(Entity var1, double var2, double var4, double var6, double var8, double var10, double var12);

    public void cleanup() {
        this.nodeMap.clear();
    }

    private BlockCacheNode getOrCreateNode(int x, int y, int z) {
        int id;
        BlockCacheNode node = this.nodeMap.get(x, y, z);
        if (node != null) {
            return node;
        }
        int n = id = y < 0 || y > this.maxBlockY ? 0 : this.fetchTypeId(x, y, z);
        if (id == 0) {
            return this.airNode;
        }
        node = new BlockCacheNode(id);
        this.nodeMap.put(x, y, z, node);
        return node;
    }

    public int getTypeId(double x, double y, double z) {
        return this.getTypeId(Location.locToBlock((double)x), Location.locToBlock((double)y), Location.locToBlock((double)z));
    }

    public IBlockCacheNode getOrCreateBlockCacheNode(double x, double y, double z, boolean forceSetAll) {
        return this.getOrCreateBlockCacheNode(Location.locToBlock((double)x), Location.locToBlock((double)y), Location.locToBlock((double)z), forceSetAll);
    }

    public int getTypeId(Block block) {
        return this.getTypeId(block.getX(), block.getY(), block.getZ());
    }

    public int getTypeId(int x, int y, int z) {
        return this.getOrCreateNode(x, y, z).getId();
    }

    public int getData(int x, int y, int z) {
        BlockCacheNode node = this.getOrCreateNode(x, y, z);
        if (node.isDataFetched()) {
            return node.getData();
        }
        int nData = this.fetchData(x, y, z);
        node.setData(nData);
        return nData;
    }

    public double[] getBounds(int x, int y, int z) {
        BlockCacheNode node = this.getOrCreateNode(x, y, z);
        if (node.isBoundsFetched()) {
            return node.getBounds();
        }
        double[] nBounds = this.fetchBounds(x, y, z);
        node.setBounds(nBounds);
        return nBounds;
    }

    public IBlockCacheNode getOrCreateBlockCacheNode(int x, int y, int z, boolean forceSetAll) {
        BlockCacheNode node = this.getOrCreateNode(x, y, z);
        if (forceSetAll) {
            if (!node.isDataFetched()) {
                node.setData(this.fetchData(x, y, z));
            }
            if (!node.isBoundsFetched()) {
                node.setBounds(this.fetchBounds(x, y, z));
            }
        }
        return node;
    }

    public IBlockCacheNode getBlockCacheNode(int x, int y, int z) {
        return this.nodeMap.get(x, y, z);
    }

    public boolean isFullBounds(int x, int y, int z) {
        return MapUtil.isFullBounds(this.getBounds(x, y, z));
    }

    public int getMaxBlockY() {
        return this.maxBlockY;
    }

    public static class BlockCacheNode
    implements IBlockCacheNode {
        private static final short FETCHED_ID = 1;
        private static final short FETCHED_DATA = 2;
        private static final short FETCHED_BOUNDS = 4;
        private short fetched;
        private final int id;
        private int data = 0;
        private double[] bounds = null;

        public BlockCacheNode(int id) {
            this.id = id;
            this.fetched = 1;
        }

        public boolean isDataFetched() {
            return (this.fetched & 2) != 0;
        }

        public boolean isBoundsFetched() {
            return (this.fetched & 4) != 0;
        }

        public AlmostBoolean hasNonNullBounds() {
            return this.isBoundsFetched() ? (this.bounds == null ? AlmostBoolean.NO : AlmostBoolean.YES) : AlmostBoolean.MAYBE;
        }

        public int getId() {
            return this.id;
        }

        public int getData() {
            return this.data;
        }

        public double[] getBounds() {
            return this.bounds;
        }

        public int getData(BlockCache blockCache, int x, int y, int z) {
            return this.isDataFetched() ? this.data : blockCache.getData(x, y, z);
        }

        public double[] getBounds(BlockCache blockCache, int x, int y, int z) {
            return this.isBoundsFetched() ? this.bounds : blockCache.getBounds(x, y, z);
        }

        public void setData(int data) {
            this.data = data;
            this.fetched = (short)(this.fetched | 2);
        }

        public void setBounds(double[] bounds) {
            this.bounds = bounds;
            this.fetched = (short)(this.fetched | 4);
        }

        public boolean equals(Object obj) {
            if (obj instanceof IBlockCacheNode) {
                IBlockCacheNode other = (IBlockCacheNode)obj;
                return this.id == other.getId() && (!this.isDataFetched() && !other.isDataFetched() || this.isDataFetched() && other.isDataFetched() && this.data == other.getData()) && (!this.isBoundsFetched() && !other.isBoundsFetched() || this.isBoundsFetched() && other.isBoundsFetched() && BlockProperties.isSameShape(this.bounds, other.getBounds()));
            }
            return false;
        }
    }

    public static interface IBlockCacheNode {
        public boolean isDataFetched();

        public boolean isBoundsFetched();

        public AlmostBoolean hasNonNullBounds();

        public int getId();

        public int getData();

        public double[] getBounds();

        public int getData(BlockCache var1, int var2, int var3, int var4);

        public double[] getBounds(BlockCache var1, int var2, int var3, int var4);
    }
}

