/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.location;

import fr.neatmonster.nocheatplus.components.location.IGetBlockPosition;
import fr.neatmonster.nocheatplus.components.location.IGetLocationWithLook;
import fr.neatmonster.nocheatplus.components.location.IGetPosition;
import fr.neatmonster.nocheatplus.components.location.IGetPositionWithLook;
import fr.neatmonster.nocheatplus.components.location.ISetPositionWithLook;
import fr.neatmonster.nocheatplus.utilities.location.RichBoundsLocation;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;

public class LocUtil {
    public static int hashCode(Location location) {
        World world = location.getWorld();
        return LocUtil.hashCode(world == null ? null : world.getName(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public static int hashCode(IGetLocationWithLook location) {
        return LocUtil.hashCode(location.getWorldName(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public static int hashCode(IGetPositionWithLook location) {
        return LocUtil.hashCode(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public static int hashCode(String worldName, double x, double y, double z, float yaw, float pitch) {
        return (worldName == null ? 0 : worldName.hashCode()) ^ LocUtil.hashCode(x, y, z, yaw, pitch);
    }

    public static int hashCode(double x, double y, double z, float yaw, float pitch) {
        int hash = 3;
        hash = 19 * hash + (int)(Double.doubleToLongBits(x) ^ Double.doubleToLongBits(x) >>> 32);
        hash = 19 * hash + (int)(Double.doubleToLongBits(y) ^ Double.doubleToLongBits(y) >>> 32);
        hash = 19 * hash + (int)(Double.doubleToLongBits(z) ^ Double.doubleToLongBits(z) >>> 32);
        hash = 19 * hash + Float.floatToIntBits(pitch);
        hash = 19 * hash + Float.floatToIntBits(yaw);
        return hash;
    }

    public static Location getLocation(World world, IGetPositionWithLook loc) {
        return new Location(world, loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
    }

    public static Location set(Location loc, World world, IGetPositionWithLook pos) {
        loc.setWorld(LocUtil.testWorld(world));
        loc.setX(pos.getX());
        loc.setY(pos.getY());
        loc.setZ(pos.getZ());
        loc.setYaw(pos.getYaw());
        loc.setPitch(pos.getPitch());
        return loc;
    }

    public static ISetPositionWithLook set(ISetPositionWithLook pos, Location loc) {
        pos.setX(loc.getX());
        pos.setY(loc.getY());
        pos.setZ(loc.getZ());
        pos.setYaw(loc.getYaw());
        pos.setPitch(loc.getPitch());
        return pos;
    }

    public static final Location clone(Location loc) {
        return new Location(LocUtil.testWorld(loc.getWorld()), loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
    }

    public static final Location clone(Location loc, float yaw, float pitch) {
        return new Location(LocUtil.testWorld(loc.getWorld()), loc.getX(), loc.getY(), loc.getZ(), yaw, pitch);
    }

    public static final Location clone(Location setBack, Location ref) {
        if (setBack == null) {
            return LocUtil.clone(ref);
        }
        return LocUtil.clone(setBack, ref.getYaw(), ref.getPitch());
    }

    public static final Location clone(Location setBack, RichBoundsLocation ref) {
        if (setBack == null) {
            return ref.getLocation();
        }
        return LocUtil.clone(setBack, ref.getYaw(), ref.getPitch());
    }

    public static final void set(Location setBack, Location loc) {
        setBack.setWorld(LocUtil.testWorld(loc.getWorld()));
        setBack.setX(loc.getX());
        setBack.setY(loc.getY());
        setBack.setZ(loc.getZ());
        setBack.setYaw(loc.getYaw());
        setBack.setPitch(loc.getPitch());
    }

    public static final void set(Location setBack, RichBoundsLocation loc) {
        setBack.setWorld(LocUtil.testWorld(loc.getWorld()));
        setBack.setX(loc.getX());
        setBack.setY(loc.getY());
        setBack.setZ(loc.getZ());
        setBack.setYaw(loc.getYaw());
        setBack.setPitch(loc.getPitch());
    }

    private static World testWorld(World world) {
        if (world == null) {
            throw new NullPointerException("World must not be null.");
        }
        return world;
    }

    public static final boolean needsYawCorrection(float yaw) {
        return Float.isNaN(yaw) || yaw < 0.0f || yaw >= 360.0f;
    }

    public static final boolean needsPitchCorrection(float pitch) {
        return Float.isNaN(pitch) || pitch < -90.0f || pitch > 90.0f;
    }

    public static boolean isBadCoordinate(float ... floats) {
        for (int i = 0; i < floats.length; ++i) {
            if (!Float.isNaN(floats[i]) && !Float.isInfinite(floats[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isBadCoordinate(double ... doubles) {
        for (int i = 0; i < doubles.length; ++i) {
            double x = doubles[i];
            if (!Double.isNaN(x) && !Double.isInfinite(x) && !(Math.abs(x) > 3.2E7)) continue;
            return true;
        }
        return false;
    }

    public static final boolean needsDirectionCorrection(float yaw, float pitch) {
        return LocUtil.needsYawCorrection(yaw) || LocUtil.needsPitchCorrection(pitch);
    }

    public static final float correctYaw(float yaw) {
        if (Float.isNaN(yaw)) {
            return 0.0f;
        }
        if (yaw >= 360.0f) {
            if (yaw > 10000.0f) {
                yaw = 0.0f;
            } else {
                while (yaw > 360.0f) {
                    yaw -= 360.0f;
                }
            }
        }
        if (yaw < 0.0f) {
            if (yaw < -10000.0f) {
                yaw = 0.0f;
            } else {
                while (yaw < 0.0f) {
                    yaw += 360.0f;
                }
            }
        }
        return yaw;
    }

    public static final float correctPitch(float pitch) {
        if (Float.isNaN(pitch)) {
            return 0.0f;
        }
        if (pitch < -90.0f) {
            return -90.0f;
        }
        if (pitch > 90.0f) {
            return 90.0f;
        }
        return pitch;
    }

    public static World getFirstWorld(Location ... locs) {
        for (int i = 0; i < locs.length; ++i) {
            World world;
            Location loc = locs[i];
            if (loc == null || (world = loc.getWorld()) == null) continue;
            return world;
        }
        return null;
    }

    public static String simpleFormat(Location loc) {
        return "x=" + loc.getX() + ",y=" + loc.getY() + ",z=" + loc.getZ() + ",pitch=" + loc.getPitch() + ",yaw=" + loc.getYaw();
    }

    public static String simpleFormat(IGetPositionWithLook loc) {
        return "x=" + loc.getX() + ",y=" + loc.getY() + ",z=" + loc.getZ() + ",pitch=" + loc.getPitch() + ",yaw=" + loc.getYaw();
    }

    public static String simpleFormat(IGetPosition loc) {
        return "x=" + loc.getX() + ",y=" + loc.getY() + ",z=" + loc.getZ();
    }

    public static String simpleFormatPosition(Location loc) {
        return "x=" + loc.getX() + ",y=" + loc.getY() + ",z=" + loc.getZ();
    }

    public static String simpleFormat(Block block) {
        return "x=" + block.getX() + ",y=" + block.getY() + ",z=" + block.getZ();
    }

    public static String simpleFormatBlock(IGetBlockPosition block) {
        return "x=" + block.getBlockX() + ",y=" + block.getBlockY() + ",z=" + block.getBlockZ();
    }
}

