/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.ds.prefixtree;

import fr.neatmonster.nocheatplus.utilities.ds.prefixtree.PrefixTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharPrefixTree<N extends CharNode<N>, L extends CharLookupEntry<N>>
extends PrefixTree<Character, N, L> {
    public CharPrefixTree(PrefixTree.NodeFactory<Character, N> nodeFactory, PrefixTree.LookupEntryFactory<Character, N, L> resultFactory) {
        super(nodeFactory, resultFactory);
    }

    public static final List<Character> toCharacterList(char[] chars) {
        ArrayList<Character> characters = new ArrayList<Character>(chars.length);
        for (int i = 0; i < chars.length; ++i) {
            characters.add(Character.valueOf(chars[i]));
        }
        return characters;
    }

    public L lookup(char[] chars, boolean create) {
        return (L)((CharLookupEntry)this.lookup(CharPrefixTree.toCharacterList(chars), create));
    }

    public L lookup(String input, boolean create) {
        return this.lookup(input.toCharArray(), create);
    }

    public boolean feed(String input) {
        return this.feed(input.toCharArray());
    }

    public boolean feed(char[] chars) {
        return this.feed(CharPrefixTree.toCharacterList(chars));
    }

    public void feedAll(Collection<String> inputs, boolean trim, boolean lowerCase) {
        for (String input : inputs) {
            if (trim) {
                input = input.toLowerCase();
            }
            if (lowerCase) {
                input = input.toLowerCase();
            }
            this.feed(input);
        }
    }

    public boolean hasPrefix(char[] chars) {
        return this.hasPrefix(CharPrefixTree.toCharacterList(chars));
    }

    public boolean hasPrefix(String input) {
        return this.hasPrefix(input.toCharArray());
    }

    public boolean hasPrefixWords(String input) {
        L result = this.lookup(input, false);
        if (!((CharLookupEntry)result).hasPrefix) {
            return false;
        }
        if (input.length() == ((CharLookupEntry)result).depth) {
            return true;
        }
        return Character.isWhitespace(input.charAt(((CharLookupEntry)result).depth));
    }

    public boolean hasAnyPrefixWords(String ... inputs) {
        for (int i = 0; i < inputs.length; ++i) {
            if (!this.hasPrefixWords(inputs[i])) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyPrefixWords(Collection<String> inputs) {
        for (String input : inputs) {
            if (!this.hasPrefixWords(input)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyPrefix(Collection<String> inputs) {
        for (String input : inputs) {
            if (!this.hasPrefix(input)) continue;
            return true;
        }
        return false;
    }

    public boolean isPrefix(char[] chars) {
        return this.isPrefix(CharPrefixTree.toCharacterList(chars));
    }

    public boolean isPrefix(String input) {
        return this.isPrefix(input.toCharArray());
    }

    public boolean matches(char[] chars) {
        return this.matches(CharPrefixTree.toCharacterList(chars));
    }

    public boolean matches(String input) {
        return this.matches(input.toCharArray());
    }

    public static CharPrefixTree<SimpleCharNode, CharLookupEntry<SimpleCharNode>> newCharPrefixTree() {
        return new CharPrefixTree<SimpleCharNode, CharLookupEntry<SimpleCharNode>>(new PrefixTree.NodeFactory<Character, SimpleCharNode>(){

            @Override
            public final SimpleCharNode newNode(SimpleCharNode parent) {
                return new SimpleCharNode();
            }
        }, new PrefixTree.LookupEntryFactory<Character, SimpleCharNode, CharLookupEntry<SimpleCharNode>>(){

            @Override
            public final CharLookupEntry<SimpleCharNode> newLookupEntry(SimpleCharNode node, SimpleCharNode insertion, int depth, boolean hasPrefix) {
                return new CharLookupEntry<SimpleCharNode>(node, insertion, depth, hasPrefix);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CharLookupEntry<N extends CharNode<N>>
    extends PrefixTree.LookupEntry<Character, N> {
        public CharLookupEntry(N node, N insertion, int depth, boolean hasPrefix) {
            super(node, insertion, depth, hasPrefix);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleCharNode
    extends CharNode<SimpleCharNode> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CharNode<N extends CharNode<N>>
    extends PrefixTree.Node<Character, N> {
    }
}

