/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.ds.map;

import fr.neatmonster.nocheatplus.utilities.ds.map.AbstractCoordHashMap;
import fr.neatmonster.nocheatplus.utilities.ds.map.CoordMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedCoordHashMap<V>
extends AbstractCoordHashMap<V, LinkedHashEntry<V>>
implements CoordMap<V> {
    protected LinkedHashEntry<V> firstEntry = null;
    protected LinkedHashEntry<V> lastEntry = null;

    public LinkedCoordHashMap() {
    }

    public LinkedCoordHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public LinkedCoordHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public V moveToFront(int x, int y, int z) {
        LinkedHashEntry entry = (LinkedHashEntry)this.getEntry(x, y, z);
        if (entry == null) {
            return null;
        }
        this.removeEntry(entry);
        this.setFirst(entry);
        return (V)entry.value;
    }

    public V moveToEnd(int x, int y, int z) {
        LinkedHashEntry entry = (LinkedHashEntry)this.getEntry(x, y, z);
        if (entry == null) {
            return null;
        }
        this.removeEntry(entry);
        this.setLast(entry);
        return (V)entry.value;
    }

    public V move(int x, int y, int z, MoveOrder order) {
        switch (order) {
            case END: {
                return this.moveToEnd(x, y, z);
            }
            case FRONT: {
                return this.moveToFront(x, y, z);
            }
        }
        return super.get(x, y, z);
    }

    public V put(int x, int y, int z, V value, MoveOrder order) {
        V previousValue = super.put(x, y, z, value);
        if (order == MoveOrder.FRONT) {
            this.moveToFront(x, y, z);
        } else if (previousValue != null && order == MoveOrder.END) {
            this.moveToEnd(x, y, z);
        }
        return previousValue;
    }

    public V get(int x, int y, int z, MoveOrder order) {
        Object value = super.get(x, y, z);
        if (value != null && order != MoveOrder.NOT) {
            this.move(x, y, z, order);
        }
        return value;
    }

    public LinkedHashIterator<V> iterator() {
        return new LinkedHashIterator(this, false);
    }

    public LinkedHashIterator<V> iterator(boolean reversed) {
        return new LinkedHashIterator(this, reversed);
    }

    @Override
    protected LinkedHashEntry<V> newEntry(int x, int y, int z, V value, int hash) {
        LinkedHashEntry<V> entry = new LinkedHashEntry<V>(x, y, z, value, hash);
        this.setLast(entry);
        return entry;
    }

    private void setFirst(LinkedHashEntry<V> entry) {
        if (this.firstEntry == null) {
            this.lastEntry = entry;
            this.firstEntry = this.lastEntry;
        } else {
            entry.next = this.firstEntry;
            this.firstEntry.previous = entry;
            this.firstEntry = entry;
        }
    }

    private void setLast(LinkedHashEntry<V> entry) {
        if (this.firstEntry == null) {
            this.lastEntry = entry;
            this.firstEntry = this.lastEntry;
        } else {
            entry.previous = this.lastEntry;
            this.lastEntry.next = entry;
            this.lastEntry = entry;
        }
    }

    @Override
    protected void removeEntry(LinkedHashEntry<V> entry) {
        if (entry == this.firstEntry) {
            this.firstEntry = entry.next;
            if (this.firstEntry != null) {
                this.firstEntry.previous = null;
            }
        } else {
            entry.previous.next = entry.next;
        }
        if (entry == this.lastEntry) {
            this.lastEntry = entry.previous;
            if (this.lastEntry != null) {
                this.lastEntry.next = null;
            }
        } else {
            entry.next.previous = entry.previous;
        }
        entry.next = null;
        entry.previous = null;
    }

    @Override
    public void clear() {
        super.clear();
        this.lastEntry = null;
        this.firstEntry = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedHashIterator<V>
    implements Iterator<CoordMap.Entry<V>> {
        private final LinkedCoordHashMap<V> map;
        private LinkedHashEntry<V> current = null;
        private LinkedHashEntry<V> next;
        private final boolean reverse;

        protected LinkedHashIterator(LinkedCoordHashMap<V> map, boolean reverse) {
            this.map = map;
            this.reverse = reverse;
            this.next = reverse ? map.lastEntry : map.firstEntry;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public LinkedHashEntry<V> next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.next = this.reverse ? this.next.previous : this.next.next;
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current != null) {
                this.map.remove(this.current.x, this.current.y, this.current.z);
                this.current = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedHashEntry<V>
    extends AbstractCoordHashMap.HashEntry<V> {
        protected LinkedHashEntry<V> previous = null;
        protected LinkedHashEntry<V> next = null;

        public LinkedHashEntry(int x, int y, int z, V value, int hash) {
            super(x, y, z, value, hash);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MoveOrder {
        FRONT,
        NOT,
        END;

    }
}

