/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.ds.map;

import fr.neatmonster.nocheatplus.utilities.ds.map.AbstractCoordHashMap;
import fr.neatmonster.nocheatplus.utilities.ds.map.CoordMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordHashMap<V>
extends AbstractCoordHashMap<V, AbstractCoordHashMap.HashEntry<V>>
implements CoordMap<V> {
    public CoordHashMap() {
    }

    public CoordHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public CoordHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public Iterator<CoordMap.Entry<V>> iterator() {
        return new HashIterator(this);
    }

    @Override
    protected AbstractCoordHashMap.HashEntry<V> newEntry(int x, int y, int z, V value, int hash) {
        return new AbstractCoordHashMap.HashEntry<V>(x, y, z, value, hash);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HashIterator<V>
    implements Iterator<CoordMap.Entry<V>> {
        private final CoordHashMap<V> map;
        private final List<AbstractCoordHashMap.HashEntry<V>>[] entries;
        private int slot = 0;
        private int index = 0;
        private int slotLast = -1;
        private int indexLast = -1;

        protected HashIterator(CoordHashMap<V> map) {
            this.map = map;
            this.entries = map.entries;
        }

        @Override
        public final boolean hasNext() {
            while (this.slot < this.entries.length) {
                List<AbstractCoordHashMap.HashEntry<V>> bucket = this.entries[this.slot];
                if (bucket == null) {
                    ++this.slot;
                    this.index = 0;
                    continue;
                }
                if (this.index < bucket.size()) {
                    return true;
                }
                ++this.slot;
                this.index = 0;
            }
            return false;
        }

        @Override
        public final CoordMap.Entry<V> next() {
            while (this.slot < this.entries.length) {
                List<AbstractCoordHashMap.HashEntry<V>> bucket = this.entries[this.slot];
                if (bucket == null) {
                    ++this.slot;
                    this.index = 0;
                    continue;
                }
                int size = bucket.size();
                if (this.index < size) {
                    CoordMap.Entry res = bucket.get(this.index);
                    this.slotLast = this.slot++;
                    this.indexLast = this.index++;
                    if (this.index == size) {
                        this.index = 0;
                    }
                    return res;
                }
                ++this.slot;
                this.index = 0;
            }
            throw new NoSuchElementException();
        }

        @Override
        public final void remove() {
            if (this.slotLast == -1) {
                return;
            }
            List<AbstractCoordHashMap.HashEntry<V>> bucket = this.entries[this.slotLast];
            bucket.remove(this.indexLast);
            if (bucket.isEmpty()) {
                this.entries[this.slotLast] = null;
            } else if (this.slotLast == this.slot) {
                --this.index;
            }
            --this.map.size;
            this.indexLast = -1;
            this.slotLast = -1;
        }
    }
}

