/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.ds.corw;

import fr.neatmonster.nocheatplus.utilities.ds.corw.IQueueRORA;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueRORAWithLock<E>
implements IQueueRORA<E> {
    private final Lock lock;
    private LinkedList<E> elements = new LinkedList();

    public QueueRORAWithLock() {
        this(new ReentrantLock());
    }

    public QueueRORAWithLock(Lock lock) {
        this.lock = lock;
    }

    @Override
    public int add(E element) {
        this.lock.lock();
        this.elements.add(element);
        int size = this.elements.size();
        this.lock.unlock();
        return size;
    }

    @Override
    public List<E> removeAll() {
        this.lock.lock();
        LinkedList<E> result = this.elements;
        this.elements = new LinkedList();
        this.lock.unlock();
        return result;
    }

    @Override
    public int reduce(int maxSize) {
        int dropped;
        this.lock.lock();
        int size = this.elements.size();
        if (size <= maxSize) {
            return dropped;
        }
        for (dropped = 0; dropped < size - maxSize; ++dropped) {
            this.elements.removeFirst();
        }
        this.lock.unlock();
        return dropped;
    }

    @Override
    public void clear() {
        this.removeAll();
    }

    @Override
    public boolean isEmpty() {
        this.lock.lock();
        boolean isEmpty = this.elements.isEmpty();
        this.lock.unlock();
        return isEmpty;
    }

    @Override
    public int size() {
        this.lock.lock();
        int size = this.elements.size();
        this.lock.unlock();
        return size;
    }
}

