/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.collision;

import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeReference;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.utilities.collision.ICollidePassable;
import fr.neatmonster.nocheatplus.utilities.collision.RayTracing;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import java.util.UUID;

public class PassableRayTracing
extends RayTracing
implements ICollidePassable {
    protected BlockCache blockCache = null;

    public BlockCache getBlockCache() {
        return this.blockCache;
    }

    public void setBlockCache(BlockCache blockCache) {
        this.blockCache = blockCache;
    }

    public void setBlockChangeTracker(BlockChangeTracker blockChangeTracker, BlockChangeReference blockChangeReference, int tick, UUID worldId) {
    }

    public void set(PlayerLocation from, PlayerLocation to) {
        this.set(from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ());
        this.setBlockCache(from.getBlockCache());
    }

    public void set(double x0, double y0, double z0, double x1, double y1, double z1) {
        super.set(x0, y0, z0, x1, y1, z1);
        this.collides = false;
    }

    public void cleanup() {
        this.blockCache = null;
    }

    protected boolean step(int blockX, int blockY, int blockZ, double oX, double oY, double oZ, double dT, boolean isPrimary) {
        if (isPrimary && this.step == 1 && this.ignoreInitiallyColliding && !BlockProperties.isPassable(this.blockCache, oX + (double)blockX, oY + (double)blockY, oZ + (double)blockZ, this.blockCache.getOrCreateBlockCacheNode(blockX, blockY, blockZ, false), null)) {
            return true;
        }
        if (BlockProperties.isPassableRay(this.blockCache, blockX, blockY, blockZ, oX, oY, oZ, this.dX, this.dY, this.dZ, dT)) {
            return true;
        }
        this.collides = true;
        return false;
    }

    public boolean mightNeedSplitAxisHandling() {
        return true;
    }

    public void setMargins(double height, double xzMargin) {
    }

    public void setCutOppositeDirectionMargin(boolean cutOppositeDirectionMargin) {
    }
}

