/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.collision;

import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeReference;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.utilities.collision.Axis;
import fr.neatmonster.nocheatplus.utilities.collision.AxisTracing;
import fr.neatmonster.nocheatplus.utilities.collision.BlockPositionContainer;
import fr.neatmonster.nocheatplus.utilities.collision.ICollidePassable;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import java.util.UUID;

public class PassableAxisTracing
extends AxisTracing
implements ICollidePassable {
    private BlockCache blockCache;
    private BlockChangeTracker blockChangeTracker = null;
    private BlockChangeReference blockChangeRef = null;
    private int tick;
    private UUID worldId;

    public BlockCache getBlockCache() {
        return this.blockCache;
    }

    public void setBlockCache(BlockCache blockCache) {
        this.blockCache = blockCache;
    }

    public void setBlockChangeTracker(BlockChangeTracker blockChangeTracker, BlockChangeReference blockChangeReference, int tick, UUID worldId) {
        this.blockChangeTracker = blockChangeTracker;
        this.blockChangeRef = blockChangeReference;
        this.tick = tick;
        this.worldId = worldId;
    }

    protected void collectInitiallyCollidingBlocks(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, BlockPositionContainer results) {
        BlockProperties.collectInitiallyCollidingBlocks(this.blockCache, minX, minY, minZ, maxX, maxY, maxZ, results);
    }

    protected boolean step(int blockX, int blockY, int blockZ, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Axis axis, int increment) {
        BlockChangeTracker.BlockChangeEntry entry;
        if (BlockProperties.isPassableBox(this.blockCache, blockX, blockY, blockZ, minX, minY, minZ, maxX, maxY, maxZ)) {
            return true;
        }
        if (this.blockChangeTracker != null && (entry = this.blockChangeTracker.getBlockChangeEntry(this.blockChangeRef, this.tick, this.worldId, blockX, blockY, blockZ, null)) != null) {
            this.blockChangeRef.updateSpan(entry);
            return true;
        }
        this.collides = true;
        return false;
    }

    public void set(PlayerLocation from, PlayerLocation to) {
        this.set(from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ());
        this.setBlockCache(from.getBlockCache());
    }

    public boolean mightNeedSplitAxisHandling() {
        return false;
    }

    public void cleanup() {
        this.blockCache = null;
        this.blockChangeTracker = null;
        this.blockChangeRef = null;
        this.worldId = null;
    }
}

