/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.collision;

import fr.neatmonster.nocheatplus.utilities.collision.RayTracing;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.map.FakeBlockCache;
import org.bukkit.Location;

public class InteractRayTracing
extends RayTracing {
    protected BlockCache blockCache = null;
    protected final boolean strict;
    protected int lastBx;
    protected int lastBy;
    protected int lastBz;
    protected int targetX;
    protected int targetY;
    protected int targetZ;

    public InteractRayTracing() {
        this(false);
    }

    public InteractRayTracing(boolean strict) {
        this.strict = strict;
        this.forceStepEndPos = false;
    }

    public BlockCache getBlockCache() {
        return this.blockCache;
    }

    public void setBlockCache(BlockCache blockCache) {
        this.blockCache = blockCache;
    }

    public void set(double x0, double y0, double z0, double x1, double y1, double z1) {
        this.set(x0, y0, z0, x1, y1, z1, Location.locToBlock((double)x1), Location.locToBlock((double)y1), Location.locToBlock((double)z1));
    }

    public void set(double x0, double y0, double z0, double x1, double y1, double z1, int targetX, int targetY, int targetZ) {
        super.set(x0, y0, z0, x1, y1, z1);
        this.collides = false;
        this.lastBx = this.blockX;
        this.lastBy = this.blockY;
        this.lastBz = this.blockZ;
        this.targetX = targetX;
        this.targetY = targetY;
        this.targetZ = targetZ;
    }

    public void cleanup() {
        if (this.blockCache != null) {
            this.blockCache = null;
        }
    }

    private boolean doesCollide(int blockX, int blockY, int blockZ) {
        int id = this.blockCache.getTypeId(blockX, blockY, blockZ);
        long flags = BlockProperties.getBlockFlags(id);
        if ((flags & 4L) == 0L) {
            return false;
        }
        if ((flags & 0x40BL) != 0L) {
            return false;
        }
        return this.blockCache.isFullBounds(blockX, blockY, blockZ);
    }

    public boolean isTargetBlock() {
        return this.targetX != Integer.MAX_VALUE && this.blockX == this.targetX && this.blockY == this.targetY && this.blockZ == this.targetZ;
    }

    protected boolean step(int blockX, int blockY, int blockZ, double oX, double oY, double oZ, double dT, boolean isPrimary) {
        if (this.isTargetBlock() || !this.doesCollide(blockX, blockY, blockZ)) {
            if (isPrimary) {
                this.lastBx = blockX;
                this.lastBy = blockY;
                this.lastBz = blockZ;
            }
            return true;
        }
        this.collides = true;
        return false;
    }

    public String getTestCase(double captureMargin, boolean expectCollide) {
        FakeBlockCache recorder = new FakeBlockCache();
        recorder.set(this.blockCache, this.x0, this.y0, this.z0, this.x0 + this.dX, this.y0 + this.dY, this.z0 + this.dZ, captureMargin);
        StringBuilder builder = new StringBuilder(10000);
        builder.append('{');
        recorder.toJava(builder, "fbc", "");
        builder.append("InteractRayTracing rt = new CenteredInteractRayTracing(false, " + this.targetX + ", " + this.targetY + ", " + this.targetZ + "); rt.setBlockCache(fbc);");
        builder.append("TestRayTracing.runCoordinates(rt, new double[]{" + this.x0 + ", " + this.y0 + ", " + this.z0 + ", " + (this.x0 + this.dX) + ", " + (this.y0 + this.dY) + ", " + (this.z0 + this.dZ) + "}, " + expectCollide + ", " + !expectCollide + ", 0.0, false, \"ingame\");");
        builder.append("rt.cleanup(); fbc.cleanup();");
        builder.append('}');
        recorder.cleanup();
        return builder.toString();
    }
}

