/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.collision;

import fr.neatmonster.nocheatplus.components.location.BlockPositionGet;
import fr.neatmonster.nocheatplus.components.location.IAddBlockPosition;
import fr.neatmonster.nocheatplus.components.location.IContainBlockPosition;
import fr.neatmonster.nocheatplus.components.location.IGetBlockPosition;
import java.util.LinkedList;

public class BlockPositionContainer
implements IAddBlockPosition,
IContainBlockPosition {
    private final LinkedList<BlockPositionGet> blocks = new LinkedList();
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;

    public BlockPositionContainer() {
        this.resetBoundaries();
    }

    private void resetBoundaries() {
        this.minX = Integer.MAX_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.minZ = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.maxY = Integer.MIN_VALUE;
        this.maxZ = Integer.MIN_VALUE;
    }

    private void fitBoundaries(int x, int y, int z) {
        this.minX = Math.min(x, this.minX);
        this.minY = Math.min(y, this.minY);
        this.minZ = Math.min(z, this.minZ);
        this.maxX = Math.max(x, this.maxX);
        this.maxY = Math.max(y, this.maxY);
        this.maxZ = Math.max(z, this.maxZ);
    }

    public void addBlockPosition(int x, int y, int z) {
        this.fitBoundaries(x, y, z);
        this.blocks.add(new BlockPositionGet(x, y, z));
    }

    public boolean containsBlockPosition(int x, int y, int z) {
        if (x < this.minX || y < this.minY || z < this.minZ || x > this.maxX || y > this.maxY || z > this.maxZ) {
            return false;
        }
        for (BlockPositionGet pos : this.blocks) {
            if (x != pos.getBlockX() || z != pos.getBlockZ() || y != pos.getBlockY()) continue;
            return true;
        }
        return false;
    }

    public boolean containsBlockPosition(IGetBlockPosition blockPosition) {
        return this.containsBlockPosition(blockPosition.getBlockX(), blockPosition.getBlockY(), blockPosition.getBlockZ());
    }

    public boolean isEmpty() {
        return this.blocks.isEmpty();
    }

    public void clear() {
        if (!this.isEmpty()) {
            this.resetBoundaries();
            this.blocks.clear();
        }
    }
}

