/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    public static final DecimalFormat fdec3 = new DecimalFormat();
    public static final DecimalFormat fdec1 = new DecimalFormat();

    public static <O> String join(O[] input, int startIndex, String link) {
        return StringUtil.join(Arrays.copyOfRange(input, startIndex, input.length), link);
    }

    public static <O> String join(O[] input, String link) {
        return StringUtil.join(Arrays.asList(input), link);
    }

    public static <O> String join(Iterator<O> iterator, String link) {
        StringBuilder builder = new StringBuilder(1024);
        boolean first = true;
        while (iterator.hasNext()) {
            O obj = iterator.next();
            if (!first) {
                builder.append(link);
            }
            builder.append(obj.toString());
            first = false;
        }
        return builder.toString();
    }

    public static <O> String join(Collection<O> input, String link) {
        StringBuilder builder = new StringBuilder(Math.max(300, input.size() * 10));
        boolean first = true;
        for (O obj : input) {
            if (!first) {
                builder.append(link);
            }
            builder.append(obj.toString());
            first = false;
        }
        return builder.toString();
    }

    public static List<String> split(String input, Character ... chars) {
        LinkedList<String> out = new LinkedList<String>();
        out.add(input);
        LinkedList<Object> queue = new LinkedList();
        Character[] characterArray = chars;
        int n = characterArray.length;
        for (int i = 0; i < n; ++i) {
            char c = characterArray[i].charValue();
            String hex = Integer.toHexString(c);
            switch (hex.length()) {
                case 1: {
                    hex = "000" + hex;
                    break;
                }
                case 2: {
                    hex = "00" + hex;
                    break;
                }
                case 3: {
                    hex = "0" + hex;
                }
            }
            for (String s : out) {
                String[] split;
                for (String _s : split = s.split("\\u" + hex)) {
                    queue.add(_s);
                }
            }
            LinkedList<String> temp = out;
            out = queue;
            queue = temp;
            queue.clear();
        }
        return out;
    }

    public static boolean isSimilar(String s, String t, float threshold) {
        return 1.0 - (double)StringUtil.levenshteinDistance(s, t) / Math.max(1.0, (double)Math.max(s.length(), t.length())) > (double)threshold;
    }

    public static int levenshteinDistance(CharSequence s, CharSequence t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (n > m) {
            CharSequence tmp = s;
            s = t;
            t = tmp;
            n = m;
            m = t.length();
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static final String stackTraceToString(Throwable t, boolean header, boolean trim) {
        StringBuilder b = new StringBuilder(325);
        if (header) {
            b.append(t.toString());
            b.append("\n");
        }
        StackTraceElement[] elements = t.getStackTrace();
        StackTraceElement last = null;
        int repetition = 0;
        for (int i = 0; i < elements.length; ++i) {
            StackTraceElement element = elements[i];
            if (trim) {
                if (element.equals(last)) {
                    ++repetition;
                    continue;
                }
                if (repetition > 0) {
                    if (header) {
                        b.append("\t");
                    }
                    b.append("(... repeated " + repetition + " times.)\n");
                    repetition = 0;
                }
                last = element;
            }
            if (header) {
                b.append("\t");
            }
            b.append(element);
            b.append("\n");
        }
        if (repetition > 0) {
            if (header) {
                b.append("\t");
            }
            b.append("(... repeated " + repetition + " times.)\n");
        }
        return b.toString();
    }

    public static final String throwableToString(Throwable t) {
        return StringUtil.stackTraceToString(t, true, true);
    }

    public static final int count(String dartBoard, char needles) {
        int n = 0;
        int index = 0;
        while (index != -1) {
            if ((index = dartBoard.indexOf(needles, index)) == -1) continue;
            ++n;
            ++index;
        }
        return n;
    }

    public static final String leftTrim(String input) {
        if (input == null) {
            return null;
        }
        int len = input.length();
        int beginIndex = 0;
        for (int i = 0; i < len && Character.isWhitespace(input.charAt(i)); ++i) {
            ++beginIndex;
        }
        if (beginIndex > 0) {
            if (beginIndex >= len) {
                return "";
            }
            return input.substring(beginIndex);
        }
        return input;
    }

    public static String formatDiff(double current, double previous) {
        return current == previous ? "0" : (current > previous ? "+" : "-") + fdec3.format(Math.abs(current - previous));
    }

    static {
        DecimalFormatSymbols sym = fdec3.getDecimalFormatSymbols();
        sym.setDecimalSeparator('.');
        fdec3.setDecimalFormatSymbols(sym);
        fdec3.setMaximumFractionDigits(3);
        fdec3.setMinimumIntegerDigits(1);
        sym = fdec1.getDecimalFormatSymbols();
        sym.setDecimalSeparator('.');
        fdec1.setDecimalFormatSymbols(sym);
        fdec1.setMaximumFractionDigits(1);
        fdec1.setMinimumIntegerDigits(1);
    }
}

