/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.players;

import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class PlayerMap {
    private final boolean storePlayerInstances;
    private final boolean hasGetPlayer_UUID = ReflectionUtil.getMethod(Bukkit.class, "getPlayer", UUID.class) != null;
    private Map<UUID, PlayerInfo> idInfoMap = new HashMap<UUID, PlayerInfo>();
    private Map<String, PlayerInfo> exactNameInfoMap = new HashMap<String, PlayerInfo>();
    private Map<String, PlayerInfo> lowerCaseNameInfoMap = new HashMap<String, PlayerInfo>();

    public PlayerMap(boolean storePlayerInstances) {
        this.storePlayerInstances = storePlayerInstances;
        if (storePlayerInstances) {
            StaticLog.logInfo("Player instances are stored for efficiency.");
        }
    }

    public boolean storesPlayerInstances() {
        return this.storePlayerInstances;
    }

    public boolean hasPlayerInfo(UUID id) {
        return this.idInfoMap.containsKey(id);
    }

    public boolean hasPlayerInfoExact(String exactName) {
        return this.exactNameInfoMap.containsKey(exactName);
    }

    public boolean hasPlayerInfo(String probableName) {
        return this.hasPlayerInfoLowerCase(probableName.toLowerCase());
    }

    public boolean hasPlayerInfoLowerCase(String lowerCaseName) {
        return this.lowerCaseNameInfoMap.containsKey(lowerCaseName);
    }

    public PlayerInfo getPlayerInfo(UUID id) {
        return this.idInfoMap.get(id);
    }

    public PlayerInfo getPlayerInfoExact(String exactName) {
        return this.exactNameInfoMap.get(exactName);
    }

    public PlayerInfo getPlayerInfo(String probableName) {
        return this.getPlayerInfoLowerCase(probableName.toLowerCase());
    }

    public PlayerInfo getPlayerInfoLowerCase(String lowerCaseName) {
        return this.lowerCaseNameInfoMap.get(lowerCaseName);
    }

    public Player getPlayer(UUID id) {
        PlayerInfo info = this.idInfoMap.get(id);
        if (info != null) {
            if (info.player != null) {
                return info.player;
            }
            if (this.storePlayerInstances) {
                info.player = this.getPlayerBukkit(info);
                return info.player;
            }
            return this.getPlayerBukkit(info);
        }
        return this.getPlayerBukkit(id);
    }

    public Player getPlayerExact(String exactName) {
        PlayerInfo info = this.exactNameInfoMap.get(exactName);
        if (info != null) {
            if (info.player != null) {
                return info.player;
            }
            if (this.storePlayerInstances) {
                info.player = this.getPlayerBukkit(info);
                return info.player;
            }
            return this.getPlayerBukkit(info);
        }
        return Bukkit.getPlayerExact((String)exactName);
    }

    public Player getPlayer(String probableName) {
        return this.getPlayerLowerCase(probableName.toLowerCase());
    }

    public Player getPlayerLowerCase(String lowerCaseName) {
        PlayerInfo info = this.lowerCaseNameInfoMap.get(lowerCaseName);
        if (info != null) {
            if (info.player != null) {
                return info.player;
            }
            if (this.storePlayerInstances) {
                info.player = this.getPlayerBukkit(info);
                return info.player;
            }
            return this.getPlayerBukkit(info);
        }
        return Bukkit.getPlayer((String)lowerCaseName);
    }

    public PlayerInfo updatePlayer(Player player) {
        UUID id = player.getUniqueId();
        String exactName = player.getName();
        PlayerInfo info = this.idInfoMap.get(id);
        if (info != null) {
            if (info.matchesExact(id, exactName)) {
                if (this.storePlayerInstances) {
                    info.player = player;
                }
                return info;
            }
            this.remove(info);
        }
        info = new PlayerInfo(id, exactName);
        if (this.storePlayerInstances) {
            info.player = player;
        }
        this.ensureRemoved(info);
        this.idInfoMap.put(id, info);
        this.exactNameInfoMap.put(exactName, info);
        this.lowerCaseNameInfoMap.put(info.lowerCaseName, info);
        return info;
    }

    public void removePlayerInstance(UUID id) {
        PlayerInfo info = this.idInfoMap.get(id);
        if (info != null) {
            info.player = null;
        }
    }

    public boolean remove(Player player) {
        return this.ensureRemoved(new PlayerInfo(player.getUniqueId(), player.getName()));
    }

    public void clear() {
        this.idInfoMap.clear();
        this.exactNameInfoMap.clear();
        this.lowerCaseNameInfoMap.clear();
    }

    public int size() {
        return this.idInfoMap.size();
    }

    private Player getPlayerBukkit(UUID id) {
        if (this.hasGetPlayer_UUID) {
            return Bukkit.getPlayer((UUID)id);
        }
        return this.scanForPlayer(id);
    }

    private Player scanForPlayer(UUID id) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!id.equals(player.getUniqueId())) continue;
            return player;
        }
        return null;
    }

    private Player getPlayerBukkit(PlayerInfo info) {
        if (this.hasGetPlayer_UUID) {
            return Bukkit.getPlayer((UUID)info.id);
        }
        return Bukkit.getPlayerExact((String)info.exactName);
    }

    private boolean ensureRemoved(PlayerInfo info) {
        PlayerInfo ref = this.idInfoMap.get(info.id);
        boolean changed = false;
        if (ref != null) {
            this.remove(ref);
            changed = true;
        }
        if ((ref = this.exactNameInfoMap.get(info.exactName)) != null) {
            this.remove(ref);
            changed = true;
        }
        if ((ref = this.lowerCaseNameInfoMap.get(info.lowerCaseName)) != null) {
            this.remove(ref);
            changed = true;
        }
        return changed;
    }

    private boolean remove(PlayerInfo info) {
        boolean altered = false;
        altered |= this.idInfoMap.remove(info.id) != null;
        altered |= this.exactNameInfoMap.remove(info.exactName) != null;
        return altered |= this.lowerCaseNameInfoMap.remove(info.lowerCaseName) != null;
    }

    public static final class PlayerInfo {
        public final UUID id;
        public final String exactName;
        public final String lowerCaseName;
        public Player player = null;

        public PlayerInfo(UUID id, String exactName) {
            this.id = id;
            this.exactName = exactName;
            this.lowerCaseName = exactName.toLowerCase();
        }

        public boolean matchesExact(UUID id, String exactName) {
            return this.id.equals(id) && this.exactName.equals(exactName);
        }
    }
}

