/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.logging;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.logging.StreamID;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.Date;
import java.util.logging.Level;

public class StaticLog {
    private static boolean useLogManager = false;
    private static StreamID streamID = Streams.INIT;

    public static void setUseLogManager(boolean useLogManager) {
        StaticLog.useLogManager = useLogManager;
    }

    public static void setStreamID(StreamID streamID) {
        if (streamID == null) {
            throw new NullPointerException("StreamID must not be null, use setUseLogManager(false) instead.");
        }
        StaticLog.streamID = streamID;
    }

    public static void logInfo(String msg) {
        StaticLog.log(Level.INFO, msg);
    }

    public static void logWarning(String msg) {
        StaticLog.log(Level.WARNING, msg);
    }

    public static void logSevere(String msg) {
        StaticLog.log(Level.SEVERE, msg);
    }

    public static void logInfo(Throwable t) {
        StaticLog.log(Level.INFO, StringUtil.throwableToString(t));
    }

    public static void logWarning(Throwable t) {
        StaticLog.log(Level.WARNING, StringUtil.throwableToString(t));
    }

    public static void logSevere(Throwable t) {
        StaticLog.log(Level.SEVERE, StringUtil.throwableToString(t));
    }

    public static void log(Level level, String msg) {
        if (useLogManager) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().log(streamID, level, msg);
        } else {
            System.out.println("[" + level + "][NoCheatPlus] " + new Date());
            System.out.println(msg);
        }
    }
}

