/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.event;

import fr.neatmonster.nocheatplus.components.registry.feature.ComponentWithName;
import fr.neatmonster.nocheatplus.event.GenericListener;
import fr.neatmonster.nocheatplus.event.IHaveMethodOrder;
import fr.neatmonster.nocheatplus.event.MethodOrder;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import java.lang.reflect.Method;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerManager {
    protected Map<Class<? extends Event>, EnumMap<EventPriority, GenericListener<?>>> map = new HashMap();
    private final Plugin plugin;
    private boolean registerDirectly;

    public ListenerManager(Plugin plugin) {
        this(plugin, false);
    }

    public ListenerManager(Plugin plugin, boolean registerDirectly) {
        this.plugin = plugin;
        this.registerDirectly = true;
    }

    public <E extends Event> GenericListener<E> getListener(Class<E> clazz, EventPriority priority) {
        GenericListener<Object> listener;
        EnumMap<EventPriority, GenericListener<Object>> prioMap = this.map.get(clazz);
        if (prioMap == null) {
            prioMap = new EnumMap(EventPriority.class);
            this.map.put(clazz, prioMap);
        }
        if ((listener = prioMap.get(priority)) == null) {
            listener = new GenericListener<E>(clazz, priority);
            prioMap.put(priority, listener);
        }
        if (this.registerDirectly && !listener.isRegistered()) {
            listener.register(this.plugin);
        }
        return listener;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public boolean isRegisterDirectly() {
        return this.registerDirectly;
    }

    public void setRegisterDirectly(boolean registerDirectly) {
        this.registerDirectly = registerDirectly;
    }

    public void registerAllWithBukkit() {
        for (EnumMap<EventPriority, GenericListener<?>> prioMap : this.map.values()) {
            for (GenericListener<?> listener : prioMap.values()) {
                if (listener.isRegistered()) continue;
                listener.register(this.plugin);
            }
        }
    }

    public void clear() {
        for (Map map : this.map.values()) {
            for (GenericListener listener : map.values()) {
                listener.clear();
            }
        }
        this.map.clear();
    }

    public void registerAllEventHandlers(Listener listener, String tag) {
        this.registerAllEventHandlers(listener, tag, null);
    }

    public void registerAllEventHandlers(Listener listener, String tag, GenericListener.MethodEntry.MethodOrder order) {
        if (listener instanceof IHaveMethodOrder) {
            order = ((IHaveMethodOrder)listener).getMethodOrder();
        }
        if (listener instanceof ComponentWithName) {
            tag = ((ComponentWithName)listener).getComponentName();
        }
        Class<?> clazz = listener.getClass();
        HashSet<Method> allMethods = new HashSet<Method>();
        for (Method method : clazz.getMethods()) {
            allMethods.add(method);
        }
        for (Method method : clazz.getDeclaredMethods()) {
            allMethods.add(method);
        }
        for (Method method : allMethods) {
            Class<?>[] argTypes;
            EventHandler anno = method.getAnnotation(EventHandler.class);
            if (anno == null) continue;
            if (!method.isAccessible()) {
                try {
                    method.setAccessible(true);
                }
                catch (SecurityException e) {
                    StaticLog.logWarning("[ListenerManager]  Can not set method accessible: " + method.toGenericString() + " registered in " + clazz.getName() + ", ignoring it!");
                }
            }
            if ((argTypes = method.getParameterTypes()).length != 1) {
                StaticLog.logWarning("[ListenerManager] Bad method signature (number of arguments not 1): " + method.toGenericString() + " registered in " + clazz.getName() + ", ignoring it!");
                continue;
            }
            Class<?> eventType = argTypes[0];
            if (!Event.class.isAssignableFrom(eventType)) {
                StaticLog.logWarning("[ListenerManager] Bad method signature (argument does not extend Event): " + method.toGenericString() + " registered in " + clazz.getName() + ", ignoring it!");
                continue;
            }
            Class<Event> checkedEventType = eventType.asSubclass(Event.class);
            GenericListener.MethodEntry.MethodOrder tempOrder = order;
            String tempTag = tag;
            MethodOrder orderAnno = method.getAnnotation(MethodOrder.class);
            if (orderAnno != null) {
                tempOrder = GenericListener.MethodEntry.MethodOrder.getMethodOrder(orderAnno);
                GenericListener.MethodEntry.MethodOrder veryTempOrder = tempOrder;
                if (veryTempOrder != null) {
                    tempOrder = veryTempOrder;
                }
                if (!orderAnno.tag().isEmpty()) {
                    tempTag = orderAnno.tag();
                }
            }
            this.getListener(checkedEventType, anno.priority()).addMethodEntry(new GenericListener.MethodEntry(listener, method, anno.ignoreCancelled(), tempTag, tempOrder));
        }
    }

    public void remove(Listener listener) {
        for (Map map : this.map.values()) {
            for (GenericListener gl : map.values()) {
                gl.remove(listener);
            }
        }
    }

    public boolean hasListeners() {
        return !this.map.isEmpty();
    }

    public boolean hasRegisteredListeners() {
        for (Map map : this.map.values()) {
            for (GenericListener gl : map.values()) {
                if (!gl.isRegistered()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPendingListeners() {
        for (Map map : this.map.values()) {
            for (GenericListener gl : map.values()) {
                if (gl.isRegistered()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasListenerMethods() {
        for (Map map : this.map.values()) {
            for (GenericListener gl : map.values()) {
                if (!gl.hasListenerMethods()) continue;
                return true;
            }
        }
        return false;
    }
}

