/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.config;

import fr.neatmonster.nocheatplus.actions.ActionFactory;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.DefaultConfig;
import fr.neatmonster.nocheatplus.config.PathUtils;
import fr.neatmonster.nocheatplus.config.WorldConfigProvider;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.build.BuildParameters;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigManager {
    private static ActionFactoryFactory actionFactoryFactory = new ActionFactoryFactory(){

        @Override
        public final ActionFactory newActionFactory(Map<String, Object> library) {
            return new ActionFactory(library);
        }
    };
    private static Map<String, ConfigFile> worldsMap = new LinkedHashMap<String, ConfigFile>();
    private static final WorldConfigProvider<ConfigFile> worldConfigProvider = new WorldConfigProvider<ConfigFile>(){

        @Override
        public ConfigFile getDefaultConfig() {
            return ConfigManager.getConfigFile();
        }

        @Override
        public ConfigFile getConfig(String worldName) {
            return ConfigManager.getConfigFile(worldName);
        }

        @Override
        public Collection<ConfigFile> getAllConfigs() {
            return worldsMap.values();
        }
    };
    private static boolean isInitialized = false;

    public static ActionFactory getActionFactory(Map<String, Object> library) {
        return actionFactoryFactory.newActionFactory(library);
    }

    public static void setActionFactoryFactory(ActionFactoryFactory factory) {
        actionFactoryFactory = factory != null ? factory : new ActionFactoryFactory(){

            @Override
            public final ActionFactory newActionFactory(Map<String, Object> library) {
                return new ActionFactory(library);
            }
        };
        for (ConfigFile config : worldsMap.values()) {
            config.setActionFactory(null);
        }
    }

    public static ActionFactoryFactory getActionFactoryFactory() {
        return actionFactoryFactory;
    }

    public static void setAllActionFactories() {
        for (ConfigFile config : worldsMap.values()) {
            config.setActionFactory();
        }
    }

    public static WorldConfigProvider<ConfigFile> getWorldConfigProvider() {
        return worldConfigProvider;
    }

    public static void cleanup() {
        isInitialized = false;
        ConfigManager.setActionFactoryFactory(null);
    }

    public static ConfigFile getConfigFile() {
        return worldsMap.get(null);
    }

    @Deprecated
    public static synchronized ConfigFile getConfigFileSync() {
        return ConfigManager.getConfigFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigFile getConfigFile(String worldName) {
        ConfigFile configFile = worldsMap.get(worldName);
        if (configFile != null) {
            return configFile;
        }
        Class<ConfigManager> clazz = ConfigManager.class;
        synchronized (ConfigManager.class) {
            if (worldsMap.containsKey(worldName)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return worldsMap.get(worldName);
            }
            LinkedHashMap<String, ConfigFile> newWorldsMap = new LinkedHashMap<String, ConfigFile>(worldsMap);
            ConfigFile globalConfig = (ConfigFile)((Object)newWorldsMap.get(null));
            newWorldsMap.put(worldName, globalConfig);
            worldsMap = newWorldsMap;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return globalConfig;
        }
    }

    @Deprecated
    public static synchronized ConfigFile getConfigFileSync(String worldName) {
        return ConfigManager.getConfigFile(worldName);
    }

    public static synchronized void init(Plugin plugin) {
        LinkedHashMap<String, ConfigFile> newWorldsMap = new LinkedHashMap<String, ConfigFile>();
        File globalFile = new File(plugin.getDataFolder(), "config.yml");
        DefaultConfig defaultConfig = new DefaultConfig();
        int maxBuildContained = defaultConfig.getMaxLastChangedBuildNumber();
        PathUtils.processPaths(globalFile, "global config", false);
        ConfigFile globalConfig = new ConfigFile();
        globalConfig.setDefaults((Configuration)defaultConfig);
        globalConfig.options().copyDefaults(true);
        if (globalFile.exists()) {
            try {
                globalConfig.load(globalFile);
                try {
                    if (globalConfig.getBoolean("savebackconfig")) {
                        boolean overrideCreated = false;
                        if (!globalConfig.contains("configversion.created")) {
                            overrideCreated = true;
                        }
                        if (!overrideCreated && globalConfig.getInt("configversion.created", 0) >= 0 && ConfigManager.isConfigUpToDate(globalConfig) == null) {
                            overrideCreated = true;
                        }
                        globalConfig.set("configversion.saved", maxBuildContained);
                        if (overrideCreated) {
                            globalConfig.set("configversion.created", maxBuildContained);
                        }
                        globalConfig.save(globalFile);
                    }
                }
                catch (Exception e) {
                    StaticLog.logSevere("Could not save back config.yml (see exception below).");
                    StaticLog.logSevere(e);
                }
            }
            catch (Exception e) {
                StaticLog.logSevere("Could not load config.yml (see exception below). Continue with default settings...");
                StaticLog.logSevere(e);
            }
        } else {
            globalConfig.options().header("This configuration was auto-generated by NoCheatPlus.");
            globalConfig.options().copyHeader(true);
            try {
                globalConfig.set("configversion.created", maxBuildContained);
                globalConfig.set("configversion.saved", maxBuildContained);
                globalConfig.save(globalFile);
            }
            catch (Exception e) {
                StaticLog.logSevere(e);
            }
        }
        newWorldsMap.put(null, globalConfig);
        MemoryConfiguration worldDefaults = PathUtils.getWorldsDefaultConfig((MemoryConfiguration)globalConfig);
        HashMap<String, Object> worldFiles = new HashMap<String, Object>();
        if (plugin.getDataFolder().isDirectory()) {
            for (File file : plugin.getDataFolder().listFiles()) {
                String fileName;
                if (!file.isFile() || !(fileName = file.getName()).matches(".+_config.yml$")) continue;
                String worldname = fileName.substring(0, fileName.length() - 11);
                worldFiles.put(worldname, file);
            }
        }
        for (Map.Entry entry : worldFiles.entrySet()) {
            File worldFile = (File)entry.getValue();
            PathUtils.processPaths(worldFile, "world " + (String)entry.getKey(), true);
            ConfigFile worldConfig = new ConfigFile();
            worldConfig.setDefaults((Configuration)worldDefaults);
            worldConfig.options().copyDefaults(true);
            try {
                worldConfig.load(worldFile);
                newWorldsMap.put((String)entry.getKey(), worldConfig);
                try {
                    if (worldConfig.getBoolean("savebackconfig")) {
                        worldConfig.save(worldFile);
                    }
                }
                catch (Exception e) {
                    StaticLog.logSevere("Couldn't save back world-specific configuration for " + (String)entry.getKey() + " (see exception below).");
                    StaticLog.logSevere(e);
                }
            }
            catch (Exception e) {
                StaticLog.logSevere("Couldn't load world-specific configuration for " + (String)entry.getKey() + " (see exception below). Continue with global default settings...");
                StaticLog.logSevere(e);
            }
            worldConfig.setDefaults((Configuration)globalConfig);
            worldConfig.options().copyDefaults(true);
        }
        worldsMap = newWorldsMap;
        isInitialized = true;
    }

    public static String isConfigUpToDate(ConfigFile globalConfig) {
        Object created_o = globalConfig.get("configversion.created");
        int buildCreated = -1;
        if (created_o != null && created_o instanceof Integer) {
            buildCreated = (Integer)created_o;
        }
        if (buildCreated < 0) {
            return null;
        }
        int maxBuildContained = globalConfig.getMaxLastChangedBuildNumber();
        int currentBuild = BuildParameters.buildNumber;
        if (currentBuild != Integer.MIN_VALUE && buildCreated > Math.max(maxBuildContained, currentBuild)) {
            return "Your configuration seems to be created by a newer plugin version.\nSome settings could have changed, you should regenerate it!";
        }
        LinkedList<String> problems = new LinkedList<String>();
        DefaultConfig defaultConfig = new DefaultConfig();
        Map<String, Integer> lastChangedBuildNumbers = defaultConfig.getLastChangedBuildNumbers();
        for (Map.Entry<String, Integer> entry : lastChangedBuildNumbers.entrySet()) {
            int defaultBuild = entry.getValue();
            if (defaultBuild <= buildCreated) continue;
            String path = entry.getKey();
            Object defaultValue = defaultConfig.get(path);
            if (defaultValue instanceof ConfigurationSection) {
                problems.add("Changed with build " + defaultBuild + ", can not handle entire configuration sections yet: " + path);
                continue;
            }
            Object currentValue = globalConfig.get(path);
            if (currentValue == null || defaultValue == null || defaultBuild <= buildCreated || defaultValue.equals(currentValue)) continue;
            problems.add("Changed with build " + defaultBuild + ": " + path);
        }
        if (!problems.isEmpty()) {
            problems.add(0, "The following configuration default values have changed:");
            problems.add("(Remove/update individual values or set configversion.created to " + maxBuildContained + " to ignore all, then reload the configuration with the 'ncp reload' command.)");
            return StringUtil.join(problems, "\n");
        }
        return null;
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static synchronized void setForAllConfigs(String path, Object value) {
        LinkedHashMap<String, ConfigFile> newWorldsMap = new LinkedHashMap<String, ConfigFile>(worldsMap);
        for (ConfigFile cfg : newWorldsMap.values()) {
            cfg.set(path, value);
        }
        worldsMap = newWorldsMap;
    }

    public static boolean isTrueForAnyConfig(String path) {
        for (ConfigFile cfg : worldsMap.values()) {
            if (!cfg.getBoolean(path, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAlmostTrueForAnyConfig(String path, boolean decideOptimistically, boolean trueForNotSet) {
        for (ConfigFile cfg : worldsMap.values()) {
            if (!cfg.getAlmostBoolean(path, decideOptimistically, trueForNotSet)) continue;
            return true;
        }
        return false;
    }

    public static Double getMaxNumberForAllConfigs(String path) {
        Number max = null;
        for (ConfigFile config : worldsMap.values()) {
            try {
                Object obj = config.get(path);
                if (!(obj instanceof Number)) continue;
                Number num = (Number)obj;
                if (max != null && !(num.doubleValue() > max.doubleValue())) continue;
                max = num;
            }
            catch (Throwable throwable) {}
        }
        return max.doubleValue();
    }

    public static Double getMinNumberForAllConfigs(String path) {
        Number min = null;
        for (ConfigFile config : worldsMap.values()) {
            try {
                Object obj = config.get(path);
                if (!(obj instanceof Number)) continue;
                Number num = (Number)obj;
                if (min != null && !(num.doubleValue() < min.doubleValue())) continue;
                min = num;
            }
            catch (Throwable throwable) {}
        }
        return min.doubleValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ActionFactoryFactory {
        public ActionFactory newActionFactory(Map<String, Object> var1);
    }
}

