/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.components.pool;

import fr.neatmonster.nocheatplus.components.pool.GenericPool;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPool<O>
implements GenericPool<O> {
    private final int maxPoolSize;
    private final ArrayList<O> pool;

    protected AbstractPool(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        this.pool = new ArrayList(Math.max(10, maxPoolSize));
    }

    @Override
    public O getInstance() {
        if (!this.pool.isEmpty()) {
            return this.pool.remove(this.pool.size() - 1);
        }
        return this.newInstance();
    }

    @Override
    public void returnInstance(O instance) {
        if (instance == null) {
            throw new NullPointerException("The passed instance must not be null.");
        }
        if (this.maxPoolSize <= 0 || this.pool.size() < this.maxPoolSize) {
            this.pool.add(instance);
        }
    }

    protected abstract O newInstance();
}

