/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.versions;

import java.util.Arrays;

public class GenericVersion {
    public static final String UNKNOWN_VERSION = "unknown";

    public static boolean isVersionUnknown(String version) {
        return UNKNOWN_VERSION.equals(version);
    }

    public static int[] versionToInt(String version) {
        String[] split = version.split("\\.");
        int[] num = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            num[i] = Integer.parseInt(split[i]);
        }
        return num;
    }

    public static String truncateVersion(String version, int maxDivisions) {
        int[] oldInts = GenericVersion.versionToInt(version);
        if (oldInts.length <= maxDivisions) {
            return version;
        }
        int[] newInts = Arrays.copyOf(oldInts, maxDivisions);
        StringBuilder builder = new StringBuilder(version.length());
        builder.append(Integer.toString(newInts[0]));
        for (int i = 1; i < newInts.length; ++i) {
            builder.append(".");
            builder.append(Integer.toString(newInts[i]));
        }
        return builder.toString();
    }

    public static String padVersion(String version, int minDivisions) {
        int oldSize = GenericVersion.getVersionDivisions(version);
        if (oldSize >= minDivisions) {
            return version;
        }
        StringBuilder builder = new StringBuilder(version.length() + minDivisions * 4);
        builder.append(version);
        for (int i = oldSize; i < minDivisions; ++i) {
            builder.append(".0");
        }
        return builder.toString();
    }

    public static String ensureVersionDivisions(String version, int divisions) {
        return GenericVersion.truncateVersion(GenericVersion.padVersion(version, divisions), divisions);
    }

    public static String[] padVersions(String ... versions) {
        int maxDivisions = 0;
        for (int i = 0; i < versions.length; ++i) {
            maxDivisions = Math.max(maxDivisions, GenericVersion.getVersionDivisions(versions[i]));
        }
        String[] out = new String[versions.length];
        for (int i = 0; i < versions.length; ++i) {
            out[i] = GenericVersion.ensureVersionDivisions(versions[i], maxDivisions);
        }
        return out;
    }

    public static int getVersionDivisions(String version) {
        return GenericVersion.versionToInt(version).length;
    }

    public static int compareVersions(String version1, String version2) {
        if (version2.equals(UNKNOWN_VERSION)) {
            throw new IllegalArgumentException("version2 must not be 'unknown'.");
        }
        if (version1.equals(UNKNOWN_VERSION)) {
            return -1;
        }
        if (version1.equals(version2)) {
            return 0;
        }
        try {
            int[] v1Int = GenericVersion.versionToInt(version1);
            int[] v2Int = GenericVersion.versionToInt(version2);
            for (int i = 0; i < Math.min(v1Int.length, v2Int.length); ++i) {
                if (v1Int[i] < v2Int[i]) {
                    return -1;
                }
                if (v1Int[i] <= v2Int[i]) continue;
                return 1;
            }
            if (v1Int.length < v2Int.length) {
                return -1;
            }
            if (v1Int.length > v2Int.length) {
                return 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Bad version input.");
    }

    public static String parseVersionDelimiters(String input, String prefix, String suffix) {
        int preIndex;
        int n = preIndex = prefix.isEmpty() ? 0 : input.indexOf(prefix);
        if (preIndex != -1) {
            int postIndex;
            String candidate = input.substring(preIndex + prefix.length());
            int n2 = postIndex = suffix.isEmpty() ? candidate.length() : candidate.indexOf(suffix);
            if (postIndex != -1) {
                return GenericVersion.collectVersion(candidate.substring(0, postIndex).trim(), 0);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String collectVersion(String input, int beginIndex) {
        StringBuilder buffer = new StringBuilder(128);
        boolean numberFound = false;
        char[] chars = input.toCharArray();
        for (int i = beginIndex; i < input.length(); ++i) {
            char c = chars[i];
            if (c == '.') {
                if (!numberFound) return null;
                numberFound = false;
            } else {
                if (!Character.isDigit(c)) {
                    return null;
                }
                numberFound = true;
            }
            buffer.append(c);
        }
        if (!numberFound) return null;
        return buffer.toString();
    }

    public static boolean isVersionBetween(String version, String versionLow, boolean includeLow, String versionHigh, boolean includeHigh) {
        if (includeLow ? GenericVersion.compareVersions(version, versionLow) == -1 : GenericVersion.compareVersions(version, versionLow) <= 0) {
            return false;
        }
        return !(includeHigh ? GenericVersion.compareVersions(version, versionHigh) == 1 : GenericVersion.compareVersions(version, versionHigh) >= 0);
    }
}

