/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.versions;

import fr.neatmonster.nocheatplus.compat.versions.Bugs;
import fr.neatmonster.nocheatplus.compat.versions.GenericVersion;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import org.bukkit.Bukkit;
import org.bukkit.Server;

public class BukkitVersion {
    private static boolean initialized = false;
    private static boolean uniqueIdOnline = false;
    private static boolean uniqueIdOffline = false;

    public static boolean init() {
        if (initialized) {
            return false;
        }
        Server server = Bukkit.getServer();
        ServerVersion.setMinecraftVersion(ServerVersion.parseMinecraftVersion(server.getBukkitVersion(), server.getVersion()));
        boolean uuidOnline = false;
        boolean uuidOffline = false;
        String mcVersion = ServerVersion.getMinecraftVersion();
        int cmp = -1;
        try {
            cmp = GenericVersion.compareVersions(mcVersion, "1.7.5");
        }
        catch (IllegalArgumentException e) {
            mcVersion = "unknown";
        }
        if (!"unknown".equals(mcVersion)) {
            if (cmp == 1) {
                uuidOnline = true;
                uuidOffline = true;
            } else if (GenericVersion.compareVersions(mcVersion, "1.7") == 1) {
                uuidOnline = true;
                uuidOffline = false;
            }
        }
        uniqueIdOnline = uuidOnline;
        uniqueIdOffline = uuidOffline;
        initialized = true;
        Bugs.init();
        return true;
    }

    public static boolean uniqueIdOnline() {
        return uniqueIdOnline;
    }

    public static void setUniqueIdOnline(boolean uniqueIdOnline) {
        BukkitVersion.uniqueIdOnline = uniqueIdOnline;
    }

    public static boolean uniqueIdOffline() {
        return uniqueIdOffline;
    }

    public static void setUniqueIdOffline(boolean uniqueIdOffline) {
        BukkitVersion.uniqueIdOffline = uniqueIdOffline;
    }

    public static String getMinecraftVersion() {
        return ServerVersion.getMinecraftVersion();
    }
}

