/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.spigotcb1_9_R1;

import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import java.util.List;
import net.minecraft.server.v1_9_R1.AxisAlignedBB;
import net.minecraft.server.v1_9_R1.Block;
import net.minecraft.server.v1_9_R1.BlockPosition;
import net.minecraft.server.v1_9_R1.Entity;
import net.minecraft.server.v1_9_R1.EntityBoat;
import net.minecraft.server.v1_9_R1.EntityShulker;
import net.minecraft.server.v1_9_R1.EnumDirection;
import net.minecraft.server.v1_9_R1.IBlockAccess;
import net.minecraft.server.v1_9_R1.IBlockData;
import net.minecraft.server.v1_9_R1.TileEntity;
import net.minecraft.server.v1_9_R1.WorldServer;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_9_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_9_R1.entity.CraftEntity;

public class BlockCacheSpigotCB1_9_R1
extends BlockCache
implements IBlockAccess {
    protected WorldServer world;
    protected World bukkitWorld;

    public BlockCacheSpigotCB1_9_R1(World world) {
        this.setAccess(world);
    }

    public BlockCache setAccess(World world) {
        if (world != null) {
            this.maxBlockY = world.getMaxHeight() - 1;
            this.world = ((CraftWorld)world).getHandle();
            this.bukkitWorld = world;
        } else {
            this.world = null;
            this.bukkitWorld = null;
        }
        return this;
    }

    public int fetchTypeId(int x, int y, int z) {
        return this.bukkitWorld.getBlockTypeIdAt(x, y, z);
    }

    public int fetchData(int x, int y, int z) {
        return this.bukkitWorld.getBlockAt(x, y, z).getData();
    }

    public double[] fetchBounds(int x, int y, int z) {
        int id = this.getTypeId(x, y, z);
        Block block = Block.getById((int)id);
        if (block == null) {
            return null;
        }
        BlockPosition pos = new BlockPosition(x, y, z);
        AxisAlignedBB bb = block.a(this.getType(pos), (IBlockAccess)this, pos);
        if (bb == null) {
            return new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
        }
        return new double[]{bb.a, bb.b, bb.c, bb.d, bb.e, bb.f};
    }

    public boolean standsOnEntity(org.bukkit.entity.Entity entity, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        try {
            Entity mcEntity = ((CraftEntity)entity).getHandle();
            AxisAlignedBB box = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
            List list = this.world.getEntities(mcEntity, box);
            for (Entity other : list) {
                if (mcEntity == other || !(other instanceof EntityBoat) && !(other instanceof EntityShulker)) continue;
                if (minY >= other.locY && minY - other.locY <= 0.7) {
                    return true;
                }
                AxisAlignedBB otherBox = other.getBoundingBox();
                if (box.a > otherBox.d || box.d < otherBox.a || box.b > otherBox.e || box.e < otherBox.b || box.c > otherBox.f || box.f < otherBox.c) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public void cleanup() {
        super.cleanup();
        this.world = null;
        this.bukkitWorld = null;
    }

    public int getBlockPower(BlockPosition pos, EnumDirection dir) {
        return this.world.getBlockPower(pos, dir);
    }

    public TileEntity getTileEntity(BlockPosition pos) {
        return this.world.getTileEntity(pos);
    }

    public IBlockData getType(BlockPosition pos) {
        return this.world.getType(pos);
    }

    public boolean isEmpty(BlockPosition pos) {
        return this.world.isEmpty(pos);
    }
}

