/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.registry;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.compat.registry.MCAccessConfig;
import fr.neatmonster.nocheatplus.logging.Streams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryHelper {
    public static <T> T setupGenericInstance(String[] cbDedicatedNames, String[] cbReflectNames, Class<T> registerFor, MCAccessConfig config, boolean logDebug) {
        return RegistryHelper.setupGenericInstance(cbDedicatedNames, cbReflectNames, null, registerFor, config, logDebug);
    }

    public static <T> T setupGenericInstance(String[] cbDedicatedNames, String[] cbReflectNames, T fallBackInstance, Class<T> registerFor, MCAccessConfig config, boolean logDebug) {
        return RegistryHelper.setupGenericInstance(cbDedicatedNames, null, cbReflectNames, fallBackInstance, registerFor, config, logDebug);
    }

    public static <T> T setupGenericInstance(String[] cbDedicatedNames, T fallBackDedicatedInstance, String[] cbReflectNames, T fallBackReflectInstance, Class<T> registerFor, MCAccessConfig config, boolean logDebug) {
        T res = null;
        if (config.enableCBDedicated && cbDedicatedNames != null) {
            res = RegistryHelper.getFirstAvailable(cbDedicatedNames, registerFor, logDebug);
        }
        if (res == null && fallBackDedicatedInstance != null) {
            res = fallBackDedicatedInstance;
        }
        if (res == null && config.enableCBReflect && cbReflectNames != null) {
            res = RegistryHelper.getFirstAvailable(cbReflectNames, registerFor, logDebug);
        }
        if (res == null && fallBackReflectInstance != null) {
            res = fallBackReflectInstance;
        }
        RegistryHelper.registerGenericInstance(registerFor, res);
        return res;
    }

    public static <T> T getFirstAvailable(String[] classNames, Class<T> registerFor, boolean logDebug) {
        T res = null;
        for (String name : classNames) {
            try {
                res = (T)Class.forName(name).newInstance();
                if (res == null) continue;
                return res;
            }
            catch (Throwable t) {
                if (!logDebug) continue;
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, t);
            }
        }
        return null;
    }

    public static <T, ET extends T> T registerGenericInstance(Class<T> registerFor, ET result) {
        if (result != null) {
            NCPAPIProvider.getNoCheatPlusAPI().registerGenericInstance(registerFor, result);
        } else {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().info(Streams.STATUS, "Could not register an instance for: " + registerFor.getName());
        }
        return result;
    }

    public static <T> T registerFirstAvailable(String[] classNames, Class<T> registerFor, boolean logDebug) {
        return RegistryHelper.registerGenericInstance(registerFor, RegistryHelper.getFirstAvailable(classNames, registerFor, logDebug));
    }
}

