/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.cbreflect.reflect;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.IReflectBlock;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.MostlyHarmless;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectAxisAlignedBB;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectBase;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectBlock;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectBlockPosition;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectBlockSix;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectDamageSource;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectEntity;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectLivingEntity;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectMaterial;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectPlayer;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectWorld;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.lang.reflect.Field;
import java.util.LinkedList;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ReflectHelper {
    protected final ReflectBase reflectBase;
    protected final ReflectAxisAlignedBB reflectAxisAlignedBB;
    protected final ReflectBlockPosition reflectBlockPosition;
    protected final IReflectBlock reflectBlock;
    protected final ReflectMaterial reflectMaterial;
    protected final ReflectWorld reflectWorld;
    protected final ReflectDamageSource reflectDamageSource;
    protected final ReflectEntity reflectEntity;
    protected final ReflectEntity reflectLivingEntity;
    protected final ReflectPlayer reflectPlayer;
    private final double[] tempBounds = new double[6];

    public ReflectHelper() throws ReflectFailureException {
        try {
            this.reflectBase = new ReflectBase();
            ReflectAxisAlignedBB reflectAxisAlignedBB = null;
            try {
                reflectAxisAlignedBB = new ReflectAxisAlignedBB(this.reflectBase);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.reflectAxisAlignedBB = reflectAxisAlignedBB;
            ReflectBlockPosition reflectBlockPosition = null;
            try {
                reflectBlockPosition = new ReflectBlockPosition(this.reflectBase);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.reflectBlockPosition = reflectBlockPosition;
            this.reflectMaterial = new ReflectMaterial(this.reflectBase);
            this.reflectWorld = new ReflectWorld(this.reflectBase, this.reflectMaterial, reflectBlockPosition);
            ReflectBlock reflectBlockLatest = null;
            try {
                reflectBlockLatest = new ReflectBlock(this.reflectBase, this.reflectBlockPosition, this.reflectMaterial, this.reflectWorld);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.reflectBlock = reflectBlockLatest == null ? new ReflectBlockSix(this.reflectBase, this.reflectBlockPosition) : reflectBlockLatest;
            this.reflectDamageSource = new ReflectDamageSource(this.reflectBase);
            this.reflectEntity = new ReflectEntity(this.reflectBase, this.reflectAxisAlignedBB, this.reflectDamageSource);
            this.reflectLivingEntity = new ReflectLivingEntity(this.reflectBase, this.reflectAxisAlignedBB, this.reflectDamageSource);
            this.reflectPlayer = new ReflectPlayer(this.reflectBase, this.reflectAxisAlignedBB, this.reflectDamageSource);
        }
        catch (ClassNotFoundException ex) {
            throw new ReflectFailureException(ex);
        }
        if (ConfigManager.getConfigFile().getBoolean("logging.extended.status")) {
            LinkedList<String> parts = new LinkedList<String>();
            for (Field rootField : this.getClass().getDeclaredFields()) {
                Object obj;
                if (rootField.isAnnotationPresent(MostlyHarmless.class)) continue;
                boolean accessible = rootField.isAccessible();
                if (!accessible) {
                    rootField.setAccessible(true);
                }
                if ((obj = ReflectionUtil.get(rootField, this, null)) == null) {
                    parts.add("(Not available: " + rootField.getName() + ")");
                    continue;
                }
                if (rootField.getName().startsWith("reflect")) {
                    Class<?> clazz = obj.getClass();
                    for (Field field : clazz.getFields()) {
                        if (field.isAnnotationPresent(MostlyHarmless.class) || ReflectionUtil.get(field, obj, null) != null) continue;
                        parts.add(clazz.getName() + "." + field.getName());
                    }
                }
                if (accessible) continue;
                rootField.setAccessible(false);
            }
            if (!this.reflectBlock.isFetchBoundsAvailable()) {
                parts.add("fetch-block-shape");
            }
            if (!parts.isEmpty()) {
                parts.add(0, "CompatCBReflect: The following properties could not be set:");
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.INIT, StringUtil.join(parts, "\n"));
            }
        }
    }

    private void fail() {
        throw new ReflectFailureException();
    }

    public Object getHandle(Player player) {
        Object handle;
        if (this.reflectPlayer.obcGetHandle == null) {
            this.fail();
        }
        if ((handle = ReflectionUtil.invokeMethodNoArgs(this.reflectPlayer.obcGetHandle, player)) == null) {
            this.fail();
        }
        return handle;
    }

    public double nmsPlayer_getHealth(Object handle) {
        if (this.reflectPlayer.nmsGetHealth == null) {
            this.fail();
        }
        return ((Number)ReflectionUtil.invokeMethodNoArgs(this.reflectPlayer.nmsGetHealth, handle)).doubleValue();
    }

    public boolean nmsPlayer_dead(Object handle) {
        if (this.reflectPlayer.nmsDead == null) {
            this.fail();
        }
        return ReflectionUtil.getBoolean(this.reflectPlayer.nmsDead, handle, true);
    }

    public void nmsPlayer_dead(Object handle, boolean value) {
        if (this.reflectPlayer.nmsDead == null || !ReflectionUtil.set(this.reflectPlayer.nmsDead, handle, value)) {
            this.fail();
        }
    }

    public void nmsPlayer_deathTicks(Object handle, int value) {
        if (this.reflectPlayer.nmsDeathTicks == null || !ReflectionUtil.set(this.reflectPlayer.nmsDeathTicks, handle, value)) {
            this.fail();
        }
    }

    public boolean canDealFallDamage() {
        return this.reflectPlayer.nmsDamageEntity != null && this.reflectDamageSource.nmsFALL != null;
    }

    public void dealFallDamage(Player player, double damage) {
        if (this.reflectDamageSource.nmsFALL == null) {
            this.fail();
        }
        Object handle = this.getHandle(player);
        this.nmsPlayer_dealDamage(handle, this.reflectDamageSource.nmsFALL, damage);
    }

    public void nmsPlayer_dealDamage(Object handle, Object damage_source, double damage) {
        if (this.reflectPlayer.nmsDamageEntity == null) {
            this.fail();
        }
        if (this.reflectPlayer.nmsDamageEntityInt) {
            ReflectionUtil.invokeMethod(this.reflectPlayer.nmsDamageEntity, handle, damage_source, (int)damage);
        } else {
            ReflectionUtil.invokeMethod(this.reflectPlayer.nmsDamageEntity, handle, damage_source, Float.valueOf((float)damage));
        }
    }

    public int getInvulnerableTicks(Player player) {
        if (this.reflectPlayer.nmsInvulnerableTicks == null) {
            this.fail();
        }
        Object handle = this.getHandle(player);
        return ReflectionUtil.getInt(this.reflectPlayer.nmsInvulnerableTicks, handle, player.getNoDamageTicks() / 2);
    }

    public void setInvulnerableTicks(Player player, int ticks) {
        Object handle;
        if (this.reflectPlayer.nmsInvulnerableTicks == null) {
            this.fail();
        }
        if (!ReflectionUtil.set(this.reflectPlayer.nmsInvulnerableTicks, handle = this.getHandle(player), ticks)) {
            this.fail();
        }
    }

    public Object getHandle(World world) {
        Object handle;
        if (this.reflectWorld.obcGetHandle == null) {
            this.fail();
        }
        if ((handle = ReflectionUtil.invokeMethodNoArgs(this.reflectWorld.obcGetHandle, world)) == null) {
            this.fail();
        }
        return handle;
    }

    public Object nmsBlockPosition(int x, int y, int z) {
        Object blockPos;
        if (this.reflectBlockPosition.new_nmsBlockPosition == null) {
            this.fail();
        }
        if ((blockPos = ReflectionUtil.newInstance(this.reflectBlockPosition.new_nmsBlockPosition, x, y, z)) == null) {
            this.fail();
        }
        return blockPos;
    }

    public Object nmsBlock_getById(int id) {
        if (this.reflectBlock == null) {
            this.fail();
        }
        return this.reflectBlock.nms_getById(id);
    }

    public Object nmsBlock_getMaterial(Object block) {
        if (this.reflectBlock == null) {
            this.fail();
        }
        return this.reflectBlock.nms_getMaterial(block);
    }

    public boolean nmsMaterial_isSolid(Object material) {
        if (this.reflectMaterial.nmsIsSolid == null) {
            this.fail();
        }
        return (Boolean)ReflectionUtil.invokeMethodNoArgs(this.reflectMaterial.nmsIsSolid, material);
    }

    public boolean nmsMaterial_isLiquid(Object material) {
        if (this.reflectMaterial.nmsIsLiquid == null) {
            this.fail();
        }
        return (Boolean)ReflectionUtil.invokeMethodNoArgs(this.reflectMaterial.nmsIsLiquid, material);
    }

    public AlmostBoolean isBlockSolid(int id) {
        Object obj = this.nmsBlock_getById(id);
        if (obj == null) {
            return AlmostBoolean.MAYBE;
        }
        if ((obj = this.nmsBlock_getMaterial(obj)) == null) {
            return AlmostBoolean.MAYBE;
        }
        return AlmostBoolean.match(this.nmsMaterial_isSolid(obj));
    }

    public AlmostBoolean isBlockLiquid(int id) {
        Object obj = this.nmsBlock_getById(id);
        if (obj == null) {
            return AlmostBoolean.MAYBE;
        }
        if ((obj = this.nmsBlock_getMaterial(obj)) == null) {
            return AlmostBoolean.MAYBE;
        }
        return AlmostBoolean.match(this.nmsMaterial_isLiquid(obj));
    }

    public double[] nmsWorld_fetchBlockShape(Object nmsWorld, int id, int x, int y, int z) {
        Object nmsBlock;
        if (this.reflectBlock == null) {
            this.fail();
        }
        if ((nmsBlock = this.nmsBlock_getById(id)) == null) {
            return null;
        }
        return this.reflectBlock.nms_fetchBounds(nmsWorld, nmsBlock, x, y, z);
    }

    public double getWidth(Entity entity) {
        Object handle;
        float width = -16.0f;
        if (this.reflectEntity.nmsWidth == null) {
            this.fail();
        }
        if ((handle = this.reflectEntity.getHandle(entity)) != null) {
            width = ReflectionUtil.getFloat(this.reflectEntity.nmsWidth, handle, width);
        }
        if (width < 0.0f) {
            this.fail();
        }
        return width;
    }

    public double getHeight(Entity entity) {
        Object box;
        float floatHeight = -16.0f;
        Object handle = this.reflectEntity.getHandle(entity);
        if (handle == null) {
            this.fail();
        }
        if (this.reflectEntity.nmsLength != null) {
            floatHeight = Math.max(ReflectionUtil.getFloat(this.reflectEntity.nmsLength, handle, floatHeight), floatHeight);
        }
        if (this.reflectEntity.nmsHeight != null) {
            floatHeight = Math.max(ReflectionUtil.getFloat(this.reflectEntity.nmsHeight, handle, floatHeight), floatHeight);
        }
        double height = floatHeight;
        if (this.reflectAxisAlignedBB != null && this.reflectEntity.nmsGetBoundingBox != null && (box = ReflectionUtil.invokeMethodNoArgs(this.reflectEntity.nmsGetBoundingBox, handle)) != null) {
            double y2 = ReflectionUtil.getDouble(this.reflectAxisAlignedBB.nms_maxY, box, Double.MAX_VALUE);
            double y1 = ReflectionUtil.getDouble(this.reflectAxisAlignedBB.nms_minY, box, Double.MAX_VALUE);
            if (y1 != Double.MAX_VALUE && y2 != Double.MAX_VALUE) {
                height = Math.max(y2 - y1, height);
            }
        }
        if (height < 0.0) {
            this.fail();
        }
        if (entity instanceof LivingEntity) {
            height = Math.max(height, ((LivingEntity)entity).getEyeHeight());
        }
        return height;
    }

    public double[] getBounds(Entity entity) {
        return this.getBounds(entity, new double[6]);
    }

    public double[] getBoundsTemp(Entity entity) {
        return this.getBounds(entity, this.tempBounds);
    }

    public double[] getBounds(Entity entity, double[] bounds) {
        Object aabb;
        if (this.reflectAxisAlignedBB == null || this.reflectEntity == null) {
            this.fail();
        }
        if ((aabb = ReflectionUtil.invokeMethodNoArgs(this.reflectEntity.nmsGetBoundingBox, this.reflectEntity.getHandle(entity))) == null) {
            this.fail();
        }
        this.reflectAxisAlignedBB.fillInValues(aabb, bounds);
        return bounds;
    }

    public static class ReflectFailureException
    extends RuntimeException {
        private static final long serialVersionUID = -3934791920291782604L;

        public ReflectFailureException() {
        }

        public ReflectFailureException(ClassNotFoundException ex) {
            super(ex);
        }
    }
}

