/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.cbreflect.reflect;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectBase;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectGetHandleBase;
import fr.neatmonster.nocheatplus.components.entity.IEntityAccessLastPositionAndLook;
import fr.neatmonster.nocheatplus.components.location.IGetPositionWithLook;
import fr.neatmonster.nocheatplus.components.location.ISetPositionWithLook;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.Validate;
import java.lang.reflect.Field;
import org.bukkit.entity.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectEntityLastPositionAndLook
extends ReflectGetHandleBase<Entity>
implements IEntityAccessLastPositionAndLook {
    public final Field lastX;
    public final Field lastY;
    public final Field lastZ;
    public final Field lastYaw;
    public final Field lastPitch;

    public ReflectEntityLastPositionAndLook() throws ClassNotFoundException {
        this(new ReflectBase());
    }

    public ReflectEntityLastPositionAndLook(ReflectBase base) throws ClassNotFoundException {
        this(base, Class.forName(base.obcPackageName + ".entity.CraftEntity"), Class.forName(base.nmsPackageName + ".Entity"));
    }

    public ReflectEntityLastPositionAndLook(ReflectBase base, Class<?> obcClass, Class<?> nmsClass) throws ClassNotFoundException, NoSuchFieldError {
        super(base, obcClass, nmsClass);
        this.lastX = ReflectionUtil.getField(nmsClass, "lastX", Double.TYPE);
        this.lastY = ReflectionUtil.getField(nmsClass, "lastY", Double.TYPE);
        this.lastZ = ReflectionUtil.getField(nmsClass, "lastZ", Double.TYPE);
        this.lastYaw = ReflectionUtil.getField(nmsClass, "lastYaw", Float.TYPE);
        this.lastPitch = ReflectionUtil.getField(nmsClass, "lastPitch", Float.TYPE);
        Validate.validateNotNull(this.lastX, this.lastY, this.lastZ, this.lastYaw, this.lastPitch);
    }

    @Override
    public void getPositionAndLook(Entity entity, ISetPositionWithLook location) {
        try {
            this.performGet(entity, location);
        }
        catch (Throwable t) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, "Could not retrieve last position and look for Entity: " + entity.getClass().getName());
        }
    }

    private void performGet(Entity entity, ISetPositionWithLook location) throws IllegalArgumentException, IllegalAccessException {
        Object nmsObject = this.getHandle(entity);
        location.setX(this.lastX.getDouble(nmsObject));
        location.setY(this.lastY.getDouble(nmsObject));
        location.setZ(this.lastZ.getDouble(nmsObject));
        location.setYaw(this.lastYaw.getFloat(nmsObject));
        location.setPitch(this.lastPitch.getFloat(nmsObject));
    }

    @Override
    public void setPositionAndLook(Entity entity, IGetPositionWithLook location) {
        try {
            this.performSet(entity, location);
        }
        catch (Throwable t) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, "Could not set last position and look for Entity: " + entity.getClass().getName());
        }
    }

    private void performSet(Entity entity, IGetPositionWithLook location) throws IllegalArgumentException, IllegalAccessException {
        Object nmsObject = this.getHandle(entity);
        this.lastX.setDouble(nmsObject, location.getX());
        this.lastY.setDouble(nmsObject, location.getY());
        this.lastZ.setDouble(nmsObject, location.getZ());
        this.lastYaw.setFloat(nmsObject, location.getYaw());
        this.lastPitch.setFloat(nmsObject, location.getPitch());
    }

    @Override
    protected void fail() {
        throw new RuntimeException("Not available.");
    }
}

