/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.cbreflect.reflect;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.IReflectBlock;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectBase;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectBlockPosition;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectHelper;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectBlockSix
implements IReflectBlock {
    private static final List<String> possibleNames = new ArrayList<String>();
    private final ReflectBlockPosition reflectBlockPosition;
    public final Method nmsGetById;
    public final Method nmsGetMaterial;
    public final boolean useBlockPosition;
    public final Method nmsUpdateShape;
    public final Method nmsGetMinX;
    public final Method nmsGetMaxX;
    public final Method nmsGetMinY;
    public final Method nmsGetMaxY;
    public final Method nmsGetMinZ;
    public final Method nmsGetMaxZ;

    public ReflectBlockSix(ReflectBase base, ReflectBlockPosition reflectBlockPosition) throws ClassNotFoundException {
        this.reflectBlockPosition = reflectBlockPosition;
        Class<?> clazz = Class.forName(base.nmsPackageName + ".Block");
        this.nmsGetById = ReflectionUtil.getMethod(clazz, "getById", Integer.TYPE);
        this.nmsGetMaterial = ReflectionUtil.getMethodNoArgs(clazz, "getMaterial", new Class[0]);
        Method method = null;
        Class<?> clazzIBlockAccess = Class.forName(base.nmsPackageName + ".IBlockAccess");
        if (reflectBlockPosition != null) {
            method = ReflectionUtil.getMethod(clazz, "updateShape", clazzIBlockAccess, reflectBlockPosition.nmsClass);
        }
        if (method == null) {
            method = ReflectionUtil.getMethod(clazz, "updateShape", clazzIBlockAccess, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            this.useBlockPosition = false;
        } else {
            this.useBlockPosition = true;
        }
        this.nmsUpdateShape = method;
        String[] names = new String[]{"getMinX", "getMaxX", "getMinY", "getMaxY", "getMinZ", "getMaxZ"};
        Method[] methods = this.tryBoundsMethods(clazz, names);
        if (methods == null) {
            names = this.guessBoundsMethodNames(clazz);
            if (names != null) {
                methods = this.tryBoundsMethods(clazz, names);
            }
            if (methods == null) {
                methods = new Method[]{null, null, null, null, null, null};
            }
        }
        if (ConfigManager.getConfigFile().getBoolean("logging.extended.status")) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.INIT, "ReflectBlock: Use methods for shape: " + StringUtil.join(Arrays.asList(names), ", "));
        }
        this.nmsGetMinX = methods[0];
        this.nmsGetMaxX = methods[1];
        this.nmsGetMinY = methods[2];
        this.nmsGetMaxY = methods[3];
        this.nmsGetMinZ = methods[4];
        this.nmsGetMaxZ = methods[5];
    }

    private Method[] tryBoundsMethods(Class<?> clazz, String[] names) {
        Method[] methods = new Method[6];
        for (int i = 0; i < 6; ++i) {
            methods[i] = ReflectionUtil.getMethodNoArgs(clazz, names[i], Double.TYPE);
            if (methods[i] != null) continue;
            return null;
        }
        return methods;
    }

    private String[] guessBoundsMethodNames(Class<?> clazz) {
        ArrayList<String> names = new ArrayList<String>();
        for (Method method : clazz.getMethods()) {
            if (method.getReturnType() != Double.TYPE || method.getParameterTypes().length != 0 || !possibleNames.contains(method.getName())) continue;
            names.add(method.getName());
        }
        if (names.size() < 6) {
            return null;
        }
        Collections.sort(names, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.compare(possibleNames.indexOf(o1), possibleNames.indexOf(o2));
            }
        });
        int startIndex = 0;
        if (names.size() > 6) {
            startIndex = -1;
            int lastIndex = -2;
            int currentStart = -1;
            for (int i = 0; i < names.size(); ++i) {
                String name = (String)names.get(i);
                int nameIndex = possibleNames.indexOf(name);
                if (nameIndex - lastIndex == 1) {
                    if (currentStart == -1) {
                        currentStart = nameIndex - 1;
                    } else {
                        int length = nameIndex - currentStart + 1;
                        if (length > 6) {
                            return null;
                        }
                        if (length == 6) {
                            if (startIndex != -1) {
                                return null;
                            }
                            startIndex = i + 1 - length;
                        }
                    }
                } else {
                    currentStart = -1;
                }
                lastIndex = nameIndex;
            }
            if (startIndex == -1) {
                return null;
            }
        }
        String[] res = new String[6];
        for (int i = 0; i < 6; ++i) {
            res[i] = (String)names.get(startIndex + i);
        }
        return res;
    }

    private void fail() {
        throw new ReflectHelper.ReflectFailureException();
    }

    private Object nmsBlockPosition(int x, int y, int z) {
        Object blockPos;
        if (!this.useBlockPosition || this.reflectBlockPosition.new_nmsBlockPosition == null) {
            this.fail();
        }
        if ((blockPos = ReflectionUtil.newInstance(this.reflectBlockPosition.new_nmsBlockPosition, x, y, z)) == null) {
            this.fail();
        }
        return blockPos;
    }

    @Override
    public Object nms_getById(int id) {
        if (this.nmsGetById == null) {
            this.fail();
        }
        return ReflectionUtil.invokeMethod(this.nmsGetById, null, id);
    }

    @Override
    public Object nms_getMaterial(Object block) {
        if (this.nmsGetMaterial == null) {
            this.fail();
        }
        return ReflectionUtil.invokeMethodNoArgs(this.nmsGetMaterial, block);
    }

    public void nms_updateShape(Object block, Object iBlockAccess, int x, int y, int z) {
        if (this.nmsUpdateShape == null) {
            this.fail();
        }
        if (this.useBlockPosition) {
            ReflectionUtil.invokeMethod(this.nmsUpdateShape, block, iBlockAccess, this.nmsBlockPosition(x, y, z));
        } else {
            ReflectionUtil.invokeMethod(this.nmsUpdateShape, block, iBlockAccess, x, y, z);
        }
    }

    @Override
    public double[] nms_fetchBounds(Object nmsWorld, Object nmsBlock, int x, int y, int z) {
        this.nms_updateShape(nmsBlock, nmsWorld, x, y, z);
        return new double[]{((Number)ReflectionUtil.invokeMethodNoArgs(this.nmsGetMinX, nmsBlock)).doubleValue(), ((Number)ReflectionUtil.invokeMethodNoArgs(this.nmsGetMinY, nmsBlock)).doubleValue(), ((Number)ReflectionUtil.invokeMethodNoArgs(this.nmsGetMinZ, nmsBlock)).doubleValue(), ((Number)ReflectionUtil.invokeMethodNoArgs(this.nmsGetMaxX, nmsBlock)).doubleValue(), ((Number)ReflectionUtil.invokeMethodNoArgs(this.nmsGetMaxY, nmsBlock)).doubleValue(), ((Number)ReflectionUtil.invokeMethodNoArgs(this.nmsGetMaxZ, nmsBlock)).doubleValue()};
    }

    @Override
    public boolean isFetchBoundsAvailable() {
        return this.nmsGetById != null && this.nmsUpdateShape != null && this.nmsGetMinX != null;
    }

    static {
        for (char c : "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray()) {
            possibleNames.add("" + c);
        }
    }
}

