/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.cb3100;

import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import java.util.List;
import net.minecraft.server.v1_7_R4.AxisAlignedBB;
import net.minecraft.server.v1_7_R4.Block;
import net.minecraft.server.v1_7_R4.Entity;
import net.minecraft.server.v1_7_R4.EntityBoat;
import net.minecraft.server.v1_7_R4.IBlockAccess;
import net.minecraft.server.v1_7_R4.TileEntity;
import net.minecraft.server.v1_7_R4.WorldServer;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_7_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEntity;

public class BlockCacheCB3100
extends BlockCache
implements IBlockAccess {
    protected static final AxisAlignedBB useBox = AxisAlignedBB.a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    protected WorldServer world;

    public BlockCacheCB3100(World world) {
        this.setAccess(world);
    }

    public BlockCache setAccess(World world) {
        if (world != null) {
            this.maxBlockY = world.getMaxHeight() - 1;
            this.world = ((CraftWorld)world).getHandle();
        } else {
            this.world = null;
        }
        return this;
    }

    public int fetchTypeId(int x, int y, int z) {
        return this.world.getTypeId(x, y, z);
    }

    public int fetchData(int x, int y, int z) {
        return this.world.getData(x, y, z);
    }

    public double[] fetchBounds(int x, int y, int z) {
        int id = this.getTypeId(x, y, z);
        Block block = Block.getById((int)id);
        if (block == null) {
            return null;
        }
        block.updateShape((IBlockAccess)this, x, y, z);
        return new double[]{block.x(), block.z(), block.B(), block.y(), block.A(), block.C()};
    }

    public boolean standsOnEntity(org.bukkit.entity.Entity entity, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        try {
            Entity mcEntity = ((CraftEntity)entity).getHandle();
            AxisAlignedBB box = useBox.b(minX, minY, minZ, maxX, maxY, maxZ);
            List list = this.world.getEntities(mcEntity, box);
            for (Entity other : list) {
                if (!(other instanceof EntityBoat)) continue;
                if (minY >= other.locY && minY - other.locY <= 0.7) {
                    return true;
                }
                AxisAlignedBB otherBox = other.boundingBox;
                if (box.a > otherBox.d || box.d < otherBox.a || box.b > otherBox.e || box.e < otherBox.b || box.c > otherBox.f || box.f < otherBox.c) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public void cleanup() {
        super.cleanup();
        this.world = null;
    }

    public TileEntity getTileEntity(int x, int y, int z) {
        return this.world.getTileEntity(x, y, z);
    }

    public int getBlockPower(int arg0, int arg1, int arg2, int arg3) {
        return this.world.getBlockPower(arg0, arg1, arg2, arg3);
    }

    public Block getType(int x, int y, int z) {
        return this.world.getType(x, y, z);
    }
}

