/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit;

import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.BridgeHealth;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.bukkit.BlockCacheBukkit;
import fr.neatmonster.nocheatplus.utilities.PotionUtil;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandMap;
import org.bukkit.entity.ComplexEntityPart;
import org.bukkit.entity.ComplexLivingEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.potion.PotionEffectType;

public class MCAccessBukkitBase
implements MCAccess {
    protected final boolean bukkitHasGetHeightAndGetWidth;

    public MCAccessBukkitBase() {
        Material.AIR.isSolid();
        Material.AIR.isOccluding();
        Material.AIR.isTransparent();
        this.bukkitHasGetHeightAndGetWidth = ReflectionUtil.getMethodNoArgs(Entity.class, "getHeight", Double.TYPE) != null && ReflectionUtil.getMethodNoArgs(Entity.class, "getWidth", Double.TYPE) != null;
    }

    public String getMCVersion() {
        return "1.4.6-1.11.2|?";
    }

    public String getServerVersionTag() {
        return "Bukkit-API";
    }

    public CommandMap getCommandMap() {
        try {
            return (CommandMap)ReflectionUtil.invokeMethodNoArgs(Bukkit.getServer(), "getCommandMap", new Class[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public BlockCache getBlockCache() {
        return this.getBlockCache(null);
    }

    public BlockCache getBlockCache(World world) {
        return new BlockCacheBukkit(world);
    }

    public double getHeight(Entity entity) {
        double entityHeight = this.bukkitHasGetHeightAndGetWidth ? entity.getHeight() : 1.0;
        if (entity instanceof LivingEntity) {
            return Math.max(((LivingEntity)entity).getEyeHeight(), entityHeight);
        }
        return entityHeight;
    }

    public AlmostBoolean isBlockSolid(int id) {
        Material mat = Material.getMaterial((int)id);
        if (mat == null) {
            return AlmostBoolean.MAYBE;
        }
        return AlmostBoolean.match(mat.isSolid());
    }

    private final double legacyGetWidth(Entity entity) {
        EntityType type = entity.getType();
        switch (type) {
            case ENDER_SIGNAL: 
            case FIREWORK: 
            case FISHING_HOOK: 
            case DROPPED_ITEM: 
            case SNOWBALL: {
                return 0.25;
            }
            case CHICKEN: 
            case SILVERFISH: {
                return 0.3f;
            }
            case SMALL_FIREBALL: 
            case WITHER_SKULL: {
                return 0.3125;
            }
            case GHAST: 
            case SNOWMAN: {
                return 0.4f;
            }
            case ARROW: 
            case BAT: 
            case EXPERIENCE_ORB: 
            case ITEM_FRAME: 
            case PAINTING: {
                return 0.5;
            }
            case PLAYER: 
            case ZOMBIE: 
            case PIG_ZOMBIE: 
            case SKELETON: 
            case CREEPER: 
            case ENDERMAN: 
            case OCELOT: 
            case BLAZE: 
            case VILLAGER: 
            case WITCH: 
            case WOLF: {
                return 0.6f;
            }
            case CAVE_SPIDER: {
                return 0.7f;
            }
            case COW: 
            case MUSHROOM_COW: 
            case PIG: 
            case SHEEP: 
            case WITHER: {
                return 0.9f;
            }
            case SQUID: {
                return 0.95f;
            }
            case PRIMED_TNT: {
                return 0.98f;
            }
            case FIREBALL: {
                return 1.0;
            }
            case IRON_GOLEM: 
            case SPIDER: {
                return 1.4f;
            }
            case BOAT: {
                return 1.5;
            }
            case ENDER_CRYSTAL: {
                return 2.0;
            }
            case GIANT: {
                return 3.6f;
            }
            case ENDER_DRAGON: {
                return 16.0;
            }
            case SLIME: 
            case MAGMA_CUBE: {
                if (!(entity instanceof Slime)) break;
                return 0.6f * (float)((Slime)entity).getSize();
            }
        }
        if (entity instanceof Minecart) {
            return 0.98f;
        }
        try {
            switch (type) {
                case LEASH_HITCH: {
                    return 0.5;
                }
                case HORSE: {
                    return 1.4f;
                }
                case ENDERMITE: {
                    return 0.4f;
                }
                case ARMOR_STAND: {
                    return 0.5;
                }
                case RABBIT: {
                    return 0.6f;
                }
                case GUARDIAN: {
                    return 0.95f;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0.6f;
    }

    public double getWidth(Entity entity) {
        if (this.bukkitHasGetHeightAndGetWidth) {
            return entity.getWidth();
        }
        return this.legacyGetWidth(entity);
    }

    public AlmostBoolean isBlockLiquid(int id) {
        Material mat = Material.getMaterial((int)id);
        if (mat == null) {
            return AlmostBoolean.MAYBE;
        }
        switch (mat) {
            case STATIONARY_LAVA: 
            case STATIONARY_WATER: 
            case WATER: 
            case LAVA: {
                return AlmostBoolean.YES;
            }
        }
        return AlmostBoolean.NO;
    }

    public AlmostBoolean isIllegalBounds(Player player) {
        if (player.isDead()) {
            return AlmostBoolean.NO;
        }
        if (!player.isSleeping()) {
            // empty if block
        }
        return AlmostBoolean.MAYBE;
    }

    public double getJumpAmplifier(Player player) {
        return PotionUtil.getPotionEffectAmplifier(player, PotionEffectType.JUMP);
    }

    public double getFasterMovementAmplifier(Player player) {
        return PotionUtil.getPotionEffectAmplifier(player, PotionEffectType.SPEED);
    }

    public int getInvulnerableTicks(Player player) {
        return Integer.MAX_VALUE;
    }

    public void setInvulnerableTicks(Player player, int ticks) {
    }

    public void dealFallDamage(Player player, double damage) {
        BridgeHealth.damage((LivingEntity)player, damage);
    }

    public boolean isComplexPart(Entity entity) {
        return entity instanceof ComplexEntityPart || entity instanceof ComplexLivingEntity;
    }

    public boolean shouldBeZombie(Player player) {
        return BridgeHealth.getHealth((LivingEntity)player) <= 0.0 && !player.isDead();
    }

    public void setDead(Player player, int deathTicks) {
        BridgeHealth.setHealth((LivingEntity)player, 0.0);
        BridgeHealth.damage((LivingEntity)player, 1.0);
    }

    public boolean hasGravity(Material mat) {
        try {
            return mat.hasGravity();
        }
        catch (Throwable t) {
            switch (mat) {
                case SAND: 
                case GRAVEL: {
                    return true;
                }
            }
            return false;
        }
    }

    public AlmostBoolean dealFallDamageFiresAnEvent() {
        return AlmostBoolean.NO;
    }
}

