/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit;

import fr.neatmonster.nocheatplus.compat.AttribUtil;
import fr.neatmonster.nocheatplus.components.modifier.IAttributeAccess;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import java.util.UUID;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;

public class BukkitAttributeAccess
implements IAttributeAccess {
    public BukkitAttributeAccess() {
        if (ReflectionUtil.getClass("org.bukkit.attribute.AttributeInstance") == null) {
            throw new RuntimeException("Service not available.");
        }
    }

    private int operationToInt(AttributeModifier.Operation operation) {
        switch (operation) {
            case ADD_NUMBER: {
                return 0;
            }
            case ADD_SCALAR: {
                return 1;
            }
            case MULTIPLY_SCALAR_1: {
                return 2;
            }
        }
        throw new RuntimeException("Unknown operation: " + operation);
    }

    private AttributeModifier getModifier(AttributeInstance attrInst, UUID id) {
        for (AttributeModifier mod : attrInst.getModifiers()) {
            if (!id.equals(mod.getUniqueId())) continue;
            return mod;
        }
        return null;
    }

    private double getMultiplier(AttributeModifier mod) {
        return AttribUtil.getMultiplier(this.operationToInt(mod.getOperation()), mod.getAmount());
    }

    public double getSpeedAttributeMultiplier(Player player) {
        AttributeInstance attrInst = player.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED);
        double val = attrInst.getValue() / attrInst.getBaseValue();
        AttributeModifier mod = this.getModifier(attrInst, AttribUtil.ID_SPRINT_BOOST);
        return mod == null ? val : val / this.getMultiplier(mod);
    }

    public double getSprintAttributeMultiplier(Player player) {
        AttributeInstance attrInst = player.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED);
        AttributeModifier mod = this.getModifier(attrInst, AttribUtil.ID_SPRINT_BOOST);
        return mod == null ? 1.0 : this.getMultiplier(mod);
    }
}

