/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.blocks.changetracker;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeReference;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.OnGroundReference;
import fr.neatmonster.nocheatplus.components.location.IGetPosition;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceHandle;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.ds.map.CoordHashMap;
import fr.neatmonster.nocheatplus.utilities.ds.map.CoordMap;
import fr.neatmonster.nocheatplus.utilities.ds.map.LinkedCoordHashMap;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.map.MapUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockChangeTracker {
    private long maxChangeId = 0L;
    private int maxChangeIdTick = -1;
    private int expirationAgeTicks = 80;
    private int worldNodeSkipSize = 500;
    private int activityResolution = 32;
    private final Map<UUID, WorldNode> worldMap = new LinkedHashMap<UUID, WorldNode>();
    private final Set<Block> processBlocks = new LinkedHashSet<Block>();
    private IGenericInstanceHandle<BlockCache> blockCacheHandle = null;
    private final OnGroundReference onGroundReference = new OnGroundReference();

    public void addPistonBlocks(Block pistonBlock, BlockFace blockFace, List<Block> movedBlocks) {
        this.checkProcessBlocks();
        int tick = TickTask.getTick();
        World world = pistonBlock.getWorld();
        WorldNode worldNode = this.getOrCreateWorldNode(world, tick);
        long changeId = this.getNewChangeId(tick, false);
        if (pistonBlock != null) {
            this.processBlocks.add(pistonBlock);
        }
        if (movedBlocks != null) {
            for (Block movedBlock : movedBlocks) {
                this.processBlocks.add(movedBlock);
                this.processBlocks.add(movedBlock.getRelative(blockFace));
            }
        }
        BlockCache blockCache = this.blockCacheHandle.getHandle();
        blockCache.setAccess(world);
        for (Block block : this.processBlocks) {
            this.addPistonBlock(changeId, tick, worldNode, block.getX(), block.getY(), block.getZ(), blockFace, blockCache);
        }
        blockCache.cleanup();
        this.processBlocks.clear();
    }

    private void addPistonBlock(long changeId, int tick, WorldNode worldNode, int x, int y, int z, BlockFace blockFace, BlockCache blockCache) {
        this.addBlockChange(changeId, tick, worldNode, x, y, z, Direction.getDirection(blockFace), blockCache.getOrCreateBlockCacheNode(x, y, z, true));
    }

    public void addBlocks(Block ... blocks) {
        if (blocks == null || blocks.length == 0) {
            return;
        }
        this.addBlocks(Arrays.asList(blocks));
    }

    public void addBlocks(Collection<Block> blocks) {
        if (blocks == null || blocks.isEmpty()) {
            return;
        }
        this.checkProcessBlocks();
        World world = null;
        for (Block block : blocks) {
            if (block == null) continue;
            if (world == null) {
                world = block.getWorld();
            }
            this.processBlocks.add(block);
        }
        if (world == null || this.processBlocks.isEmpty()) {
            this.processBlocks.clear();
            return;
        }
        int tick = TickTask.getTick();
        WorldNode worldNode = this.getOrCreateWorldNode(world, tick);
        long changeId = this.getNewChangeId(tick, false);
        BlockCache blockCache = this.blockCacheHandle.getHandle();
        blockCache.setAccess(world);
        for (Block block : this.processBlocks) {
            this.addBlock(changeId, tick, worldNode, block.getX(), block.getY(), block.getZ(), blockCache);
        }
        blockCache.cleanup();
        this.processBlocks.clear();
    }

    public long getNewChangeId(int tick, boolean preferKeep) {
        if (preferKeep && tick == this.maxChangeIdTick) {
            return this.maxChangeId;
        }
        this.maxChangeIdTick = tick;
        return ++this.maxChangeId;
    }

    public void addBlockChange(UUID worldId, int x, int y, int z, BlockCache.IBlockCacheNode previousState) {
        int tick = TickTask.getTick();
        this.addBlockChange(this.getNewChangeId(tick, true), tick, this.getOrCreateWorldNode(worldId, tick), x, y, z, Direction.NONE, previousState);
    }

    public void addBlockChange(long changeId, int tick, UUID worldId, int x, int y, int z, Direction direction, BlockCache.IBlockCacheNode previousState) {
        this.addBlockChange(changeId, tick, this.getOrCreateWorldNode(worldId, tick), x, y, z, direction, previousState);
    }

    public int removeAllEntries(UUID worldId, int x, int y, int z) {
        WorldNode worldNode = this.worldMap.get(worldId);
        if (worldNode == null) {
            return 0;
        }
        List entries = (List)worldNode.blocks.get(x, y, z);
        if (entries == null || entries.isEmpty()) {
            return 0;
        }
        int res = entries.size();
        entries.clear();
        worldNode.blocks.remove(x, y, z);
        ActivityNode activity = worldNode.getActivityNode(x, y, z, this.activityResolution);
        activity.count -= res;
        if (activity.count <= 0) {
            worldNode.removeActivityNode(x, y, z, this.activityResolution);
        }
        worldNode.size -= res;
        if (worldNode.size <= 0) {
            worldNode.clear();
            this.worldMap.remove(worldId);
        }
        return res;
    }

    private void addBlock(long changeId, int tick, WorldNode worldNode, int x, int y, int z, BlockCache blockCache) {
        this.addBlockChange(changeId, tick, worldNode, x, y, z, Direction.NONE, blockCache.getOrCreateBlockCacheNode(x, y, z, true));
    }

    private WorldNode getOrCreateWorldNode(World world, int tick) {
        return this.getOrCreateWorldNode(world.getUID(), tick);
    }

    private WorldNode getOrCreateWorldNode(UUID worldId, int tick) {
        WorldNode worldNode = this.worldMap.get(worldId);
        if (worldNode == null) {
            worldNode = new WorldNode(worldId);
            this.worldMap.put(worldId, worldNode);
        }
        return worldNode;
    }

    private void addBlockChange(long changeId, int tick, WorldNode worldNode, int x, int y, int z, Direction direction, BlockCache.IBlockCacheNode previousState) {
        LinkedList<BlockChangeEntry> entries = worldNode.blocks.get(x, y, z, LinkedCoordHashMap.MoveOrder.END);
        ActivityNode activityNode = worldNode.getActivityNode(x, y, z, this.activityResolution);
        if (entries != null && !entries.isEmpty()) {
            if (entries.getFirst().tick < tick - this.expirationAgeTicks) {
                int expired = this.expireEntries(tick - this.expirationAgeTicks, entries);
                worldNode.size -= expired;
                activityNode.count -= expired;
            }
            if (!entries.isEmpty()) {
                BlockChangeEntry lastEntry = entries.getLast();
                if (lastEntry.isRedundant(tick, direction, previousState)) {
                    return;
                }
                lastEntry.nextEntryTick = tick;
            }
        }
        if (entries == null) {
            entries = new LinkedList();
            worldNode.blocks.put(x, y, z, entries, LinkedCoordHashMap.MoveOrder.END);
        }
        entries.add(new BlockChangeEntry(changeId, tick, x, y, z, direction, previousState));
        ++activityNode.count;
        ++worldNode.size;
        worldNode.lastChangeTick = tick;
    }

    private boolean shouldExpireEntry(int expireOlderThanTick, BlockChangeEntry entry) {
        if (entry.nextEntryTick < 0) {
            return entry.tick < expireOlderThanTick;
        }
        return entry.nextEntryTick < expireOlderThanTick;
    }

    private int expireEntries(int expireOlderThanTick, LinkedList<BlockChangeEntry> entries) {
        int removed = 0;
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            if (this.shouldExpireEntry(expireOlderThanTick, (BlockChangeEntry)it.next())) {
                it.remove();
                ++removed;
                continue;
            }
            return removed;
        }
        return removed;
    }

    public void checkExpiration(int currentTick) {
        int expireOlderThanTick = currentTick - this.expirationAgeTicks;
        Iterator<Map.Entry<UUID, WorldNode>> it = this.worldMap.entrySet().iterator();
        while (it.hasNext()) {
            WorldNode worldNode = it.next().getValue();
            if (worldNode.lastChangeTick < expireOlderThanTick) {
                worldNode.clear();
                it.remove();
                continue;
            }
            if (worldNode.size < this.worldNodeSkipSize) continue;
            Iterator blockIt = worldNode.blocks.iterator();
            while (blockIt.hasNext()) {
                CoordMap.Entry entry = (CoordMap.Entry)blockIt.next();
                LinkedList entries = (LinkedList)entry.getValue();
                ActivityNode activityNode = worldNode.getActivityNode(entry.getX(), entry.getY(), entry.getZ(), this.activityResolution);
                if (!entries.isEmpty() && this.shouldExpireEntry(expireOlderThanTick, (BlockChangeEntry)entries.getFirst())) {
                    int expired = this.expireEntries(expireOlderThanTick, entries);
                    worldNode.size -= expired;
                    activityNode.count -= expired;
                }
                if (!entries.isEmpty()) continue;
                blockIt.remove();
                if (activityNode.count > 0) continue;
                worldNode.removeActivityNode(entry.getX(), entry.getY(), entry.getZ(), this.activityResolution);
            }
            if (worldNode.size > 0) continue;
            it.remove();
        }
    }

    public BlockChangeEntry getBlockChangeEntry(BlockChangeReference ref, int tick, UUID worldId, int x, int y, int z, Direction direction) {
        WorldNode worldNode = this.getValidWorldNode(tick, worldId);
        if (worldNode == null) {
            return null;
        }
        LinkedList<BlockChangeEntry> entries = this.getValidBlockChangeEntries(tick, worldNode, x, y, z);
        if (entries != null) {
            for (BlockChangeEntry entry : entries) {
                if (!entry.canUpdate(ref, direction)) continue;
                return entry;
            }
        }
        return null;
    }

    public BlockChangeEntry getBlockChangeEntryMatchFlags(BlockChangeReference ref, int tick, UUID worldId, int x, int y, int z, Direction direction, long matchFlags) {
        WorldNode worldNode = this.getValidWorldNode(tick, worldId);
        if (worldNode == null) {
            return null;
        }
        LinkedList<BlockChangeEntry> entries = this.getValidBlockChangeEntries(tick, worldNode, x, y, z);
        if (entries != null) {
            for (BlockChangeEntry entry : entries) {
                if (!entry.canUpdate(ref, direction) || matchFlags != 0L && (matchFlags & BlockProperties.getBlockFlags(entry.previousState.getId())) == 0L) continue;
                return entry;
            }
        }
        return null;
    }

    public boolean isOnGround(BlockCache blockCache, BlockChangeReference ref, int tick, UUID worldId, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, long ignoreFlags) {
        WorldNode worldNode = this.getValidWorldNode(tick, worldId);
        if (worldNode == null) {
            return false;
        }
        int maxBlockY = blockCache.getMaxBlockY();
        int iMinX = Location.locToBlock((double)minX);
        int iMaxX = Location.locToBlock((double)maxX);
        int iMinY = Location.locToBlock((double)(minY - 0.5626));
        if (iMinY > maxBlockY) {
            return false;
        }
        int iMaxY = Math.min(Location.locToBlock((double)maxY), maxBlockY);
        int iMinZ = Location.locToBlock((double)minZ);
        int iMaxZ = Location.locToBlock((double)maxZ);
        this.onGroundReference.init(blockCache, ref, ignoreFlags);
        for (int x = iMinX; x <= iMaxX; ++x) {
            block5: for (int z = iMinZ; z <= iMaxZ; ++z) {
                this.onGroundReference.setEntriesAbove(this.getValidBlockChangeEntries(tick, worldNode, x, iMaxY + 1, z));
                for (int y = iMaxY; y >= iMinY; --y) {
                    this.onGroundReference.setEntries(this.getValidBlockChangeEntries(tick, worldNode, x, y, z));
                    if (!this.onGroundReference.hasAnyEntries() || !this.onGroundReference.initEntries(x, y, z)) continue;
                    boolean shouldBreak = true;
                    do {
                        switch (BlockProperties.isOnGround(blockCache, minX, minY, minZ, maxX, maxY, maxZ, ignoreFlags, x, y, z, this.onGroundReference.getNode(), this.onGroundReference.getNodeAbove())) {
                            case YES: {
                                this.onGroundReference.updateSpan();
                                this.onGroundReference.clear();
                                return true;
                            }
                            case MAYBE: {
                                shouldBreak = false;
                            }
                        }
                    } while (this.onGroundReference.advance());
                    if (shouldBreak) continue block5;
                    this.onGroundReference.moveDown();
                }
            }
        }
        this.onGroundReference.clear();
        return false;
    }

    private WorldNode getValidWorldNode(int tick, UUID worldId) {
        WorldNode worldNode = this.worldMap.get(worldId);
        if (worldNode == null) {
            return null;
        }
        if (worldNode.lastChangeTick < tick - this.expirationAgeTicks) {
            worldNode.clear();
            this.worldMap.remove(worldNode.worldId);
            return null;
        }
        return worldNode;
    }

    private LinkedList<BlockChangeEntry> getValidBlockChangeEntries(int tick, WorldNode worldNode, int x, int y, int z) {
        int expireOlderThanTick = tick - this.expirationAgeTicks;
        LinkedList entries = (LinkedList)worldNode.blocks.get(x, y, z);
        if (entries == null) {
            return null;
        }
        ActivityNode activityNode = worldNode.getActivityNode(x, y, z, this.activityResolution);
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            BlockChangeEntry entry = (BlockChangeEntry)it.next();
            if (this.shouldExpireEntry(expireOlderThanTick, entry)) {
                it.remove();
                --activityNode.count;
                continue;
            }
            return entries;
        }
        if (entries.isEmpty()) {
            worldNode.blocks.remove(x, y, z);
            if (worldNode.size == 0) {
                this.worldMap.remove(worldNode.worldId);
            } else if (activityNode.count <= 0) {
                worldNode.removeActivityNode(x, y, z, this.activityResolution);
            }
            return null;
        }
        return entries;
    }

    public boolean hasActivityShuffled(UUID worldId, IGetPosition pos1, IGetPosition pos2, double margin) {
        return this.hasActivityShuffled(worldId, pos1.getX(), pos1.getY(), pos1.getZ(), pos2.getX(), pos2.getY(), pos2.getZ(), margin);
    }

    public boolean hasActivityShuffled(UUID worldId, double x1, double y1, double z1, double x2, double y2, double z2, double margin) {
        double minX = Math.min(x1, x2) - margin;
        double minY = Math.min(y1, y2) - margin;
        double minZ = Math.min(z1, z2) - margin;
        double maxX = Math.max(x1, x2) + margin;
        double maxY = Math.max(y1, y2) + margin;
        double maxZ = Math.max(z1, z2) + margin;
        return this.hasActivity(worldId, minX, minY, minZ, maxX, maxY, maxZ);
    }

    public boolean hasActivityShuffled(UUID worldId, double x1, double y1, double z1, double x2, double y2, double z2) {
        return this.hasActivityShuffled(worldId, Location.locToBlock((double)x1), Location.locToBlock((double)y1), Location.locToBlock((double)z1), Location.locToBlock((double)x2), Location.locToBlock((double)y2), Location.locToBlock((double)z2));
    }

    public boolean hasActivity(UUID worldId, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return this.hasActivity(worldId, Location.locToBlock((double)minX), Location.locToBlock((double)minY), Location.locToBlock((double)minZ), Location.locToBlock((double)maxX), Location.locToBlock((double)maxY), Location.locToBlock((double)maxZ));
    }

    public boolean hasActivityShuffled(UUID worldId, int x1, int y1, int z1, int x2, int y2, int z2) {
        int minX = Math.min(x1, x2);
        int minY = Math.min(y1, y2);
        int minZ = Math.min(z1, z2);
        int maxX = Math.max(x1, x2);
        int maxY = Math.max(y1, y2);
        int maxZ = Math.max(z1, z2);
        return this.hasActivity(worldId, minX, minY, minZ, maxX, maxY, maxZ);
    }

    public boolean hasActivity(UUID worldId, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        WorldNode worldNode = this.worldMap.get(worldId);
        if (worldNode == null) {
            return false;
        }
        for (int x = minX / this.activityResolution; x <= maxX / this.activityResolution; ++x) {
            for (int z = minZ / this.activityResolution; z <= maxZ / this.activityResolution; ++z) {
                for (int y = minY / this.activityResolution; y <= maxY / this.activityResolution; ++y) {
                    if (!worldNode.activityMap.contains(x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void clear() {
        for (WorldNode worldNode : this.worldMap.values()) {
            worldNode.clear();
        }
        this.worldMap.clear();
    }

    public int size() {
        int size = 0;
        for (WorldNode worldNode : this.worldMap.values()) {
            size += worldNode.size;
        }
        return size;
    }

    public int getExpirationAgeTicks() {
        return this.expirationAgeTicks;
    }

    public void setExpirationAgeTicks(int expirationAgeTicks) {
        this.expirationAgeTicks = expirationAgeTicks;
    }

    public int getWorldNodeSkipSize() {
        return this.worldNodeSkipSize;
    }

    public void setWorldNodeSkipSize(int worldNodeSkipSize) {
        this.worldNodeSkipSize = worldNodeSkipSize;
    }

    public void updateBlockCacheHandle() {
        if (this.blockCacheHandle != null) {
            this.blockCacheHandle.disableHandle();
        }
        this.blockCacheHandle = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstanceHandle(BlockCache.class);
    }

    private void checkProcessBlocks() {
        if (!this.processBlocks.isEmpty()) {
            this.processBlocks.clear();
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, "BlockChangeTracker: processBlocks is not empty on starting to add blocks.");
        }
    }

    public static class BlockChangeEntry {
        public final long id;
        public final int tick;
        public final int x;
        public final int y;
        public final int z;
        public final Direction direction;
        public final BlockCache.IBlockCacheNode previousState;
        public int nextEntryTick = -1;

        public BlockChangeEntry(long id, int tick, int x, int y, int z, Direction direction, BlockCache.IBlockCacheNode previousState) {
            this.id = id;
            this.tick = tick;
            this.x = x;
            this.y = y;
            this.z = z;
            this.direction = direction;
            this.previousState = previousState;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof BlockChangeEntry)) {
                return false;
            }
            BlockChangeEntry other = (BlockChangeEntry)obj;
            return this.id == other.id && this.tick == other.tick && this.x == other.x && this.z == other.z && this.y == other.y && this.direction == other.direction;
        }

        public boolean overlapsIntervalOfValidity(BlockChangeEntry other) {
            return this.nextEntryTick < 0 && other.nextEntryTick < 0 || this.nextEntryTick < 0 && this.tick <= other.nextEntryTick || other.nextEntryTick < 0 && other.tick <= this.nextEntryTick || this.tick <= other.nextEntryTick && other.tick <= this.nextEntryTick;
        }

        public boolean isRedundant(int tick, Direction direction, BlockCache.IBlockCacheNode previousState) {
            return tick == this.tick && direction == this.direction && (previousState == null && this.previousState == null || previousState != null && previousState.equals(this.previousState));
        }

        public boolean canUpdate(BlockChangeReference ref, Direction direction) {
            return !(direction != null && direction != this.direction || ref != null && !ref.canUpdateWith(this));
        }
    }

    public static class WorldNode {
        public final CoordMap<ActivityNode> activityMap = new CoordHashMap<ActivityNode>();
        public final LinkedCoordHashMap<LinkedList<BlockChangeEntry>> blocks = new LinkedCoordHashMap();
        public int lastChangeTick = 0;
        public int size = 0;
        public final UUID worldId;

        public WorldNode(UUID worldId) {
            this.worldId = worldId;
        }

        public void clear() {
            this.activityMap.clear();
            this.blocks.clear();
            this.size = 0;
        }

        public ActivityNode getActivityNode(int x, int y, int z, int activityResolution) {
            ActivityNode node = this.activityMap.get(x /= activityResolution, y /= activityResolution, z /= activityResolution);
            if (node == null) {
                node = new ActivityNode();
                this.activityMap.put(x, y, z, node);
            }
            return node;
        }

        public void removeActivityNode(int x, int y, int z, int activityResolution) {
            this.activityMap.remove(x / activityResolution, y / activityResolution, z / activityResolution);
        }
    }

    public static class ActivityNode {
        public int count = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        NONE(BlockFace.SELF),
        X_POS(MapUtil.matchBlockFace(1, 0, 0)),
        X_NEG(MapUtil.matchBlockFace(-1, 0, 0)),
        Y_POS(MapUtil.matchBlockFace(0, 1, 0)),
        Y_NEG(MapUtil.matchBlockFace(0, -1, 0)),
        Z_POS(MapUtil.matchBlockFace(0, 0, 1)),
        Z_NEG(MapUtil.matchBlockFace(0, 0, -1));

        public final BlockFace blockFace;

        public static Direction getDirection(BlockFace blockFace) {
            int x = blockFace.getModX();
            if (x == 1) {
                return X_POS;
            }
            if (x == -1) {
                return X_NEG;
            }
            int y = blockFace.getModY();
            if (y == 1) {
                return Y_POS;
            }
            if (y == -1) {
                return Y_NEG;
            }
            int z = blockFace.getModZ();
            if (z == 1) {
                return Z_POS;
            }
            if (z == -1) {
                return Z_NEG;
            }
            return NONE;
        }

        private Direction(BlockFace blockFace) {
            this.blockFace = blockFace;
        }
    }
}

