/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.blocks.changetracker;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.material.Directional;
import org.bukkit.material.Door;
import org.bukkit.material.MaterialData;

public class BlockChangeListener
implements Listener {
    public static long F_MOVABLE_IGNORE = 2L;
    public static long F_MOVABLE = 132L;
    private final BlockChangeTracker tracker;
    private final boolean retractHasBlocks;
    private boolean enabled = true;
    private final Set<Material> redstoneMaterials = new HashSet<Material>();

    public BlockChangeListener(BlockChangeTracker tracker) {
        this.tracker = tracker;
        if (ReflectionUtil.getMethodNoArgs(BlockPistonRetractEvent.class, "getBlocks", new Class[0]) == null) {
            this.retractHasBlocks = false;
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().info(Streams.STATUS, "Assume legacy piston behavior.");
        } else {
            this.retractHasBlocks = true;
        }
        for (Material material : Material.values()) {
            String name;
            if (!material.isBlock() || (name = material.name().toLowerCase()).indexOf("door") < 0 && name.indexOf("gate") < 0) continue;
            this.redstoneMaterials.add(material);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private BlockFace getDirection(Block pistonBlock) {
        MaterialData data = pistonBlock.getState().getData();
        if (data instanceof Directional) {
            Directional directional = (Directional)data;
            return directional.getFacing();
        }
        return null;
    }

    private BlockFace getRetractDirection(Block pistonBlock, BlockFace eventDirection) {
        BlockFace pistonDirection = this.getDirection(pistonBlock);
        if (pistonDirection == null) {
            return eventDirection;
        }
        return eventDirection.getOppositeFace();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        if (!this.enabled) {
            return;
        }
        BlockFace direction = event.getDirection();
        this.tracker.addPistonBlocks(event.getBlock().getRelative(direction), direction, event.getBlocks());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPistonRetract(BlockPistonRetractEvent event) {
        ArrayList<Block> blocks;
        if (!this.enabled) {
            return;
        }
        if (this.retractHasBlocks) {
            blocks = event.getBlocks();
        } else {
            Location retLoc = event.getRetractLocation();
            if (retLoc == null) {
                blocks = null;
            } else {
                Block retBlock = retLoc.getBlock();
                long flags = BlockProperties.getBlockFlags(retBlock.getType());
                if ((flags & F_MOVABLE_IGNORE) == 0L && (flags & F_MOVABLE) != 0L) {
                    blocks = new ArrayList<Block>(1);
                    blocks.add(retBlock);
                } else {
                    blocks = null;
                }
            }
        }
        Block pistonBlock = event.getBlock();
        BlockFace direction = this.getRetractDirection(pistonBlock, event.getDirection());
        this.tracker.addPistonBlocks(pistonBlock.getRelative(direction.getOppositeFace()), direction, (List<Block>)blocks);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlockRedstone(BlockRedstoneEvent event) {
        int newCurrent;
        if (!this.enabled) {
            return;
        }
        int oldCurrent = event.getOldCurrent();
        if (oldCurrent == (newCurrent = event.getNewCurrent()) || oldCurrent > 0 && newCurrent > 0) {
            return;
        }
        Block block = event.getBlock();
        if (block == null || !this.redstoneMaterials.contains(block.getType())) {
            return;
        }
        this.addRedstoneBlock(block);
    }

    private void addRedstoneBlock(Block block) {
        Door door;
        Block otherBlock;
        MaterialData materialData = block.getState().getData();
        if (materialData instanceof Door && this.redstoneMaterials.contains((otherBlock = block.getRelative((door = (Door)materialData).isTopHalf() ? BlockFace.DOWN : BlockFace.UP)).getType())) {
            this.tracker.addBlocks(block, otherBlock);
            return;
        }
        this.tracker.addBlocks(block);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        if (!this.enabled) {
            return;
        }
        Block block = event.getBlock();
        if (block != null) {
            this.tracker.addBlocks(block);
        }
    }
}

