/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.ds.prefixtree.SimpleCharPrefixTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandUtil {
    public static CommandMap getCommandMap() {
        try {
            return NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(MCAccess.class).getCommandMap();
        }
        catch (Throwable t) {
            StaticLog.logSevere(t);
            return null;
        }
    }

    public static Collection<Command> getCommands() {
        LinkedHashSet<Command> commands = new LinkedHashSet<Command>(500);
        CommandMap commandMap = CommandUtil.getCommandMap();
        if (commandMap != null && commandMap instanceof SimpleCommandMap) {
            commands.addAll(((SimpleCommandMap)commandMap).getCommands());
        }
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            JavaPlugin javaPlugin;
            Map map;
            if (!(plugin instanceof JavaPlugin) || (map = (javaPlugin = (JavaPlugin)plugin).getDescription().getCommands()) == null) continue;
            for (String label : map.keySet()) {
                PluginCommand command = javaPlugin.getCommand(label);
                if (command == null) continue;
                commands.add((Command)command);
            }
        }
        return commands;
    }

    public static String getCommandLabel(String alias, boolean strict) {
        Command command = CommandUtil.getCommand(alias);
        if (command == null) {
            return strict ? null : alias.trim().toLowerCase();
        }
        return command.getLabel().trim().toLowerCase();
    }

    public static Command getCommand(String alias) {
        String lcAlias = alias.trim().toLowerCase();
        CommandMap map = CommandUtil.getCommandMap();
        if (map != null) {
            return map.getCommand(lcAlias);
        }
        return null;
    }

    public static List<String> getCheckTypeTabMatches(String input) {
        String name;
        String ref = input.toUpperCase().replace('-', '_').replace('.', '_');
        ArrayList<String> res = new ArrayList<String>();
        for (CheckType checkType : CheckType.values()) {
            name = checkType.name();
            if (!name.startsWith(ref)) continue;
            res.add(name);
        }
        if (ref.indexOf(95) == -1) {
            for (CheckType checkType : CheckType.values()) {
                name = checkType.name();
                String[] split = name.split("_", 2);
                if (split.length <= 1 || !split[1].startsWith(ref)) continue;
                res.add(name);
            }
        }
        if (!res.isEmpty()) {
            Collections.sort(res);
            return res;
        }
        return null;
    }

    public static List<String> getTabMatches(String input, String[][] model) {
        LinkedList<String> res = new LinkedList<String>();
        String[][] stringArray = model;
        int n = stringArray.length;
        block0: for (int i = 0; i < n; ++i) {
            String[] choices;
            for (String choice : choices = stringArray[i]) {
                if (!choice.startsWith(input)) continue;
                res.add(choices[0]);
                continue block0;
            }
        }
        return res;
    }

    public static void feedCommands(SimpleCharPrefixTree tree, Collection<String> inputs, boolean clear) {
        if (clear) {
            tree.clear();
        }
        for (String input : inputs) {
            if (input == null) continue;
            if (!input.isEmpty()) {
                tree.feed(input);
            }
            if ((input = StringUtil.leftTrim(input).toLowerCase()).isEmpty()) continue;
            tree.feed(input);
            if (!input.startsWith("/")) {
                tree.feed("/" + input);
                continue;
            }
            if ((input = input.substring(1)).isEmpty()) continue;
            tree.feed(input);
        }
    }

    public static void feedCommands(SimpleCharPrefixTree tree, ConfigFile config, String configPath, boolean clear) {
        List prefixes = config.getStringList(configPath);
        if (prefixes != null) {
            CommandUtil.feedCommands(tree, prefixes, clear);
        }
    }
}

