/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.net.FlyingFrequency;
import fr.neatmonster.nocheatplus.checks.net.NetConfig;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.checks.net.model.DataPacketFlying;
import fr.neatmonster.nocheatplus.checks.net.protocollib.BaseAdapter;
import fr.neatmonster.nocheatplus.checks.net.protocollib.ProtocolLibComponent;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import java.util.Arrays;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MovingFlying
extends BaseAdapter {
    public static final int indexOnGround = 0;
    public static final int indexhasPos = 1;
    public static final int indexhasLook = 2;
    public static final int indexX = 0;
    public static final int indexY = 1;
    public static final int indexZ = 2;
    public static final int indexStance = 3;
    public static final int indexYaw = 0;
    public static final int indexPitch = 1;
    private final FlyingFrequency flyingFrequency = new FlyingFrequency();
    private final int idHandled = this.counters.registerKey("packet.flying.handled");
    private final int idAsyncFlying = this.counters.registerKey("packet.flying.asynchronous");
    private boolean packetMismatch = false;

    public MovingFlying(Plugin plugin) {
        super(plugin, ListenerPriority.LOW, PacketType.Play.Client.FLYING, PacketType.Play.Client.LOOK, PacketType.Play.Client.POSITION, PacketType.Play.Client.POSITION_LOOK);
        if (ConfigManager.isTrueForAnyConfig("checks.net.flyingfrequency.active")) {
            NCPAPIProvider.getNoCheatPlusAPI().addFeatureTags("checks", Arrays.asList(FlyingFrequency.class.getSimpleName()));
        }
        NCPAPIProvider.getNoCheatPlusAPI().addComponent(this.flyingFrequency);
    }

    public void onPacketReceiving(PacketEvent event) {
        boolean primaryThread;
        long time = System.currentTimeMillis();
        Player player = event.getPlayer();
        if (player == null) {
            this.counters.add(ProtocolLibComponent.idNullPlayer, 1);
            event.setCancelled(true);
            return;
        }
        NetConfig cc = (NetConfig)this.configFactory.getConfig(player.getWorld());
        NetData data = this.dataFactory.getData(player);
        data.lastKeepAliveTime = time;
        if (!cc.flyingFrequencyActive) {
            return;
        }
        this.counters.add(this.idHandled, 1);
        boolean bl = primaryThread = !event.isAsync();
        if (!primaryThread) {
            this.counters.addSynchronized(this.idAsyncFlying, 1);
        }
        DataPacketFlying packetData = this.packetMismatch ? null : this.interpretPacket(event, time);
        boolean skipFlyingFrequency = false;
        if (packetData != null) {
            if (this.isInvalidContent(packetData)) {
                event.setCancelled(true);
                if (data.debug) {
                    this.debug(player, "Flying packet with malicious content.");
                }
                return;
            }
            switch (data.teleportQueue.processAck(packetData)) {
                case WAITING: {
                    if (data.debug) {
                        this.debug(player, "Incoming packet, still waiting for ACK on outgoing position.");
                    }
                }
                case ACK: {
                    skipFlyingFrequency = true;
                    if (!data.debug) break;
                    this.debug(player, "Incoming packet, interpret as ACK for outgoing position.");
                }
            }
            data.addFlyingQueue(packetData);
        }
        if (!skipFlyingFrequency && this.flyingFrequency.check(player, packetData, time, data, cc)) {
            event.setCancelled(true);
            return;
        }
        if (data.debug) {
            this.debug(player, (packetData == null ? "(Incompatible data)" : packetData.toString()) + (event.isCancelled() ? " CANCEL" : ""));
        }
    }

    private boolean isInvalidContent(DataPacketFlying packetData) {
        if (packetData.hasPos && LocUtil.isBadCoordinate(packetData.getX(), packetData.getY(), packetData.getZ())) {
            return true;
        }
        return packetData.hasLook && LocUtil.isBadCoordinate(packetData.getYaw(), packetData.getPitch());
    }

    private DataPacketFlying interpretPacket(PacketEvent event, long time) {
        List floats;
        List doubles;
        PacketContainer packet = event.getPacket();
        List booleans = packet.getBooleans().getValues();
        if (booleans.size() != 3) {
            this.packetMismatch();
            return null;
        }
        boolean onGround = (Boolean)booleans.get(0);
        boolean hasPos = (Boolean)booleans.get(1);
        boolean hasLook = (Boolean)booleans.get(2);
        if (!hasPos && !hasLook) {
            return new DataPacketFlying(onGround, time);
        }
        if (hasPos) {
            doubles = packet.getDoubles().getValues();
            if (doubles.size() != 3 && doubles.size() != 4) {
                this.packetMismatch();
                return null;
            }
        } else {
            doubles = null;
        }
        if (hasLook) {
            floats = packet.getFloat().getValues();
            if (floats.size() != 2) {
                this.packetMismatch();
                return null;
            }
        } else {
            floats = null;
        }
        if (hasPos && hasLook) {
            return new DataPacketFlying(onGround, (Double)doubles.get(0), (Double)doubles.get(1), (Double)doubles.get(2), ((Float)floats.get(0)).floatValue(), ((Float)floats.get(1)).floatValue(), time);
        }
        if (hasLook) {
            return new DataPacketFlying(onGround, ((Float)floats.get(0)).floatValue(), ((Float)floats.get(1)).floatValue(), time);
        }
        if (hasPos) {
            return new DataPacketFlying(onGround, (double)((Double)doubles.get(0)), (double)((Double)doubles.get(1)), (Double)doubles.get(2), time);
        }
        throw new IllegalStateException("Can't be, it can't be!");
    }

    private void packetMismatch() {
        this.packetMismatch = true;
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, "Data mismatch: disable interpretation of flying packets.");
    }
}

