/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.model;

import fr.neatmonster.nocheatplus.checks.net.model.CountableLocation;
import fr.neatmonster.nocheatplus.checks.net.model.DataLocation;
import fr.neatmonster.nocheatplus.checks.net.model.DataPacketFlying;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TeleportQueue {
    private final Lock lock = new ReentrantLock();
    private final LinkedList<CountableLocation> expectIncoming = new LinkedList();
    private DataLocation expectOutgoing = null;
    private long maxAge = 4000L;
    private int maxQueueSize = 60;
    private CountableLocation lastAck = null;

    public long getMaxAge() {
        return this.maxAge;
    }

    public CountableLocation getLastAck() {
        return this.lastAck;
    }

    public void onTeleportEvent(double x, double y, double z, float yaw, float pitch) {
        this.lock.lock();
        this.lastAck = null;
        this.expectOutgoing = new DataLocation(x, y, z, yaw, pitch);
        this.lock.unlock();
    }

    public CountableLocation onOutgoingTeleport(double x, double y, double z, float yaw, float pitch) {
        CountableLocation res = null;
        long time = System.currentTimeMillis();
        this.lock.lock();
        if (this.expectOutgoing != null) {
            if (this.expectOutgoing.isSameLocation(x, y, z, yaw, pitch)) {
                if (!this.expectIncoming.isEmpty()) {
                    CountableLocation last;
                    Iterator it = this.expectIncoming.iterator();
                    while (it.hasNext()) {
                        CountableLocation ref = (CountableLocation)it.next();
                        if (time < ref.time) {
                            ref.time = time;
                            continue;
                        }
                        if (time - this.maxAge <= ref.time) break;
                        it.remove();
                    }
                    if (!this.expectIncoming.isEmpty() && (last = this.expectIncoming.getLast()).isSameLocation(x, y, z, yaw, pitch)) {
                        last.time = time;
                        ++last.count;
                        res = last;
                    }
                }
                if (res == null) {
                    res = new CountableLocation(x, y, z, yaw, pitch, 1, time);
                    this.expectIncoming.addLast(res);
                    if (this.expectIncoming.size() > this.maxQueueSize) {
                        this.expectIncoming.removeFirst();
                    }
                }
            }
            this.expectOutgoing = null;
        }
        this.lock.unlock();
        return res;
    }

    public AckResolution processAck(DataPacketFlying packetData) {
        if (!packetData.hasPos || !packetData.hasLook) {
            return AckResolution.IDLE;
        }
        this.lock.lock();
        AckResolution res = this.expectIncoming.isEmpty() ? AckResolution.IDLE : this.getAckResolution(packetData);
        this.lock.unlock();
        return res;
    }

    private AckResolution getAckResolution(DataPacketFlying packetData) {
        Iterator it = this.expectIncoming.iterator();
        while (it.hasNext()) {
            CountableLocation ref = (CountableLocation)it.next();
            if (packetData.time - this.maxAge >= ref.time) {
                it.remove();
                continue;
            }
            if (packetData.isSameLocation(ref)) {
                while (ref != this.expectIncoming.getFirst()) {
                    this.expectIncoming.removeFirst();
                }
                if (--ref.count <= 0) {
                    this.expectIncoming.removeFirst();
                }
                this.lastAck = ref;
                return AckResolution.ACK;
            }
            if (packetData.time >= ref.time) continue;
            ref.time = packetData.time;
        }
        return this.expectIncoming.isEmpty() ? AckResolution.IDLE : AckResolution.WAITING;
    }

    public void clear() {
        this.lock.lock();
        this.expectIncoming.clear();
        this.expectOutgoing = null;
        this.lock.unlock();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AckResolution {
        WAITING,
        ACK,
        IDLE;

    }
}

