/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.player;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.magic.LostGround;
import fr.neatmonster.nocheatplus.checks.moving.magic.Magic;
import fr.neatmonster.nocheatplus.checks.moving.magic.MagicAir;
import fr.neatmonster.nocheatplus.checks.moving.magic.MagicLiquid;
import fr.neatmonster.nocheatplus.checks.moving.model.LiftOffEnvelope;
import fr.neatmonster.nocheatplus.checks.moving.model.LocationData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.checks.moving.player.UnusedVelocity;
import fr.neatmonster.nocheatplus.checks.moving.util.AuxMoving;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.BridgeEnchant;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.components.location.IGetPosition;
import fr.neatmonster.nocheatplus.components.modifier.IAttributeAccess;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceHandle;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.ds.count.ActionAccumulator;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.location.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurvivalFly
extends Check {
    private static final String DOUBLE_BUNNY = "doublebunny";
    private static final int bunnyHopMax = 10;
    private static final double bunnyDivFriction = 160.0;
    private final ArrayList<String> tags = new ArrayList(15);
    private final ArrayList<String> justUsedWorkarounds = new ArrayList();
    private final Set<String> reallySneaking = new HashSet<String>(30);
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    private final BlockChangeTracker blockChangeTracker;
    private final AuxMoving aux = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(AuxMoving.class);
    private IGenericInstanceHandle<IAttributeAccess> attributeAccess = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstanceHandle(IAttributeAccess.class);

    public SurvivalFly() {
        super(CheckType.MOVING_SURVIVALFLY);
        this.blockChangeTracker = NCPAPIProvider.getNoCheatPlusAPI().getBlockChangeTracker();
    }

    public Location check(Player player, PlayerLocation from, PlayerLocation to, boolean mightBeMultipleMoves, MovingData data, MovingConfig cc, int tick, long now, boolean useBlockChangeTracker) {
        int tagsLength;
        double[] blockMoveResult;
        boolean resetFrom;
        boolean sprinting;
        boolean resetTo;
        boolean hasHdist;
        double xDistance;
        double yDistance;
        double zDistance;
        double hDistance;
        this.tags.clear();
        if (data.debug) {
            this.justUsedWorkarounds.clear();
            data.ws.setJustUsedIds(this.justUsedWorkarounds);
        }
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        boolean isSamePos = from.isSamePos(to);
        if (isSamePos) {
            hDistance = 0.0;
            zDistance = 0.0;
            yDistance = 0.0;
            xDistance = 0.0;
            hasHdist = false;
        } else {
            xDistance = to.getX() - from.getX();
            yDistance = thisMove.yDistance;
            zDistance = to.getZ() - from.getZ();
            if (xDistance == 0.0 && zDistance == 0.0) {
                hDistance = 0.0;
                hasHdist = false;
            } else {
                hasHdist = true;
                hDistance = thisMove.hDistance;
            }
        }
        if (data.liftOffEnvelope == LiftOffEnvelope.UNKNOWN) {
            data.adjustMediumProperties(from);
        }
        boolean fromOnGround = thisMove.from.onGround;
        boolean toOnGround = thisMove.to.onGround || useBlockChangeTracker && this.toOnGroundPastStates(from, to, thisMove, tick, data, cc);
        boolean bl = resetTo = toOnGround || to.isResetCond();
        if (data.lostSprintCount > 0) {
            if (resetTo && (fromOnGround || from.isResetCond()) || hDistance <= 0.221) {
                data.lostSprintCount = 0;
                this.tags.add("invalidate_lostsprint");
                sprinting = now <= data.timeSprinting + cc.sprintingGrace;
            } else {
                this.tags.add("lostsprint");
                sprinting = true;
                data.lostSprintCount = data.lostSprintCount < 3 && toOnGround || to.isResetCond() ? 0 : --data.lostSprintCount;
            }
        } else if (now <= data.timeSprinting + cc.sprintingGrace) {
            if (now != data.timeSprinting) {
                this.tags.add("sprintgrace");
            }
            sprinting = true;
        } else {
            sprinting = false;
        }
        thisMove.walkSpeed = 0.221 * ((double)data.walkSpeed / 0.2);
        this.setNextFriction(thisMove, data, cc);
        if (fromOnGround || from.isResetCond()) {
            resetFrom = true;
        } else if (isSamePos) {
            if (useBlockChangeTracker && from.isOnGroundOpportune(cc.yOnGround, 0L, this.blockChangeTracker, data.blockChangeRef, tick)) {
                resetFrom = true;
                this.tags.add("pastground_from");
            } else {
                resetFrom = lastMove.toIsValid && lastMove.hDistance > 0.0 && lastMove.yDistance < -0.3 ? LostGround.lostGroundStill(player, from, to, hDistance, yDistance, sprinting, lastMove, data, cc, this.tags) : false;
            }
        } else {
            resetFrom = LostGround.lostGround(player, from, to, hDistance, yDistance, sprinting, lastMove, data, cc, useBlockChangeTracker ? this.blockChangeTracker : null, this.tags);
        }
        if (thisMove.touchedGround && !thisMove.from.onGround && !thisMove.to.onGround) {
            data.resetVelocityJumpPhase();
        }
        if (data.isVelocityJumpPhase() || data.resetVelocityJumpPhase()) {
            this.tags.add("dirty");
        }
        boolean bl2 = thisMove.headObstructed = yDistance > 0.0 ? from.isHeadObstructed(yDistance) : from.isHeadObstructed();
        if ((from.getBlockFlags() & 0x4000000L) != 0L) {
            data.sfNoLowJump = true;
        }
        --data.bunnyhopDelay;
        boolean bl3 = thisMove.downStream = hDistance > thisMove.walkSpeed * 0.5203619909502263 && thisMove.from.inLiquid && from.isDownStream(xDistance, zDistance);
        if (thisMove.from.onIce || thisMove.to.onIce) {
            data.sfOnIce = 20;
        } else if (data.sfOnIce > 0) {
            --data.sfOnIce;
        }
        double hAllowedDistance = 0.0;
        double hDistanceAboveLimit = 0.0;
        double hFreedom = 0.0;
        if (hasHdist) {
            hAllowedDistance = this.setAllowedhDist(player, sprinting, thisMove, data, cc, false);
            hDistanceAboveLimit = hDistance - hAllowedDistance;
            if (hDistanceAboveLimit > 0.0) {
                double[] res = this.hDistAfterFailure(player, from, to, hAllowedDistance, hDistanceAboveLimit, sprinting, thisMove, lastMove, data, cc, false);
                hAllowedDistance = res[0];
                hDistanceAboveLimit = res[1];
                hFreedom = res[2];
            } else {
                data.clearActiveHorVel();
                hFreedom = 0.0;
                if (resetFrom && data.bunnyhopDelay <= 6) {
                    data.bunnyhopDelay = 0;
                }
            }
            double fcmhv = Math.max(1.0, Math.min(10.0, thisMove.hDistance / thisMove.hAllowedDistanceBase));
            ++data.combinedMediumHCount;
            data.combinedMediumHValue += fcmhv;
            if (data.combinedMediumHCount > 30) {
                double fcmh = data.combinedMediumHValue / (double)data.combinedMediumHCount;
                double limitFCMH = data.liftOffEnvelope == LiftOffEnvelope.NORMAL ? 1.34 : (data.liftOffEnvelope == LiftOffEnvelope.LIMIT_LIQUID || data.liftOffEnvelope == LiftOffEnvelope.LIMIT_NEAR_GROUND ? 1.1 : 1.0);
                if (fcmh > limitFCMH && !data.isVelocityJumpPhase()) {
                    hDistanceAboveLimit = hDistance * (fcmh - limitFCMH);
                    this.tags.add("hacc");
                    data.combinedMediumHCount = 0;
                    data.combinedMediumHValue = 0.0;
                } else {
                    data.combinedMediumHCount = 1;
                    data.combinedMediumHValue = fcmhv;
                }
            }
            if (hDistanceAboveLimit <= 0.0 && hDistance > 0.1 && yDistance == 0.0 && !toOnGround && !fromOnGround && lastMove.toIsValid && lastMove.yDistance == 0.0 && BlockProperties.isLiquid(to.getTypeId()) && BlockProperties.isLiquid(from.getTypeId()) && !from.isHeadObstructed() && !to.isHeadObstructed()) {
                hDistanceAboveLimit = Math.max(hDistanceAboveLimit, hDistance);
                this.tags.add("waterwalk");
            }
            if (sprinting && data.lostSprintCount == 0 && !cc.assumeSprint && hDistance > thisMove.walkSpeed && !data.hasActiveHorVel() && TrigUtil.isMovingBackwards(xDistance, zDistance, from.getYaw()) && !player.hasPermission("nocheatplus.checks.moving.survivalfly.sprinting")) {
                hDistanceAboveLimit = Math.max(hDistanceAboveLimit, hDistance);
                this.tags.add("sprintback");
            }
        } else {
            data.clearActiveHorVel();
            thisMove.hAllowedDistanceBase = 0.0;
            thisMove.hAllowedDistance = 0.0;
        }
        double vAllowedDistance = 0.0;
        double vDistanceAboveLimit = 0.0;
        if (yDistance >= 0.0 && yDistance <= cc.sfStepHeight && toOnGround && fromOnGround) {
            vAllowedDistance = cc.sfStepHeight;
        } else if (from.isInWeb()) {
            double[] res = this.vDistWeb(player, thisMove, toOnGround, hDistanceAboveLimit, now, data, cc);
            vAllowedDistance = res[0];
            vDistanceAboveLimit = res[1];
            if (res[0] == Double.MIN_VALUE && res[1] == Double.MIN_VALUE) {
                if (data.debug) {
                    this.tags.add("silentsbcobweb");
                    this.outputDebug(player, to, data, cc, hDistance, hAllowedDistance, hFreedom, yDistance, vAllowedDistance, fromOnGround, resetFrom, toOnGround, resetTo, thisMove);
                    data.ws.setJustUsedIds(null);
                }
                return data.getSetBack(to);
            }
        } else if (from.isOnClimbable()) {
            vDistanceAboveLimit = this.vDistClimbable(player, from, to, fromOnGround, toOnGround, thisMove, lastMove, yDistance, data);
        } else if (thisMove.from.inLiquid) {
            double[] res = this.vDistLiquid(from, to, toOnGround, yDistance, lastMove, data);
            vAllowedDistance = res[0];
            vDistanceAboveLimit = res[1];
            if (vDistanceAboveLimit <= 0.0 && yDistance > 0.0 && Math.abs(yDistance) > Magic.swimBaseSpeedV()) {
                data.setFrictionJumpPhase();
            }
        } else {
            double[] res = this.vDistAir(now, player, from, fromOnGround, resetFrom, to, toOnGround, resetTo, hDistanceAboveLimit, yDistance, mightBeMultipleMoves, lastMove, data, cc);
            vAllowedDistance = res[0];
            vDistanceAboveLimit = res[1];
        }
        if (useBlockChangeTracker && vDistanceAboveLimit > 0.0 && (blockMoveResult = this.getVerticalBlockMoveResult(yDistance, from, to, tick, data)) != null) {
            vAllowedDistance = blockMoveResult[0];
            vDistanceAboveLimit = blockMoveResult[1];
        }
        if (data.debug) {
            this.outputDebug(player, to, data, cc, hDistance, hAllowedDistance, hFreedom, yDistance, vAllowedDistance, fromOnGround, resetFrom, toOnGround, resetTo, thisMove);
            tagsLength = this.tags.size();
            data.ws.setJustUsedIds(null);
        } else {
            tagsLength = 0;
        }
        double result = (Math.max(hDistanceAboveLimit, 0.0) + Math.max(vDistanceAboveLimit, 0.0)) * 100.0;
        if (result > 0.0) {
            Location vLoc = this.handleViolation(now, result, player, from, to, data, cc);
            if (vLoc != null) {
                return vLoc;
            }
        } else {
            if (now - data.sfVLTime > cc.survivalFlyVLFreeze) {
                data.survivalFlyVL *= 0.95;
            }
            if (hDistanceAboveLimit < 0.0 && result <= 0.0 && !isSamePos && data.sfHorizontalBuffer < cc.hBufMax) {
                this.hBufRegain(hDistance, Math.min(0.2, Math.abs(hDistanceAboveLimit)), data, cc);
            }
        }
        LiftOffEnvelope oldLiftOffEnvelope = data.liftOffEnvelope;
        if (to.isInLiquid()) {
            if (!fromOnGround || toOnGround || data.liftOffEnvelope != LiftOffEnvelope.NORMAL || data.sfJumpPhase > 0 || thisMove.from.inLiquid) {
                data.liftOffEnvelope = to.isNextToGround(0.15, 0.4) ? LiftOffEnvelope.LIMIT_NEAR_GROUND : LiftOffEnvelope.LIMIT_LIQUID;
            }
        } else if (thisMove.to.inWeb) {
            data.liftOffEnvelope = LiftOffEnvelope.NO_JUMP;
        } else if (resetTo) {
            data.liftOffEnvelope = LiftOffEnvelope.NORMAL;
        } else if (thisMove.from.inLiquid) {
            if (resetTo || data.liftOffEnvelope != LiftOffEnvelope.NORMAL || data.sfJumpPhase > 0) {
                data.liftOffEnvelope = to.isNextToGround(0.15, 0.4) ? LiftOffEnvelope.LIMIT_NEAR_GROUND : LiftOffEnvelope.LIMIT_LIQUID;
            }
        } else if (thisMove.from.inWeb) {
            data.liftOffEnvelope = LiftOffEnvelope.NO_JUMP;
        } else if (resetFrom || thisMove.touchedGround) {
            data.liftOffEnvelope = LiftOffEnvelope.NORMAL;
        }
        if (oldLiftOffEnvelope != data.liftOffEnvelope) {
            data.insideMediumCount = 0;
            data.combinedMediumHCount = 0;
            data.combinedMediumHValue = 0.0;
        } else {
            data.insideMediumCount = !resetFrom || !resetTo ? 0 : ++data.insideMediumCount;
        }
        boolean inAir = false;
        if (resetTo) {
            if (toOnGround && data.bunnyhopDelay > 0 && yDistance > 0.0 && to.getY() > data.getSetBackY() + 0.12 && !from.isResetCond() && !to.isResetCond()) {
                data.bunnyhopDelay = 0;
                this.tags.add("resetbunny");
            }
            data.setSetBack(to);
            data.sfJumpPhase = 0;
            data.clearAccounting();
            data.sfNoLowJump = false;
            if (data.sfLowJump && resetFrom) {
                data.sfLowJump = false;
            }
            if (hFreedom <= 0.0 && thisMove.verVelUsed == null) {
                data.resetVelocityJumpPhase();
            }
        } else if (resetFrom) {
            data.setSetBack(from);
            data.sfJumpPhase = 1;
            data.clearAccounting();
            data.sfLowJump = false;
        } else {
            ++data.sfJumpPhase;
            if (to.getY() < 0.0 && cc.sfSetBackPolicyVoid) {
                data.setSetBack(to);
            }
            inAir = true;
        }
        if (inAir) {
            data.sfZeroVdistRepeat = yDistance == 0.0 ? ++data.sfZeroVdistRepeat : 0;
        } else {
            data.sfZeroVdistRepeat = 0;
            data.ws.resetConditions("reset.notinair");
        }
        double d = cc.velocityStrictInvalidation ? thisMove.hAllowedDistanceBase : thisMove.hAllowedDistanceBase / 2.0;
        if (hDistance <= d) {
            data.clearActiveHorVel();
        }
        if (data.debug) {
            data.getVerticalVelocityTracker().updateBlockedState(tick, thisMove.headObstructed || thisMove.from.resetCond, thisMove.touchedGround || thisMove.to.resetCond);
            UnusedVelocity.checkUnusedVelocity(player, this.type, data, cc);
        }
        data.lastFrictionHorizontal = data.nextFrictionHorizontal;
        data.lastFrictionVertical = data.nextFrictionVertical;
        if (data.debug && this.tags.size() > tagsLength) {
            this.logPostViolationTags(player);
        }
        return null;
    }

    private boolean toOnGroundPastStates(PlayerLocation from, PlayerLocation to, PlayerMoveData thisMove, int tick, MovingData data, MovingConfig cc) {
        if (to.isOnGroundOpportune(cc.yOnGround, 0L, this.blockChangeTracker, data.blockChangeRef, tick)) {
            this.tags.add("pastground_to");
            return true;
        }
        return false;
    }

    private double[] getVerticalBlockMoveResult(double yDistance, PlayerLocation from, PlayerLocation to, int tick, MovingData data) {
        if (yDistance > 0.0) {
            if (yDistance <= 1.015 && from.matchBlockChange(this.blockChangeTracker, data.blockChangeRef, BlockChangeTracker.Direction.Y_POS, Math.min(yDistance, 1.0))) {
                if (yDistance > 1.0 && to.getY() - (double)to.getBlockY() >= 0.015) {
                    return null;
                }
                this.tags.add("blkmv_y_pos");
                double maxDistYPos = yDistance;
                return new double[]{maxDistYPos, 0.0};
            }
        } else if (yDistance < 0.0 && yDistance >= -1.0 && from.matchBlockChange(this.blockChangeTracker, data.blockChangeRef, BlockChangeTracker.Direction.Y_NEG, -yDistance)) {
            this.tags.add("blkmv_y_neg");
            double maxDistYNeg = yDistance;
            return new double[]{maxDistYNeg, 0.0};
        }
        return null;
    }

    private void setNextFriction(PlayerMoveData thisMove, MovingData data, MovingConfig cc) {
        LocationData from = thisMove.from;
        LocationData to = thisMove.to;
        if (from.inWeb || to.inWeb) {
            data.nextFrictionVertical = 0.0;
            data.nextFrictionHorizontal = 0.0;
        } else if (from.onClimbable || to.onClimbable) {
            data.nextFrictionVertical = 0.0;
            data.nextFrictionHorizontal = 0.0;
        } else if (from.inLiquid) {
            if (from.inLava) {
                data.nextFrictionVertical = 0.535;
                data.nextFrictionHorizontal = 0.535;
            } else {
                data.nextFrictionVertical = 0.89;
                data.nextFrictionHorizontal = 0.89;
            }
        } else if (!from.onGround && !to.onGround) {
            data.nextFrictionVertical = 0.98;
            data.nextFrictionHorizontal = 0.98;
        } else {
            data.nextFrictionHorizontal = 0.0;
            data.nextFrictionVertical = 0.98;
        }
    }

    private double setAllowedhDist(Player player, boolean sprinting, PlayerMoveData thisMove, MovingData data, MovingConfig cc, boolean checkPermissions) {
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        double hAllowedDistance = 0.0;
        boolean sfDirty = data.isVelocityJumpPhase();
        double friction = data.lastFrictionHorizontal;
        boolean useBaseModifiers = false;
        if (thisMove.from.inWeb) {
            data.sfOnIce = 0;
            hAllowedDistance = 0.4751131221719457 * thisMove.walkSpeed * (double)cc.survivalFlyWalkingSpeed / 100.0;
            friction = 0.0;
        } else if (thisMove.from.inLiquid && thisMove.to.inLiquid) {
            int level;
            hAllowedDistance = 0.5203619909502263 * thisMove.walkSpeed * (double)cc.survivalFlySwimmingSpeed / 100.0;
            if ((thisMove.from.inWater || !thisMove.from.inLava) && (level = BridgeEnchant.getDepthStriderLevel(player)) > 0) {
                hAllowedDistance *= Magic.modDepthStrider[level];
                useBaseModifiers = true;
            }
        } else if (!sfDirty && thisMove.from.onGround && player.isSneaking() && this.reallySneaking.contains(player.getName()) && (!checkPermissions || !player.hasPermission("nocheatplus.checks.moving.survivalfly.sneaking"))) {
            hAllowedDistance = 0.5882352941176471 * thisMove.walkSpeed * (double)cc.survivalFlySneakingSpeed / 100.0;
            friction = 0.0;
        } else if (!(sfDirty || !thisMove.from.onGround || !player.isBlocking() || checkPermissions && player.hasPermission("nocheatplus.checks.moving.survivalfly.blocking"))) {
            hAllowedDistance = 0.7239819004524887 * thisMove.walkSpeed * (double)cc.survivalFlyBlockingSpeed / 100.0;
            friction = 0.0;
        } else {
            useBaseModifiers = true;
            hAllowedDistance = sprinting ? thisMove.walkSpeed * (double)cc.survivalFlySprintingSpeed / 100.0 : thisMove.walkSpeed * (double)cc.survivalFlyWalkingSpeed / 100.0;
            friction = 0.0;
        }
        if (useBaseModifiers) {
            double attrMod;
            if (sprinting) {
                hAllowedDistance *= data.multSprinting;
            }
            if ((attrMod = this.attributeAccess.getHandle().getSpeedAttributeMultiplier(player)) == Double.MAX_VALUE) {
                double speedAmplifier = ((MCAccess)this.mcAccess.getHandle()).getFasterMovementAmplifier(player);
                if (!Double.isInfinite(speedAmplifier)) {
                    hAllowedDistance *= 1.0 + 0.2 * (speedAmplifier + 1.0);
                }
            } else {
                hAllowedDistance *= attrMod;
                if (sprinting && hAllowedDistance < 0.29 && cc.sfSlownessSprintHack && (player.hasPotionEffect(PotionEffectType.SLOW) || (double)data.walkSpeed < 0.2 || attrMod < 1.0)) {
                    hAllowedDistance = this.slownessSprintHack(player, hAllowedDistance);
                }
            }
        }
        if (thisMove.downStream) {
            hAllowedDistance *= 1.6521739130434783;
        }
        if (data.sfOnIce > 0) {
            hAllowedDistance *= 2.5;
        }
        if (checkPermissions && player.hasPermission("nocheatplus.checks.moving.survivalfly.speeding")) {
            hAllowedDistance *= (double)cc.survivalFlySpeedingSpeed / 100.0;
        }
        thisMove.hAllowedDistanceBase = hAllowedDistance;
        if (thisMove.hDistance <= hAllowedDistance) {
            data.nextFrictionHorizontal = 1.0;
        }
        if (lastMove.toIsValid && friction > 0.0) {
            hAllowedDistance = Math.max(hAllowedDistance, lastMove.hDistance * friction);
        }
        thisMove.hAllowedDistance = hAllowedDistance;
        return thisMove.hAllowedDistance;
    }

    private double slownessSprintHack(Player player, double hAllowedDistance) {
        return 0.29;
    }

    public boolean isReallySneaking(Player player) {
        return this.reallySneaking.contains(player.getName());
    }

    private double[] vDistAir(long now, Player player, PlayerLocation from, boolean fromOnGround, boolean resetFrom, PlayerLocation to, boolean toOnGround, boolean resetTo, double hDistance, double yDistance, boolean mightBeMultipleMoves, PlayerMoveData lastMove, MovingData data, MovingConfig cc) {
        boolean strictVdistRel;
        boolean envelopeHack;
        double yDistChange;
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        double vAllowedDistance = 0.0;
        double vDistanceAboveLimit = 0.0;
        double d = yDistChange = lastMove.toIsValid ? yDistance - lastMove.yDistance : Double.MAX_VALUE;
        if (!resetFrom && !resetTo && MagicAir.venvHacks(from, to, yDistance, yDistChange, thisMove, lastMove, data)) {
            envelopeHack = true;
            this.tags.add("hack_venv");
        } else {
            envelopeHack = false;
        }
        double maxJumpGain = data.liftOffEnvelope.getMaxJumpGain(data.jumpAmplifier);
        double jumpGainMargin = 0.005;
        if (lastMove.toIsValid && Magic.fallingEnvelope(yDistance, lastMove.yDistance, data.lastFrictionVertical, 0.0)) {
            vAllowedDistance = lastMove.yDistance * data.lastFrictionVertical - 0.0624;
            strictVdistRel = true;
        } else if (resetFrom || thisMove.touchedGroundWorkaround) {
            vAllowedDistance = toOnGround ? (yDistance > cc.sfStepHeight && yDistance - cc.sfStepHeight < 3.0E-8 && to.isOnGroundDueToStandingOnAnEntity() ? yDistance : Math.max(cc.sfStepHeight, maxJumpGain + 0.005)) : (yDistance < 0.0 || yDistance > cc.sfStepHeight || !this.tags.contains("lostground_couldstep") ? maxJumpGain + 0.005 : yDistance);
            strictVdistRel = false;
        } else if (lastMove.toIsValid) {
            if (lastMove.yDistance >= -Math.max(0.0417, 1.3 * Math.abs(yDistance)) && lastMove.yDistance <= 0.0 && (lastMove.touchedGround || lastMove.to.extraPropertiesValid && lastMove.to.resetCond)) {
                vAllowedDistance = resetTo ? cc.sfStepHeight : maxJumpGain + 0.005;
                strictVdistRel = false;
            } else {
                vAllowedDistance = lastMove.yDistance * data.lastFrictionVertical - 0.0624;
                strictVdistRel = true;
            }
        } else {
            vAllowedDistance = this.vAllowedDistanceNoData(thisMove, lastMove, maxJumpGain, 0.005, data, cc);
            strictVdistRel = false;
        }
        boolean vDistRelVL = false;
        double yDistDiffEx = yDistance - vAllowedDistance;
        if (envelopeHack || yDistDiffEx <= 0.0 && yDistDiffEx > -0.021000000000000005) {
            vDistRelVL = false;
        } else if (yDistDiffEx > 0.0) {
            if (!(yDistance <= 0.0) || !resetTo && !thisMove.touchedGround) {
                if (lastMove.toIsValid) {
                    if (!(yDistance < 0.0 && lastMove.yDistance < 0.0 && yDistChange > -0.0834 && (from.isOnGround(Math.abs(yDistance) + 0.001) || BlockProperties.isLiquid(to.getTypeId(to.getBlockX(), Location.locToBlock((double)(to.getY() - 0.5)), to.getBlockZ()))) || yDistDiffEx < 0.0312 && data.sfJumpPhase == 1 && to.getY() - data.getSetBackY() <= data.liftOffEnvelope.getMaxJumpHeight(data.jumpAmplifier) && lastMove.yDistance <= maxJumpGain && yDistance > -0.0834 && yDistance < lastMove.yDistance && lastMove.yDistance - yDistance > 0.016666666666666666 || yDistDiffEx < 0.0624 && data.sfJumpPhase == 1 && data.liftOffEnvelope != LiftOffEnvelope.NORMAL && lastMove.from.extraPropertiesValid && lastMove.from.inLiquid && lastMove.yDistance < -0.025 && lastMove.yDistance > -0.1044 && yDistance < lastMove.yDistance - 0.001 || lastMove.toIsValid && MagicAir.oddJunction(from, to, yDistance, yDistChange, yDistDiffEx, maxJumpGain, resetTo, thisMove, lastMove, data, cc))) {
                        vDistRelVL = true;
                    }
                } else {
                    vDistRelVL = true;
                }
            }
        } else if (yDistance >= 0.0) {
            if (!(!strictVdistRel || Math.abs(yDistDiffEx) <= 0.021000000000000005 || vAllowedDistance <= 0.2 || yDistance > 0.0 && lastMove.toIsValid && lastMove.yDistance > yDistance && lastMove.yDistance - yDistance <= lastMove.yDistance / 4.0 && data.isVelocityJumpPhase() || thisMove.headObstructed || lastMove.toIsValid && lastMove.headObstructed && lastMove.yDistance >= 0.0 || lastMove.toIsValid && MagicAir.oddJunction(from, to, yDistance, yDistChange, yDistDiffEx, maxJumpGain, resetTo, thisMove, lastMove, data, cc) || thisMove.yDistance < 1.0 && thisMove.yDistance > 0.9 && lastMove.yDistance >= 1.5 && data.sfJumpPhase <= 2 && lastMove.verVelUsed != null && (lastMove.verVelUsed.flags & 0x300L) != 0L)) {
                vDistRelVL = true;
            }
        } else if (!(yDistance < -3.0 && lastMove.yDistance < -3.0 && Math.abs(yDistDiffEx) < 0.41700000000000004 || resetTo && (yDistDiffEx > -0.021000000000000005 || !fromOnGround && !thisMove.touchedGround && yDistChange >= 0.0) || yDistance > lastMove.yDistance - 0.0834 - 0.021000000000000005 && (resetTo || thisMove.touchedGround) || resetFrom && yDistance >= -0.5 && (yDistance > -0.31 || (resetTo || to.isAboveStairs()) && lastMove.yDistance < 0.0) || data.liftOffEnvelope == LiftOffEnvelope.LIMIT_LIQUID && data.sfJumpPhase == 1 && lastMove.toIsValid && lastMove.from.inLiquid && (!lastMove.to.extraPropertiesValid || !lastMove.to.inLiquid) && !resetFrom && resetTo && lastMove.yDistance > 0.0 && lastMove.yDistance < 0.025 && yDistance < 0.0 && Math.abs(Math.abs(yDistance) - lastMove.yDistance) < 0.010500000000000002 || yDistance <= 0.0 && yDistance > -0.1044 && (thisMove.headObstructed || lastMove.toIsValid && lastMove.headObstructed && lastMove.yDistance >= 0.0) || lastMove.toIsValid && MagicAir.oddJunction(from, to, yDistance, yDistChange, yDistDiffEx, maxJumpGain, resetTo, thisMove, lastMove, data, cc))) {
            vDistRelVL = true;
        }
        if (vDistRelVL && data.getOrUseVerticalVelocity(yDistance) == null) {
            vDistanceAboveLimit = Math.max(vDistanceAboveLimit, Math.abs(yDistance - vAllowedDistance));
            this.tags.add("vdistrel");
        }
        if (yDistance > 0.0 && !data.isVelocityJumpPhase()) {
            double vAllowedAbsoluteDistance = data.liftOffEnvelope.getMaxJumpHeight(data.jumpAmplifier);
            double totalVDistViolation = to.getY() - data.getSetBackY() - vAllowedAbsoluteDistance;
            if (!(!(totalVDistViolation > 0.0) || (fromOnGround || thisMove.touchedGroundWorkaround || lastMove.touchedGround) && toOnGround && yDistance <= cc.sfStepHeight || yDistance <= cc.sfStepHeight && thisMove.touchedGroundWorkaround && this.tags.contains("lostground_couldstep") || Magic.skipPaper(thisMove, lastMove, data) || data.getOrUseVerticalVelocity(yDistance) != null)) {
                vDistanceAboveLimit = Math.max(vDistanceAboveLimit, totalVDistViolation);
                this.tags.add("vdistsb");
            }
        }
        if (data.sfLowJump) {
            this.tags.add("lowjump");
        }
        if (!(envelopeHack || resetFrom || resetTo)) {
            vDistanceAboveLimit = Math.max(vDistanceAboveLimit, this.inAirChecks(now, from, to, hDistance, yDistance, thisMove, lastMove, data, cc));
        }
        if (!(!(vDistanceAboveLimit <= 0.0) || !(yDistance > cc.sfStepHeight) || !(yDistance < data.liftOffEnvelope.getMinJumpGain(data.jumpAmplifier)) || thisMove.headObstructed || thisMove.from.resetCond || thisMove.to.resetCond || !thisMove.from.onGround && !thisMove.touchedGroundWorkaround || !thisMove.to.onGround || thisMove.touchedGroundWorkaround && lastMove.toIsValid && lastMove.yDistance <= 0.0 && yDistance + Math.abs(lastMove.yDistance) <= 2.0 * (maxJumpGain + 0.1) || player.hasPermission("nocheatplus.checks.moving.survivalfly.step") || data.getOrUseVerticalVelocity(yDistance) != null)) {
            vDistanceAboveLimit = yDistance - cc.sfStepHeight;
            this.tags.add("step");
        }
        int maxJumpPhase = data.liftOffEnvelope.getMaxJumpPhase(data.jumpAmplifier);
        if (!(envelopeHack || data.sfJumpPhase <= maxJumpPhase || data.isVelocityJumpPhase() || yDistance < 0.0 || resetFrom || data.getOrUseVerticalVelocity(yDistance) != null)) {
            vDistanceAboveLimit = Math.max(vDistanceAboveLimit, Math.max(yDistance, 0.15));
            this.tags.add("maxphase");
        }
        return new double[]{vAllowedDistance, vDistanceAboveLimit};
    }

    private double vAllowedDistanceNoData(PlayerMoveData thisMove, PlayerMoveData lastMove, double maxJumpGain, double jumpGainMargin, MovingData data, MovingConfig cc) {
        double vAllowedDistance;
        if (lastMove.valid) {
            this.tags.add("data_reset");
        } else {
            this.tags.add("data_missing");
        }
        if (thisMove.yDistance > -0.1044 && thisMove.yDistance < 0.0) {
            vAllowedDistance = thisMove.yDistance;
        } else if (thisMove.from.onGround) {
            vAllowedDistance = maxJumpGain + jumpGainMargin;
            if (thisMove.to.onGround) {
                vAllowedDistance = Math.max(cc.sfStepHeight, vAllowedDistance);
            }
        } else if (Magic.skipPaper(thisMove, lastMove, data)) {
            vAllowedDistance = 0.01;
            this.tags.add("skip_paper");
        } else {
            vAllowedDistance = 0.0;
        }
        return vAllowedDistance;
    }

    private double inAirChecks(long now, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, PlayerMoveData thisMove, PlayerMoveData lastMove, MovingData data, MovingConfig cc) {
        boolean yDirChange;
        double vDistanceAboveLimit = 0.0;
        boolean bl = yDirChange = lastMove.toIsValid && lastMove.yDistance != yDistance && (yDistance <= 0.0 && lastMove.yDistance >= 0.0 || yDistance >= 0.0 && lastMove.yDistance <= 0.0);
        if (yDirChange) {
            vDistanceAboveLimit = this.yDirChange(from, to, yDistance, vDistanceAboveLimit, lastMove, data);
        }
        if (cc.survivalFlyAccountingV) {
            if (yDirChange && lastMove.yDistance > 0.0) {
                data.vDistAcc.clear();
                data.vDistAcc.add((float)yDistance);
            } else if (thisMove.verVelUsed == null) {
                data.vDistAcc.add((float)yDistance);
                double accAboveLimit = SurvivalFly.verticalAccounting(yDistance, data.vDistAcc, this.tags, "vacc" + (data.isVelocityJumpPhase() ? "dirty" : ""));
                if (accAboveLimit > vDistanceAboveLimit && data.getOrUseVerticalVelocity(yDistance) == null) {
                    vDistanceAboveLimit = accAboveLimit;
                }
            } else {
                data.vDistAcc.clear();
            }
        }
        return vDistanceAboveLimit;
    }

    private static final double verticalAccounting(double yDistance, ActionAccumulator acc, ArrayList<String> tags, String tag) {
        float sc1;
        int cap;
        float sc0;
        int count1;
        int count0 = acc.bucketCount(0);
        if (count0 > 0 && (count1 = acc.bucketCount(1)) > 0 && (double)(sc0 = count0 == (cap = acc.bucketCapacity()) ? acc.bucketScore(0) : acc.bucketScore(0) * (float)cap / (float)count0 - 0.03744f * (float)(cap - count0)) > (double)(sc1 = acc.bucketScore(1)) - 0.11231999471783638) {
            if (yDistance <= -1.05 && (double)sc1 < -8.0 && (double)sc0 < -8.0) {
                tags.add(tag + "grace");
                return 0.0;
            }
            tags.add(tag);
            return (double)sc0 - ((double)sc1 - 0.11231999471783638);
        }
        return 0.0;
    }

    private double yDirChange(PlayerLocation from, PlayerLocation to, double yDistance, double vDistanceAboveLimit, PlayerMoveData lastMove, MovingData data) {
        if (yDistance > 0.0) {
            if (lastMove.touchedGround || lastMove.to.extraPropertiesValid && lastMove.to.resetCond) {
                this.tags.add("ychinc");
            } else if (data.bunnyhopDelay < 9 && (!lastMove.touchedGround && !lastMove.from.onGroundOrResetCond || lastMove.yDistance != 0.0) && data.getOrUseVerticalVelocity(yDistance) == null) {
                vDistanceAboveLimit = Math.max(vDistanceAboveLimit, Math.abs(yDistance));
                this.tags.add("ychincfly");
            } else {
                this.tags.add("ychincair");
            }
        } else {
            double setBackYDistance;
            this.tags.add("ychdec");
            if (!data.sfLowJump && !data.sfNoLowJump && data.liftOffEnvelope == LiftOffEnvelope.NORMAL && lastMove.toIsValid && lastMove.yDistance > 0.0 && !data.isVelocityJumpPhase() && (setBackYDistance = from.getY() - data.getSetBackY()) > 0.0) {
                Player player = from.getPlayer();
                double estimate = 1.15;
                if (data.jumpAmplifier > 0.0) {
                    estimate += 0.5 * this.aux.getJumpAmplifier(player);
                }
                if (setBackYDistance < estimate) {
                    if (data.playerMoves.getCurrentMove().headObstructed || yDistance <= 0.0 && lastMove.headObstructed && lastMove.yDistance >= 0.0) {
                        this.tags.add("nolowjump_ceil");
                    } else {
                        this.tags.add("lowjump_set");
                        data.sfLowJump = true;
                    }
                }
            }
        }
        return vDistanceAboveLimit;
    }

    private double[] hDistAfterFailure(Player player, PlayerLocation from, PlayerLocation to, double hAllowedDistance, double hDistanceAboveLimit, boolean sprinting, PlayerMoveData thisMove, PlayerMoveData lastMove, MovingData data, MovingConfig cc, boolean skipPermChecks) {
        if ((hDistanceAboveLimit = this.bunnyHop(from, to, hAllowedDistance, hDistanceAboveLimit, sprinting, thisMove, lastMove, data, cc)) > 0.0 && !skipPermChecks) {
            hAllowedDistance = this.setAllowedhDist(player, sprinting, thisMove, data, cc, true);
            hDistanceAboveLimit = thisMove.hDistance - hAllowedDistance;
            this.tags.add("permchecks");
        }
        if (cc.trackBlockMove && hDistanceAboveLimit > 0.0 && hDistanceAboveLimit < 1.025) {
            double xDistance = to.getX() - from.getX();
            double zDistance = to.getZ() - from.getZ();
            if (Math.abs(xDistance) > 0.485 && Math.abs(xDistance) < 1.025 && from.matchBlockChange(this.blockChangeTracker, data.blockChangeRef, xDistance < 0.0 ? BlockChangeTracker.Direction.X_NEG : BlockChangeTracker.Direction.X_POS, 0.05)) {
                hAllowedDistance = thisMove.hDistance;
                hDistanceAboveLimit = 0.0;
            } else if (Math.abs(zDistance) > 0.485 && Math.abs(zDistance) < 1.025 && from.matchBlockChange(this.blockChangeTracker, data.blockChangeRef, zDistance < 0.0 ? BlockChangeTracker.Direction.Z_NEG : BlockChangeTracker.Direction.Z_POS, 0.05)) {
                hAllowedDistance = thisMove.hDistance;
                hDistanceAboveLimit = 0.0;
            }
        }
        double hFreedom = 0.0;
        if (hDistanceAboveLimit > 0.0) {
            hFreedom = data.getHorizontalFreedom();
            if (hFreedom < hDistanceAboveLimit) {
                hFreedom += data.useHorizontalVelocity(hDistanceAboveLimit - hFreedom);
            }
            if (hFreedom > 0.0) {
                this.tags.add("hvel");
                hDistanceAboveLimit = Math.max(0.0, hDistanceAboveLimit - hFreedom);
            }
        }
        if (hDistanceAboveLimit > 0.0) {
            hDistanceAboveLimit = this.bunnyHop(from, to, hAllowedDistance, hDistanceAboveLimit, sprinting, thisMove, lastMove, data, cc);
        }
        if (hDistanceAboveLimit > 0.0 && data.sfHorizontalBuffer > 0.0) {
            this.tags.add("hbufuse");
            double amount = Math.min(data.sfHorizontalBuffer, hDistanceAboveLimit);
            hDistanceAboveLimit -= amount;
            data.sfHorizontalBuffer = Math.max(0.0, data.sfHorizontalBuffer - amount);
        }
        if (hDistanceAboveLimit > 0.0) {
            this.tags.add("hspeed");
        }
        return new double[]{hAllowedDistance, hDistanceAboveLimit, hFreedom};
    }

    private double bunnyHop(PlayerLocation from, PlayerLocation to, double hAllowedDistance, double hDistanceAboveLimit, boolean sprinting, PlayerMoveData thisMove, PlayerMoveData lastMove, MovingData data, MovingConfig cc) {
        boolean allowHop = true;
        boolean double_bunny = false;
        double hDistance = thisMove.hDistance;
        double yDistance = thisMove.yDistance;
        double hDistanceBaseRef = thisMove.hAllowedDistanceBase;
        if (lastMove.toIsValid && data.bunnyhopDelay > 0 && hDistance > hDistanceBaseRef) {
            allowHop = false;
            int hopTime = 10 - data.bunnyhopDelay;
            if (lastMove.hDistance > hDistance) {
                double hDistDiff = lastMove.hDistance - hDistance;
                if (data.bunnyhopDelay == 9) {
                    if (hDistDiff >= 0.66 * (lastMove.hDistance - hDistanceBaseRef)) {
                        this.tags.add("bunnyslope");
                        hDistanceAboveLimit = 0.0;
                    }
                } else if (hDistDiff >= lastMove.hDistance / 160.0 || hDistDiff >= hDistanceAboveLimit / 33.3 || hDistDiff >= (hDistance - hDistanceBaseRef) * 0.020000000000000018) {
                    this.tags.add("bunnyfriction");
                    hDistanceAboveLimit = 0.0;
                    if (data.bunnyhopDelay == 1 && !thisMove.to.onGround && !to.isResetCond()) {
                        ++data.bunnyhopDelay;
                        this.tags.add("bunnyfly(keep)");
                    } else {
                        this.tags.add("bunnyfly(" + data.bunnyhopDelay + ")");
                    }
                }
            }
            if (!allowHop && hDistance - lastMove.hDistance >= hDistanceBaseRef * 0.5 && hopTime == 1 && lastMove.yDistance >= -0.0417 && lastMove.yDistance <= 0.0 && yDistance >= 0.4 && lastMove.touchedGround) {
                this.tags.add(DOUBLE_BUNNY);
                double_bunny = true;
                allowHop = true;
            }
            if (!allowHop && (thisMove.from.onGround || thisMove.touchedGroundWorkaround)) {
                if (data.bunnyhopDelay <= 6) {
                    this.tags.add("ediblebunny");
                    allowHop = true;
                } else if (lastMove.yDistance < 0.0 && thisMove.to.onGround && thisMove.yDistance == 0.0 && Magic.fallAfterHeadObstructed(data, 2) && lastMove.hDistance > lastMove.hAllowedDistanceBase && lastMove.hDistance < 1.34 * lastMove.hAllowedDistanceBase && thisMove.hDistance > lastMove.hDistance * 1.24 && thisMove.hDistance < lastMove.hDistance * 1.34 || yDistance >= 0.0 && thisMove.headObstructed) {
                    this.tags.add("headbangbunny");
                    allowHop = true;
                    if (data.combinedMediumHValue / (double)data.combinedMediumHCount < 1.5) {
                        data.combinedMediumHCount = 0;
                        data.combinedMediumHValue = 0.0;
                        this.tags.add("bunny_no_hacc");
                    }
                }
            }
        }
        if (allowHop && hDistance >= hDistanceBaseRef && hDistance > (!lastMove.toIsValid || lastMove.hDistance == 0.0 && lastMove.yDistance == 0.0 ? 1.11 : 1.314) * hDistanceBaseRef && hDistance < 2.15 * hDistanceBaseRef || (yDistance > from.getyOnGround() || hDistance < 2.6 * hDistanceBaseRef) && lastMove.toIsValid && hDistance > 1.314 * lastMove.hDistance && hDistance < 2.15 * lastMove.hDistance) {
            if (data.liftOffEnvelope == LiftOffEnvelope.NORMAL && (!data.sfLowJump || data.sfNoLowJump) && yDistance >= 0.0 && (yDistance > 0.0 && yDistance > data.liftOffEnvelope.getMinJumpGain(data.jumpAmplifier) - 0.021000000000000005 || thisMove.headObstructed || lastMove.toIsValid && lastMove.headObstructed && lastMove.yDistance <= 0.0 || (cc.sfGroundHop || yDistance == 0.0 && !lastMove.touchedGroundWorkaround && !lastMove.from.onGround) && hDistanceBaseRef > 0.0 && hDistance / hDistanceBaseRef < 1.5 && (hDistance / lastMove.hDistance < 1.35 || hDistance / hDistanceBaseRef < 1.35)) && (data.sfJumpPhase == 0 && thisMove.from.onGround || data.sfJumpPhase <= 1 && (thisMove.touchedGroundWorkaround || lastMove.touchedGround && !lastMove.bunnyHop) || double_bunny) && !from.isResetCond() && !to.isResetCond()) {
                data.bunnyhopDelay = 10;
                hDistanceAboveLimit = 0.0;
                thisMove.bunnyHop = true;
                this.tags.add("bunnyhop");
            } else {
                this.tags.add("bunnyenv");
            }
        }
        return hDistanceAboveLimit;
    }

    private void hBufRegain(double hDistance, double amount, MovingData data, MovingConfig cc) {
        data.sfHorizontalBuffer = Math.min(cc.hBufMax, data.sfHorizontalBuffer + amount);
    }

    private double[] vDistLiquid(PlayerLocation from, PlayerLocation to, boolean toOnGround, double yDistance, PlayerMoveData lastMove, MovingData data) {
        Double wRes;
        double frictDist;
        data.sfNoLowJump = true;
        double baseSpeed = Magic.swimBaseSpeedV();
        double yDistAbs = Math.abs(yDistance);
        if (yDistAbs <= baseSpeed) {
            return new double[]{baseSpeed, 0.0};
        }
        double d = frictDist = lastMove.toIsValid ? Math.abs(lastMove.yDistance) * data.lastFrictionVertical : baseSpeed;
        if (lastMove.toIsValid) {
            if (lastMove.yDistance < 0.0 && yDistance < 0.0 && yDistAbs < frictDist + 0.0834 + 0.021000000000000005) {
                return new double[]{-frictDist - 0.0834 - 0.021000000000000005, 0.0};
            }
            if (lastMove.yDistance > 0.0 && yDistance > 0.0 && yDistance < frictDist - 0.0624) {
                return new double[]{frictDist - 0.0624, 0.0};
            }
        }
        if ((wRes = MagicLiquid.liquidWorkarounds(from, to, baseSpeed, frictDist, lastMove, data)) != null) {
            return new double[]{wRes, 0.0};
        }
        if (data.getOrUseVerticalVelocity(yDistance) != null) {
            return new double[]{yDistance, 0.0};
        }
        this.tags.add(yDistance < 0.0 ? "swimdown" : "swimup");
        double vl1 = yDistAbs - baseSpeed;
        double vl2 = Math.abs(yDistAbs - frictDist - (yDistance < 0.0 ? 0.1044 : 0.0624));
        if (vl1 <= vl2) {
            return new double[]{yDistance < 0.0 ? -baseSpeed : baseSpeed, vl1};
        }
        return new double[]{yDistance < 0.0 ? -frictDist - 0.0834 - 0.021000000000000005 : frictDist - 0.0624, vl2};
    }

    private double vDistClimbable(Player player, PlayerLocation from, PlayerLocation to, boolean fromOnGround, boolean toOnGround, PlayerMoveData thisMove, PlayerMoveData lastMove, double yDistance, MovingData data) {
        double maxSpeed;
        double vDistanceAboveLimit = 0.0;
        data.sfNoLowJump = true;
        data.clearActiveHorVel();
        double jumpHeight = 1.35 + (data.jumpAmplifier > 0.0 ? 0.6 + data.jumpAmplifier - 1.0 : 0.0);
        double d = maxSpeed = yDistance < 0.0 ? 0.151 : 0.119;
        if (Math.abs(yDistance) > maxSpeed) {
            if (from.isOnGround(jumpHeight, 0.0, 0.0, 512L)) {
                if (yDistance > data.liftOffEnvelope.getMaxJumpGain(data.jumpAmplifier) + 0.1) {
                    this.tags.add("climbstep");
                    vDistanceAboveLimit = Math.max(vDistanceAboveLimit, Math.abs(yDistance) - maxSpeed);
                }
            } else {
                this.tags.add("climbspeed");
                vDistanceAboveLimit = Math.max(vDistanceAboveLimit, Math.abs(yDistance) - maxSpeed);
            }
        }
        if (yDistance > 0.0 && !data.playerMoves.getCurrentMove().touchedGround && !from.canClimbUp(jumpHeight)) {
            this.tags.add("climbdetached");
            vDistanceAboveLimit = Math.max(vDistanceAboveLimit, yDistance);
        }
        if (vDistanceAboveLimit > 0.0 && thisMove.yDistance > 0.0 && lastMove.yDistance - 0.07289999999999999 > thisMove.yDistance) {
            vDistanceAboveLimit = 0.0;
            this.tags.add("vfrict_climb");
        }
        if (vDistanceAboveLimit > 0.0 && data.getOrUseVerticalVelocity(yDistance) != null) {
            vDistanceAboveLimit = 0.0;
        }
        return vDistanceAboveLimit;
    }

    private double[] vDistWeb(Player player, PlayerMoveData thisMove, boolean toOnGround, double hDistanceAboveLimit, long now, MovingData data, MovingConfig cc) {
        double yDistance = thisMove.yDistance;
        double vAllowedDistance = 0.0;
        double vDistanceAboveLimit = 0.0;
        data.sfNoLowJump = true;
        data.jumpAmplifier = 0.0;
        if (yDistance >= 0.0) {
            if (toOnGround && yDistance <= 0.5) {
                vAllowedDistance = yDistance;
                if (yDistance > 0.0) {
                    this.tags.add("web_step");
                }
            } else {
                vAllowedDistance = thisMove.from.onGround ? 0.1 : 0.0;
            }
            vDistanceAboveLimit = yDistance - vAllowedDistance;
        }
        if (cc.survivalFlyCobwebHack && vDistanceAboveLimit > 0.0 && hDistanceAboveLimit <= 0.0 && this.hackCobweb(player, data, thisMove, now, vDistanceAboveLimit)) {
            return new double[]{Double.MIN_VALUE, Double.MIN_VALUE};
        }
        if (vDistanceAboveLimit > 0.0) {
            this.tags.add("vweb");
        }
        return new double[]{vAllowedDistance, vDistanceAboveLimit};
    }

    private Location handleViolation(long now, double result, Player player, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc) {
        data.survivalFlyVL += result;
        data.sfVLTime = now;
        ViolationData vd = new ViolationData(this, player, data.survivalFlyVL, result, cc.survivalFlyActions);
        if (vd.needsParameters()) {
            vd.setParameter(ParameterName.LOCATION_FROM, String.format(Locale.US, "%.2f, %.2f, %.2f", from.getX(), from.getY(), from.getZ()));
            vd.setParameter(ParameterName.LOCATION_TO, String.format(Locale.US, "%.2f, %.2f, %.2f", to.getX(), to.getY(), to.getZ()));
            vd.setParameter(ParameterName.DISTANCE, String.format(Locale.US, "%.2f", TrigUtil.distance((IGetPosition)from, to)));
            vd.setParameter(ParameterName.TAGS, StringUtil.join(this.tags, "+"));
        }
        if (this.executeActions(vd).willCancel()) {
            return data.getSetBack(to);
        }
        data.clearAccounting();
        data.sfJumpPhase = 0;
        return null;
    }

    public final void handleHoverViolation(Player player, Location loc, MovingConfig cc, MovingData data) {
        data.survivalFlyVL += cc.sfHoverViolation;
        data.sfVLTime = System.currentTimeMillis();
        ViolationData vd = new ViolationData(this, player, data.survivalFlyVL, cc.sfHoverViolation, cc.survivalFlyActions);
        if (vd.needsParameters()) {
            vd.setParameter(ParameterName.LOCATION_FROM, String.format(Locale.US, "%.2f, %.2f, %.2f", loc.getX(), loc.getY(), loc.getZ()));
            vd.setParameter(ParameterName.LOCATION_TO, "(HOVER)");
            vd.setParameter(ParameterName.DISTANCE, "0.0(HOVER)");
            vd.setParameter(ParameterName.TAGS, "hover");
        }
        if (this.executeActions(vd).willCancel()) {
            if (data.hasSetBack()) {
                Location newTo = data.getSetBack(loc);
                data.prepareSetBack(newTo);
                player.teleport(newTo, BridgeMisc.TELEPORT_CAUSE_CORRECTION_OF_POSITION);
            } else {
                player.kickPlayer("Hovering?");
            }
        }
    }

    private boolean hackCobweb(Player player, MovingData data, PlayerMoveData thisMove, long now, double vDistanceAboveLimit) {
        if (now - data.sfCobwebTime > 3000L) {
            data.sfCobwebTime = now;
            data.sfCobwebVL = vDistanceAboveLimit * 100.0;
        } else {
            data.sfCobwebVL += vDistanceAboveLimit * 100.0;
        }
        if (data.sfCobwebVL < 550.0) {
            if (!data.hasSetBack()) {
                data.setSetBack(player.getLocation(this.useLoc));
                this.useLoc.setWorld(null);
            }
            data.sfJumpPhase = 0;
            return true;
        }
        return false;
    }

    public void setReallySneaking(Player player, boolean sneaking) {
        if (sneaking) {
            this.reallySneaking.add(player.getName());
        } else {
            this.reallySneaking.remove(player.getName());
        }
    }

    private void outputDebug(Player player, PlayerLocation to, MovingData data, MovingConfig cc, double hDistance, double hAllowedDistance, double hFreedom, double yDistance, double vAllowedDistance, boolean fromOnGround, boolean resetFrom, boolean toOnGround, boolean resetTo, PlayerMoveData thisMove) {
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        StringBuilder builder = new StringBuilder(500);
        builder.append(CheckUtils.getLogMessagePrefix(player, this.type));
        String hBuf = data.sfHorizontalBuffer < 1.0 ? " hbuf=" + StringUtil.fdec3.format(data.sfHorizontalBuffer) : "";
        String lostSprint = data.lostSprintCount > 0 ? " lostSprint=" + data.lostSprintCount : "";
        String hVelUsed = hFreedom > 0.0 ? " hVelUsed=" + StringUtil.fdec3.format(hFreedom) : "";
        builder.append("\nonground: " + (thisMove.headObstructed ? "(head obstr.) " : "") + (thisMove.touchedGroundWorkaround ? "(touched ground) " : "") + (fromOnGround ? "onground -> " : (resetFrom ? "resetcond -> " : "--- -> ")) + (toOnGround ? "onground" : (resetTo ? "resetcond" : "---")) + ", jumpphase: " + data.sfJumpPhase + ", liftoff: " + data.liftOffEnvelope.name() + "(" + data.insideMediumCount + ")");
        String dHDist = lastMove.toIsValid ? " (" + StringUtil.formatDiff(hDistance, lastMove.hDistance) + ")" : "";
        String dYDist = lastMove.toIsValid ? " (" + StringUtil.formatDiff(yDistance, lastMove.yDistance) + ")" : "";
        builder.append("\n hDist: " + StringUtil.fdec3.format(hDistance) + dHDist + " / " + StringUtil.fdec3.format(hAllowedDistance) + hBuf + lostSprint + hVelUsed + " , vDist: " + StringUtil.fdec3.format(yDistance) + dYDist + " / " + StringUtil.fdec3.format(vAllowedDistance) + " , sby=" + (data.hasSetBack() ? data.getSetBackY() + " (" + StringUtil.fdec3.format(to.getY() - data.getSetBackY()) + " / " + data.liftOffEnvelope.getMaxJumpHeight(data.jumpAmplifier) + ")" : "?"));
        if (lastMove.toIsValid) {
            builder.append(" , fdsq: " + StringUtil.fdec3.format(thisMove.distanceSquared / lastMove.distanceSquared));
        }
        if (thisMove.verVelUsed != null) {
            builder.append(" , vVelUsed: " + thisMove.verVelUsed + " ");
        }
        data.addVerticalVelocity(builder);
        data.addHorizontalVelocity(builder);
        if (!resetFrom && !resetTo && cc.survivalFlyAccountingV && data.vDistAcc.count() > data.vDistAcc.bucketCapacity()) {
            builder.append("\n vacc: " + data.vDistAcc.toInformalString());
        }
        if (data.combinedMediumHCount > 0) {
            builder.append("\n hacc: " + StringUtil.fdec3.format(data.combinedMediumHValue / (double)data.combinedMediumHCount) + "(" + data.combinedMediumHCount + ")");
        }
        if (player.isSleeping()) {
            this.tags.add("sleeping");
        }
        if (player.getFoodLevel() <= 5 && player.isSprinting()) {
            this.tags.add("lowfoodsprint");
        }
        if (Bridge1_9.isWearingElytra(player)) {
            this.tags.add("elytra_off");
        }
        if (!this.tags.isEmpty()) {
            builder.append("\n tags: " + StringUtil.join(this.tags, "+"));
        }
        if (!this.justUsedWorkarounds.isEmpty()) {
            builder.append("\n workarounds: " + StringUtil.join(this.justUsedWorkarounds, "+"));
        }
        builder.append("\n");
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, builder.toString());
    }

    private void logPostViolationTags(Player player) {
        this.debug(player, "SurvivalFly Post violation handling tag update:\n" + StringUtil.join(this.tags, "+"));
    }
}

