/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.player;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.components.location.IGetPosition;
import fr.neatmonster.nocheatplus.utilities.collision.ICollidePassable;
import fr.neatmonster.nocheatplus.utilities.collision.PassableAxisTracing;
import fr.neatmonster.nocheatplus.utilities.collision.PassableRayTracing;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.location.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class Passable
extends Check {
    private static boolean rt_legacy = false;
    private static double rt_xzFactor = 0.98;
    private static double rt_heightFactor = 0.99999999;
    private final ICollidePassable rayTracingLegacy = new PassableRayTracing();
    private final ICollidePassable rayTracingActual = new PassableAxisTracing();
    private final BlockChangeTracker blockTracker;

    public static boolean isPassable(Location from, Location to) {
        return rt_legacy ? BlockProperties.isPassable(from, to) : BlockProperties.isPassableAxisWise(from, to);
    }

    public Passable() {
        super(CheckType.MOVING_PASSABLE);
        this.rayTracingLegacy.setMaxSteps(60);
        this.rayTracingActual.setMaxSteps(60);
        this.blockTracker = NCPAPIProvider.getNoCheatPlusAPI().getBlockChangeTracker();
    }

    public Location check(Player player, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc, int tick, boolean useBlockChangeTracker) {
        if (rt_legacy) {
            return this.checkLegacy(player, from, to, data, cc);
        }
        return this.checkActual(player, from, to, data, cc, tick, useBlockChangeTracker);
    }

    private Location checkActual(Player player, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc, int tick, boolean useBlockChangeTracker) {
        int manhattan = from.manhattan(to);
        if (cc.passableRayTracingCheck && (!cc.passableRayTracingBlockChangeOnly || manhattan > 0)) {
            String newTag = this.checkRayTracing(player, from, to, manhattan, data, cc, tick, useBlockChangeTracker);
            if (newTag != null) {
                return this.potentialViolation(player, from, to, manhattan, newTag, data, cc);
            }
        } else if (!to.isPassable()) {
            return this.potentialViolationLegacy(player, from, to, manhattan, "", data, cc);
        }
        data.passableVL *= 0.99;
        return null;
    }

    private String checkRayTracing(Player player, PlayerLocation from, PlayerLocation to, int manhattan, MovingData data, MovingConfig cc, int tick, boolean useBlockChangeTracker) {
        String tags = null;
        this.setNormalMargins(this.rayTracingActual, from);
        this.rayTracingActual.set(from, to);
        this.rayTracingActual.setIgnoreInitiallyColliding(true);
        if (useBlockChangeTracker) {
            this.rayTracingActual.setBlockChangeTracker(this.blockTracker, data.blockChangeRef, tick, from.getWorld().getUID());
        }
        this.rayTracingActual.loop();
        this.rayTracingActual.setIgnoreInitiallyColliding(false);
        if (this.rayTracingActual.collides()) {
            tags = "raytracing_collide_";
        } else if (this.rayTracingActual.getStepsDone() >= this.rayTracingActual.getMaxSteps()) {
            tags = "raytracing_maxsteps_";
        }
        if (data.debug) {
            this.debugExtraCollisionDetails(player, this.rayTracingActual, "std");
        }
        this.rayTracingActual.cleanup();
        return tags;
    }

    private void setNormalMargins(ICollidePassable rayTracing, PlayerLocation from) {
        rayTracing.setMargins(from.getBoxMarginVertical() * rt_heightFactor, from.getWidth() / 2.0 * rt_xzFactor);
    }

    private Location potentialViolation(Player player, PlayerLocation from, PlayerLocation to, int manhattan, String tags, MovingData data, MovingConfig cc) {
        return this.actualViolation(player, from, to, tags, data, cc);
    }

    private Location actualViolation(Player player, PlayerLocation from, PlayerLocation to, String tags, MovingData data, MovingConfig cc) {
        Location setBackLoc = null;
        if (data.hasSetBack()) {
            setBackLoc = data.getSetBack(to);
            if (data.debug) {
                this.debug(player, "Using set back location for passable.");
            }
        }
        data.passableVL += 1.0;
        ViolationData vd = new ViolationData(this, player, data.passableVL, 1.0, cc.passableActions);
        if (data.debug || vd.needsParameters()) {
            vd.setParameter(ParameterName.LOCATION_FROM, String.format(Locale.US, "%.2f, %.2f, %.2f", from.getX(), from.getY(), from.getZ()));
            vd.setParameter(ParameterName.LOCATION_TO, String.format(Locale.US, "%.2f, %.2f, %.2f", to.getX(), to.getY(), to.getZ()));
            vd.setParameter(ParameterName.DISTANCE, String.format(Locale.US, "%.2f", TrigUtil.distance((IGetPosition)from, to)));
            vd.setParameter(ParameterName.BLOCK_ID, "" + to.getTypeId());
            if (!tags.isEmpty()) {
                vd.setParameter(ParameterName.TAGS, tags);
            }
        }
        if (this.executeActions(vd).willCancel()) {
            Location newTo;
            if (setBackLoc != null) {
                newTo = LocUtil.clone(setBackLoc);
            } else {
                newTo = from.getLocation();
                if (data.debug) {
                    this.debug(player, "Using from location for passable.");
                }
            }
            newTo.setYaw(to.getYaw());
            newTo.setPitch(to.getPitch());
            return newTo;
        }
        return null;
    }

    private void debugExtraCollisionDetails(Player player, ICollidePassable rayTracing, String tag) {
        if (rayTracing.collides()) {
            this.debug(player, "Raytracing collision (" + tag + "): " + (Object)((Object)rayTracing.getCollidingAxis()));
        } else if (rayTracing.getStepsDone() >= rayTracing.getMaxSteps()) {
            this.debug(player, "Raytracing max steps exceeded (" + tag + "): " + (Object)((Object)rayTracing.getCollidingAxis()));
        }
    }

    private Location checkLegacy(Player player, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc) {
        String newTag;
        boolean toPassable;
        String tags = "";
        int manhattan = from.manhattan(to);
        if (manhattan <= 1 && BlockProperties.isPassable(from.getTypeId())) {
            if (manhattan == 0) {
                return null;
            }
            if (BlockProperties.isPassable(to.getTypeId())) {
                return null;
            }
        }
        if ((toPassable = to.isPassable()) && cc.passableRayTracingCheck && (!cc.passableRayTracingBlockChangeOnly || manhattan > 0) && (newTag = this.checkRayTracingLegacy(player, from, to, manhattan, data, cc)) != null) {
            toPassable = false;
            tags = newTag;
        }
        if (toPassable) {
            data.passableVL *= 0.99;
            return null;
        }
        return this.potentialViolationLegacy(player, from, to, manhattan, tags, data, cc);
    }

    private String checkRayTracingLegacy(Player player, PlayerLocation from, PlayerLocation to, int manhattan, MovingData data, MovingConfig cc) {
        this.setNormalMargins(this.rayTracingLegacy, from);
        this.rayTracingLegacy.set(from, to);
        this.rayTracingLegacy.loop();
        String tags = null;
        if (this.rayTracingLegacy.collides() || this.rayTracingLegacy.getStepsDone() >= this.rayTracingLegacy.getMaxSteps()) {
            int maxBlockDist;
            if (data.debug) {
                this.debugExtraCollisionDetails(player, this.rayTracingLegacy, "legacy");
            }
            int n = maxBlockDist = manhattan <= 1 ? manhattan : from.maxBlockDist(to);
            if (maxBlockDist <= 1 && this.rayTracingLegacy.getStepsDone() == 1 && !from.isPassable()) {
                if (this.collidesIgnoreFirst(from, to)) {
                    tags = "raytracing_2x_";
                    if (data.debug) {
                        this.debugExtraCollisionDetails(player, this.rayTracingLegacy, "ingoreFirst");
                    }
                } else if (data.debug) {
                    this.debug(player, "Allow moving out of a block.");
                }
            } else if (!this.allowsSplitMove(from, to, manhattan, data)) {
                tags = "raytracing_";
            }
        }
        this.rayTracingLegacy.cleanup();
        return tags;
    }

    private Location potentialViolationLegacy(Player player, PlayerLocation from, PlayerLocation to, int manhattan, String tags, MovingData data, MovingConfig cc) {
        if (from.isPassable()) {
            if (from.isBlockAbove(to) && (BlockProperties.getBlockFlags(to.getTypeId()) & 0x40L) != 0L && BlockProperties.collidesBlock(to.getBlockCache(), from.getX(), from.getY(), from.getZ(), from.getX(), from.getY(), from.getZ(), to.getBlockX(), to.getBlockY(), to.getBlockZ(), to.getOrCreateBlockCacheNode(), null, BlockProperties.getBlockFlags(to.getTypeId()))) {
                return null;
            }
            tags = tags + "into";
        } else {
            if (manhattan == 1 && to.isBlockAbove(from) && BlockProperties.isPassable(from.getBlockCache(), from.getX(), from.getY() + from.getBoxMarginVertical(), from.getZ(), from.getBlockCache().getOrCreateBlockCacheNode(from.getBlockX(), Location.locToBlock((double)(from.getY() + from.getBoxMarginVertical())), from.getBlockZ(), false), null)) {
                return null;
            }
            if (manhattan > 0) {
                tags = tags + "cross";
            } else {
                return null;
            }
        }
        return this.actualViolation(player, from, to, tags, data, cc);
    }

    private boolean collidesIgnoreFirst(PlayerLocation from, PlayerLocation to) {
        this.rayTracingLegacy.set(from, to);
        this.rayTracingLegacy.setIgnoreInitiallyColliding(true);
        this.rayTracingLegacy.setCutOppositeDirectionMargin(true);
        this.rayTracingLegacy.loop();
        this.rayTracingLegacy.setIgnoreInitiallyColliding(false);
        this.rayTracingLegacy.setCutOppositeDirectionMargin(false);
        return this.rayTracingLegacy.collides() || this.rayTracingLegacy.getStepsDone() >= this.rayTracingLegacy.getMaxSteps();
    }

    private boolean allowsSplitMove(PlayerLocation from, PlayerLocation to, int manhattan, MovingData data) {
        if (!this.rayTracingLegacy.mightNeedSplitAxisHandling()) {
            return false;
        }
        this.rayTracingLegacy.set(from.getX(), from.getY(), from.getZ(), from.getX(), to.getY(), from.getZ());
        this.rayTracingLegacy.loop();
        if (!this.rayTracingLegacy.collides() && this.rayTracingLegacy.getStepsDone() < this.rayTracingLegacy.getMaxSteps()) {
            this.rayTracingLegacy.set(from.getX(), to.getY(), from.getZ(), to.getX(), to.getY(), to.getZ());
            this.rayTracingLegacy.loop();
            if (!this.rayTracingLegacy.collides() && this.rayTracingLegacy.getStepsDone() < this.rayTracingLegacy.getMaxSteps()) {
                return true;
            }
        }
        if (data.debug) {
            this.debug(from.getPlayer(), "Raytracing collision (split move): (no details)");
        }
        return false;
    }
}

