/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.player;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.magic.LostGround;
import fr.neatmonster.nocheatplus.checks.moving.model.LiftOffEnvelope;
import fr.neatmonster.nocheatplus.checks.moving.model.ModelFlying;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.checks.moving.util.MovingUtil;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.components.location.IGetPosition;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.location.TrigUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreativeFly
extends Check {
    private final List<String> tags = new LinkedList<String>();
    private final BlockChangeTracker blockChangeTracker = NCPAPIProvider.getNoCheatPlusAPI().getBlockChangeTracker();

    public CreativeFly() {
        super(CheckType.MOVING_CREATIVEFLY);
    }

    public Location check(Player player, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc, long time, int tick, boolean useBlockChangeTracker) {
        double[] res;
        boolean sprinting;
        this.tags.clear();
        GameMode gameMode = player.getGameMode();
        ModelFlying model = cc.getModelFlying(player, from);
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        thisMove.modelFlying = model;
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        if (data.fireworksBoostDuration > 0) {
            data.fireworksBoostDuration = !lastMove.valid || lastMove.flyCheck != CheckType.MOVING_CREATIVEFLY || lastMove.modelFlying != model || data.fireworksBoostTickExpire < tick ? 0 : --data.fireworksBoostDuration;
        }
        double yDistance = thisMove.yDistance;
        double hDistance = thisMove.hDistance;
        boolean flying = gameMode == BridgeMisc.GAME_MODE_SPECTATOR || player.isFlying();
        boolean bl = sprinting = time <= data.timeSprinting + cc.sprintingGrace;
        if (model.ground) {
            MovingUtil.prepareFullCheck(from, to, thisMove, Math.max(cc.yOnGround, cc.noFallyOnGround));
            if (thisMove.from.onGroundOrResetCond || (from.isSamePos(to) ? lastMove.toIsValid && lastMove.hDistance > 0.0 && lastMove.yDistance < -0.3 && LostGround.lostGroundStill(player, from, to, hDistance, yDistance, sprinting, lastMove, data, cc, this.tags) : LostGround.lostGround(player, from, to, hDistance, yDistance, sprinting, lastMove, data, cc, useBlockChangeTracker ? this.blockChangeTracker : null, this.tags))) {
                // empty if block
            }
        }
        double[] resH = this.hDist(player, from, to, hDistance, yDistance, sprinting, flying, lastMove, time, model, data, cc);
        double limitH = resH[0];
        double resultH = resH[1];
        if (resultH > 0.0) {
            double hFreedom = data.getHorizontalFreedom();
            if (hFreedom < resultH) {
                hFreedom += data.useHorizontalVelocity(resultH - hFreedom);
            }
            if (hFreedom > 0.0) {
                if ((resultH = Math.max(0.0, resultH - hFreedom)) <= 0.0) {
                    limitH = hDistance;
                }
                this.tags.add("hvel");
            }
        } else {
            data.clearActiveHorVel();
        }
        resultH *= 100.0;
        if (resultH > 0.0) {
            this.tags.add("hdist");
        }
        double limitV = 0.0;
        double resultV = 0.0;
        if (yDistance > 0.0) {
            res = this.vDistAscend(from, to, yDistance, flying, thisMove, lastMove, model, data, cc);
            resultV = Math.max(resultV, res[1]);
            limitV = res[0];
        } else if (yDistance < 0.0) {
            res = this.vDistDescend(from, to, yDistance, flying, lastMove, model, data, cc);
            resultV = Math.max(resultV, res[1]);
            limitV = res[0];
        } else {
            res = this.vDistZero(from, to, yDistance, flying, lastMove, model, data, cc);
            resultV = Math.max(resultV, res[1]);
            limitV = res[0];
        }
        if (resultV > 0.0 && data.getOrUseVerticalVelocity(yDistance) != null) {
            resultV = 0.0;
            this.tags.add("vvel");
        }
        double maximumHeight = model.maxHeight + (double)player.getWorld().getMaxHeight();
        if (to.getY() > maximumHeight) {
            this.tags.add("maxheight");
        }
        if ((resultV *= 100.0) > 0.0) {
            this.tags.add("vdist");
        }
        double result = Math.max(0.0, resultH) + Math.max(0.0, resultV);
        if (data.debug) {
            this.outpuDebugMove(player, hDistance, limitH, yDistance, limitV, model, this.tags, data);
        }
        Location setBack = null;
        if (result > 0.0) {
            data.creativeFlyVL += result;
            ViolationData vd = new ViolationData(this, player, data.creativeFlyVL, result, cc.creativeFlyActions);
            if (vd.needsParameters()) {
                vd.setParameter(ParameterName.LOCATION_FROM, String.format(Locale.US, "%.2f, %.2f, %.2f", from.getX(), from.getY(), from.getZ()));
                vd.setParameter(ParameterName.LOCATION_TO, String.format(Locale.US, "%.2f, %.2f, %.2f", to.getX(), to.getY(), to.getZ()));
                vd.setParameter(ParameterName.DISTANCE, String.format(Locale.US, "%.2f", TrigUtil.distance((IGetPosition)from, to)));
                if (!this.tags.isEmpty()) {
                    vd.setParameter(ParameterName.TAGS, StringUtil.join(this.tags, "+"));
                }
            }
            if (this.executeActions(vd).willCancel()) {
                setBack = data.getSetBack(to);
            }
        } else {
            if (to.getY() > maximumHeight) {
                setBack = data.getSetBack(to);
            }
            if (setBack == null) {
                data.creativeFlyVL *= 0.97;
            }
        }
        if (setBack != null) {
            if (setBack.getY() > maximumHeight) {
                setBack.setY(this.getCorrectedHeight(maximumHeight, setBack.getWorld()));
                if (data.debug) {
                    this.debug(player, "Maximum height exceeded by set back, correct to: " + setBack.getY());
                }
            }
            data.sfJumpPhase = 0;
            return setBack;
        }
        data.setSetBack(to);
        data.sfJumpPhase = !thisMove.from.onGroundOrResetCond && !thisMove.to.onGroundOrResetCond ? ++data.sfJumpPhase : (thisMove.touchedGround && !thisMove.to.onGroundOrResetCond ? 1 : 0);
        return null;
    }

    private double[] hDist(Player player, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, boolean sprinting, boolean flying, PlayerMoveData lastMove, long time, ModelFlying model, MovingData data, MovingConfig cc) {
        double fSpeed;
        if (model.applyModifiers) {
            double speedModifier = ((MCAccess)this.mcAccess.getHandle()).getFasterMovementAmplifier(player);
            fSpeed = Double.isInfinite(speedModifier) ? 1.0 : 1.0 + 0.2 * (speedModifier + 1.0);
            if (flying) {
                fSpeed *= (double)data.flySpeed / 0.1;
                if (sprinting) {
                    fSpeed *= model.hModSprint;
                    this.tags.add("sprint");
                }
                this.tags.add("flying");
            } else {
                fSpeed *= (double)data.walkSpeed / 0.2;
            }
        } else {
            fSpeed = 1.0;
        }
        double limitH = model.hModSpeed / 100.0 * 0.6 * fSpeed;
        if (lastMove.toIsValid) {
            double frictionDist = lastMove.hDistance * 0.98;
            limitH = Math.max(frictionDist, limitH);
            this.tags.add("hfrict");
        }
        double resultH = Math.max(0.0, hDistance - limitH);
        if (model.applyModifiers) {
            --data.bunnyhopDelay;
            if (!flying && resultH > 0.0 && sprinting && data.bunnyhopDelay <= 0 && resultH < 0.4) {
                data.bunnyhopDelay = 9;
                resultH = 0.0;
                this.tags.add("bunnyhop");
            }
        }
        return new double[]{limitH, resultH};
    }

    private double[] vDistAscend(PlayerLocation from, PlayerLocation to, double yDistance, boolean flying, PlayerMoveData thisMove, PlayerMoveData lastMove, ModelFlying model, MovingData data, MovingConfig cc) {
        double maxGain;
        double levitation;
        double limitV = model.vModAscendSpeed / 100.0 * 1.0;
        double resultV = 0.0;
        if (model.applyModifiers && flying && yDistance > 0.0) {
            limitV *= (double)data.flySpeed / 0.1;
        } else if (model.isScaleLevitationEffect() && Bridge1_9.hasLevitation() && (levitation = Bridge1_9.getLevitationAmplifier(from.getPlayer())) > 0.0) {
            limitV += 0.046 * levitation;
            this.tags.add("levitation:" + levitation);
        }
        if (limitV == 0.0 && Bridge1_9.isGlidingWithElytra(from.getPlayer())) {
            limitV = this.hackLytra(yDistance, limitV, thisMove, lastMove, data);
        }
        if (model.gravity && yDistance > limitV && model.gravity && lastMove.toIsValid) {
            double frictionDist = lastMove.yDistance * 0.98;
            if (!flying) {
                frictionDist -= 0.0624;
            }
            if (frictionDist > limitV) {
                limitV = frictionDist;
                this.tags.add("vfrict_g");
            }
        }
        if (model.ground && yDistance > limitV && !thisMove.to.onGroundOrResetCond && !thisMove.from.onGroundOrResetCond && (lastMove.toIsValid && lastMove.touchedGround && (lastMove.yDistance <= 0.0 || lastMove.to.extraPropertiesValid && lastMove.to.onGround) || thisMove.touchedGroundWorkaround) && (maxGain = LiftOffEnvelope.NORMAL.getMaxJumpGain(data.jumpAmplifier)) > limitV) {
            limitV = maxGain;
            this.tags.add("jump_gain");
        }
        if (yDistance > limitV && yDistance <= cc.sfStepHeight && (lastMove.toIsValid && lastMove.yDistance < 0.0 || from.isOnGroundOrResetCond() || thisMove.touchedGroundWorkaround) && to.isOnGround()) {
            limitV = cc.sfStepHeight;
            this.tags.add("step_up");
        }
        resultV = Math.max(0.0, yDistance - limitV);
        return new double[]{limitV, resultV};
    }

    private double hackLytra(double yDistance, double limitV, PlayerMoveData thisMove, PlayerMoveData lastMove, MovingData data) {
        if (yDistance > -0.1044 && yDistance < 1.4178 && (yDistance - lastMove.yDistance < 0.1251 || lastMove.yDistance < -0.021000000000000005 && yDistance < 0.13340000000000002 && yDistance > 0.021000000000000005) && thisMove.hDistance < lastMove.hDistance && (lastMove.yDistance > 0.0 || lastMove.hDistance > 0.55) && (thisMove.distanceSquared / lastMove.distanceSquared < 0.99 || lastMove.yDistance < 0.0)) {
            if (lastMove.hDistance > 0.52) {
                this.tags.add("elytra_asc1");
                return yDistance;
            }
            if (thisMove.hDistance > 0.0624 && yDistance < lastMove.yDistance) {
                PlayerMoveData pastMove1 = data.playerMoves.getSecondPastMove();
                if (pastMove1.toIsValid && pastMove1.to.extraPropertiesValid && (pastMove1.yDistance < lastMove.yDistance || yDistance - pastMove1.yDistance < -0.001)) {
                    this.tags.add("elytra_asc2");
                    return yDistance;
                }
            }
        }
        if (yDistance > limitV && data.fireworksBoostDuration > 0 && lastMove.toIsValid && (yDistance >= lastMove.yDistance || yDistance - lastMove.yDistance < 0.0834) && (yDistance - lastMove.yDistance < 0.77 || lastMove.yDistance < 0.0 && yDistance < 1.54) && yDistance < 1.67) {
            this.tags.add("fw_boost_asc");
            return yDistance;
        }
        return limitV;
    }

    private double[] vDistDescend(PlayerLocation from, PlayerLocation to, double yDistance, boolean flying, PlayerMoveData lastMove, ModelFlying model, MovingData data, MovingConfig cc) {
        double limitV = 0.0;
        double resultV = 0.0;
        return new double[]{limitV, resultV};
    }

    private double[] vDistZero(PlayerLocation from, PlayerLocation to, double yDistance, boolean flying, PlayerMoveData lastMove, ModelFlying model, MovingData data, MovingConfig cc) {
        double limitV = 0.0;
        double resultV = 0.0;
        return new double[]{limitV, resultV};
    }

    private double getCorrectedHeight(double maximumHeight, World world) {
        return Math.max(maximumHeight - 10.0, (double)world.getMaxHeight());
    }

    private void outpuDebugMove(Player player, double hDistance, double limitH, double yDistance, double limitV, ModelFlying model, List<String> tags, MovingData data) {
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        StringBuilder builder = new StringBuilder(350);
        String dHDist = lastMove.toIsValid ? " (" + StringUtil.formatDiff(hDistance, lastMove.hDistance) + ")" : "";
        String dYDist = lastMove.toIsValid ? " (" + StringUtil.formatDiff(yDistance, lastMove.yDistance) + ")" : "";
        builder.append("hDist: " + hDistance + dHDist + " / " + limitH + " , vDist: " + yDistance + dYDist + " / " + limitV);
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        if (lastMove.toIsValid) {
            builder.append(" , fdsq: " + StringUtil.fdec3.format(thisMove.distanceSquared / lastMove.distanceSquared));
        }
        if (thisMove.verVelUsed != null) {
            builder.append(" , vVelUsed: " + thisMove.verVelUsed);
        }
        if (data.fireworksBoostDuration > 0 && model.id.equals("jetpack.elytra")) {
            builder.append(" , boost: " + data.fireworksBoostDuration);
        }
        builder.append(" , model: " + model.id);
        if (!tags.isEmpty()) {
            builder.append(" , tags: ");
            builder.append(StringUtil.join(tags, "+"));
        }
        builder.append(" , jumpphase: " + data.sfJumpPhase);
        thisMove.addExtraProperties(builder, " , ");
        this.debug(player, builder.toString());
    }
}

