/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.model;

import fr.neatmonster.nocheatplus.checks.moving.model.MoveData;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveTrace<MD extends MoveData> {
    private final LinkedList<MD> pastMoves = new LinkedList();
    private MD currentMove;

    public MoveTrace(Callable<MD> factory, int size) {
        try {
            for (int i = 0; i < size; ++i) {
                this.pastMoves.add(factory.call());
            }
            this.currentMove = (MoveData)factory.call();
        }
        catch (Exception dummy) {
            throw new RuntimeException(dummy);
        }
    }

    public MD getCurrentMove() {
        return this.currentMove;
    }

    public int getNumberOfPastMoves() {
        return this.pastMoves.size();
    }

    public MD getFirstPastMove() {
        return (MD)((MoveData)this.pastMoves.getFirst());
    }

    public MD getSecondPastMove() {
        return (MD)((MoveData)this.pastMoves.get(1));
    }

    public MD getPastMove(int index) {
        return (MD)((MoveData)this.pastMoves.get(index));
    }

    public void invalidate() {
        Iterator it = this.pastMoves.iterator();
        while (it.hasNext()) {
            ((MoveData)it.next()).invalidate();
        }
        ((MoveData)this.currentMove).invalidate();
    }

    public void finishCurrentMove() {
        this.pastMoves.addFirst(this.currentMove);
        this.currentMove = (MoveData)this.pastMoves.removeLast();
        ((MoveData)this.currentMove).invalidate();
    }
}

