/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.inventory;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.combined.Combined;
import fr.neatmonster.nocheatplus.checks.combined.Improbable;
import fr.neatmonster.nocheatplus.checks.inventory.Drop;
import fr.neatmonster.nocheatplus.checks.inventory.FastClick;
import fr.neatmonster.nocheatplus.checks.inventory.InstantBow;
import fr.neatmonster.nocheatplus.checks.inventory.InstantEat;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryConfig;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryData;
import fr.neatmonster.nocheatplus.checks.inventory.Items;
import fr.neatmonster.nocheatplus.checks.inventory.Open;
import fr.neatmonster.nocheatplus.checks.moving.util.MovingUtil;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.BridgeHealth;
import fr.neatmonster.nocheatplus.components.entity.IEntityAccessVehicle;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceHandle;
import fr.neatmonster.nocheatplus.components.registry.feature.JoinLeaveListener;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.utilities.InventoryUtil;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ComplexEntityPart;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class InventoryListener
extends CheckListener
implements JoinLeaveListener {
    private final Drop drop = this.addCheck(new Drop());
    private final FastClick fastClick = this.addCheck(new FastClick());
    private final InstantBow instantBow = this.addCheck(new InstantBow());
    private final InstantEat instantEat = this.addCheck(new InstantEat());
    protected final Items items = this.addCheck(new Items());
    private final Open open = this.addCheck(new Open());
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    private final Counters counters = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class);
    private final int idCancelDead = this.counters.registerKey("canceldead");
    private final int idIllegalItem = this.counters.registerKey("illegalitem");
    private final int idEggOnEntity = this.counters.registerKey("eggonentity");
    private final IGenericInstanceHandle<IEntityAccessVehicle> handleVehicles = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstanceHandle(IEntityAccessVehicle.class);

    public InventoryListener() {
        super(CheckType.INVENTORY);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityShootBow(EntityShootBowEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && this.instantBow.isEnabled(player = (Player)event.getEntity())) {
            long now = System.currentTimeMillis();
            Location loc = player.getLocation(this.useLoc);
            if (Combined.checkYawRate(player, loc.getYaw(), now, loc.getWorld().getName())) {
                event.setCancelled(true);
            }
            if (this.instantBow.check(player, event.getForce(), now)) {
                event.setCancelled(true);
            } else if (Improbable.check(player, 0.6f, now, "inventory.instantbow")) {
                event.setCancelled(true);
            }
            this.useLoc.setWorld(null);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (this.instantEat.isEnabled(player) && this.instantEat.check(player, event.getFoodLevel())) {
                event.setCancelled(true);
            } else if (player.isDead() && BridgeHealth.getHealth((LivingEntity)player) <= 0.0) {
                event.setCancelled(true);
                this.counters.addPrimaryThread(this.idCancelDead, 1);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        long now = System.currentTimeMillis();
        HumanEntity entity = event.getWhoClicked();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        InventoryData data = InventoryData.getData(player);
        int slot = event.getSlot();
        if (data.debug) {
            this.outputDebugInventoryClick(player, slot, event, data);
        }
        if (slot == -999 || slot < 0) {
            data.lastClickTime = now;
            return;
        }
        ItemStack cursor = event.getCursor();
        ItemStack clicked = event.getCurrentItem();
        boolean cancel = false;
        try {
            if (!cancel && Items.checkIllegalEnchantments(player, clicked)) {
                cancel = true;
                this.counters.addPrimaryThread(this.idIllegalItem, 1);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            if (!cancel && Items.checkIllegalEnchantments(player, cursor)) {
                cancel = true;
                this.counters.addPrimaryThread(this.idIllegalItem, 1);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (this.fastClick.isEnabled(player)) {
            InventoryConfig cc = InventoryConfig.getConfig(player);
            if (player.getGameMode() != GameMode.CREATIVE || !cc.fastClickSpareCreative) {
                if (this.fastClick.check(player, now, event.getView(), slot, cursor, clicked, event.isShiftClick(), data, cc)) {
                    cancel = true;
                }
                Improbable.feed(player, 0.7f, System.currentTimeMillis());
            }
        }
        data.lastClickTime = now;
        if (cancel) {
            event.setCancelled(true);
        }
    }

    private void outputDebugInventoryClick(Player player, int slot, InventoryClickEvent event, InventoryData data) {
        StringBuilder builder = new StringBuilder(512);
        builder.append("Inventory click: slot: " + slot);
        builder.append(" , Viewers: ");
        for (HumanEntity entity : event.getViewers()) {
            builder.append(entity.getName());
            builder.append("(");
            builder.append(entity.getClass().getName());
            builder.append(")");
        }
        builder.append(" , View: ");
        InventoryView view = event.getView();
        builder.append(view.getClass().getName());
        this.addInventory(player, view.getBottomInventory(), " , Bottom: ", builder);
        this.addInventory(player, view.getBottomInventory(), " , Top: ", builder);
        builder.append(" , Event: ");
        builder.append(event.getClass().getName());
        this.debug(player, builder.toString());
    }

    private void addInventory(Player player, Inventory inventory, String prefix, StringBuilder builder) {
        builder.append(prefix);
        if (inventory == null) {
            builder.append("(none)");
        } else {
            String name = inventory.getName();
            String title = inventory.getTitle();
            boolean same = name == null && title == null || name != null && name.equals(title);
            builder.append(same ? name : name + "/" + title);
            builder.append("/");
            builder.append(inventory.getClass().getName());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    protected void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        Item item = event.getItemDrop();
        if (item != null) {
            Items.checkIllegalEnchantments(player, item.getItemStack());
        }
        if (event.getPlayer().isDead()) {
            return;
        }
        if (this.drop.isEnabled(event.getPlayer()) && this.drop.check(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.LOWEST)
    public final void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        InventoryData data = InventoryData.getData(player);
        boolean resetAll = false;
        if (event.hasItem()) {
            ItemStack item = event.getItem();
            Material type = item.getType();
            if (type == Material.BOW) {
                long now = System.currentTimeMillis();
                data.instantBowInteract = data.instantBowInteract > 0L && now - data.instantBowInteract < 800L ? Math.min(System.currentTimeMillis(), data.instantBowInteract) : System.currentTimeMillis();
            } else if (InventoryUtil.isConsumable(type)) {
                long now = System.currentTimeMillis();
                data.instantEatFood = type;
                data.instantEatInteract = data.instantEatInteract > 0L && now - data.instantEatInteract < 800L ? Math.min(System.currentTimeMillis(), data.instantEatInteract) : System.currentTimeMillis();
                data.instantBowInteract = 0L;
            } else {
                resetAll = true;
            }
            if (Items.checkIllegalEnchantments(player, item)) {
                event.setCancelled(true);
                this.counters.addPrimaryThread(this.idIllegalItem, 1);
            }
        } else {
            resetAll = true;
        }
        if (resetAll) {
            if (data.debug && data.instantEatFood != null) {
                this.debug(player, "PlayerInteractEvent, reset fastconsume (legacy: instanteat).");
            }
            data.instantBowInteract = 0L;
            data.instantEatInteract = 0L;
            data.instantEatFood = null;
        }
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.LOWEST)
    public final void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (player.isDead() && BridgeHealth.getHealth((LivingEntity)player) <= 0.0) {
            event.setCancelled(true);
            this.counters.addPrimaryThread(this.idCancelDead, 1);
            return;
        }
        if (MovingUtil.hasScheduledPlayerSetBack(player)) {
            event.setCancelled(true);
            return;
        }
        ItemStack stack = Bridge1_9.getUsedItem(player, event);
        Entity entity = event.getRightClicked();
        if (stack != null && stack.getType() == Material.MONSTER_EGG && (entity == null || entity instanceof LivingEntity || entity instanceof ComplexEntityPart) && this.items.isEnabled(player)) {
            event.setCancelled(true);
            this.counters.addPrimaryThread(this.idEggOnEntity, 1);
            return;
        }
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.LOWEST)
    public final void onPlayerInventoryOpen(InventoryOpenEvent event) {
        HumanEntity entity = event.getPlayer();
        if (entity instanceof Player && MovingUtil.hasScheduledPlayerSetBack((Player)entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onItemHeldChange(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        InventoryData data = InventoryData.getData(player);
        if (data.debug && data.instantEatFood != null) {
            this.debug(player, "PlayerItemHeldEvent, reset fastconsume (legacy: instanteat).");
        }
        data.instantBowInteract = 0L;
        data.instantEatInteract = 0L;
        data.instantEatFood = null;
        PlayerInventory inv = player.getInventory();
        Items.checkIllegalEnchantments(player, inv.getItem(event.getNewSlot()));
        Items.checkIllegalEnchantments(player, inv.getItem(event.getPreviousSlot()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        this.open.check(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerPortal(PlayerPortalEvent event) {
        this.open.check(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityPortal(EntityPortalEnterEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            this.open.check((Player)entity);
        } else {
            for (Entity passenger : this.handleVehicles.getHandle().getEntityPassengers(entity)) {
                if (!(passenger instanceof Player)) continue;
                this.open.check((Player)passenger);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        this.open.check(event.getPlayer());
    }

    public void playerJoins(Player player) {
    }

    public void playerLeaves(Player player) {
        this.open.check(player);
    }
}

