/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.fight;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.combined.Combined;
import fr.neatmonster.nocheatplus.checks.combined.Improbable;
import fr.neatmonster.nocheatplus.checks.fight.Angle;
import fr.neatmonster.nocheatplus.checks.fight.Critical;
import fr.neatmonster.nocheatplus.checks.fight.Direction;
import fr.neatmonster.nocheatplus.checks.fight.DirectionContext;
import fr.neatmonster.nocheatplus.checks.fight.FastHeal;
import fr.neatmonster.nocheatplus.checks.fight.FightConfig;
import fr.neatmonster.nocheatplus.checks.fight.FightData;
import fr.neatmonster.nocheatplus.checks.fight.GodMode;
import fr.neatmonster.nocheatplus.checks.fight.NoSwing;
import fr.neatmonster.nocheatplus.checks.fight.Reach;
import fr.neatmonster.nocheatplus.checks.fight.ReachContext;
import fr.neatmonster.nocheatplus.checks.fight.SelfHit;
import fr.neatmonster.nocheatplus.checks.fight.Speed;
import fr.neatmonster.nocheatplus.checks.inventory.Items;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.location.tracking.LocationTrace;
import fr.neatmonster.nocheatplus.checks.moving.model.LiftOffEnvelope;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveInfo;
import fr.neatmonster.nocheatplus.checks.moving.player.UnusedVelocity;
import fr.neatmonster.nocheatplus.checks.moving.util.AuxMoving;
import fr.neatmonster.nocheatplus.checks.moving.util.MovingUtil;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.BridgeEnchant;
import fr.neatmonster.nocheatplus.compat.BridgeHealth;
import fr.neatmonster.nocheatplus.compat.IBridgeCrossPlugin;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.components.location.IGetPosition;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceHandle;
import fr.neatmonster.nocheatplus.components.registry.feature.JoinLeaveListener;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.build.BuildParameters;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.location.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import org.bukkit.Location;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;

public class FightListener
extends CheckListener
implements JoinLeaveListener {
    private final Angle angle = this.addCheck(new Angle());
    private final Critical critical = this.addCheck(new Critical());
    private final Direction direction = this.addCheck(new Direction());
    private final FastHeal fastHeal = this.addCheck(new FastHeal());
    private final GodMode godMode = this.addCheck(new GodMode());
    private final NoSwing noSwing = this.addCheck(new NoSwing());
    private final Reach reach = this.addCheck(new Reach());
    private final SelfHit selfHit = this.addCheck(new SelfHit());
    private final Speed speed = this.addCheck(new Speed());
    private final Location useLoc1 = new Location(null, 0.0, 0.0, 0.0);
    private final Location useLoc2 = new Location(null, 0.0, 0.0, 0.0);
    private final AuxMoving auxMoving = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(AuxMoving.class);
    private final Counters counters = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class);
    private final int idCancelDead = this.counters.registerKey("canceldead");
    private final IGenericInstanceHandle<IBridgeCrossPlugin> crossPlugin = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstanceHandle(IBridgeCrossPlugin.class);

    public FightListener() {
        super(CheckType.FIGHT);
    }

    private boolean handleNormalDamage(Player player, boolean attackerIsFake, Entity damaged, boolean damagedIsFake, double originalDamage, double finalDamage, int tick, FightData data) {
        LocationTrace damagedTrace;
        Player damagedPlayer;
        double normalizedMove;
        FightConfig cc = FightConfig.getConfig(player);
        if (Items.checkIllegalEnchantmentsAllHands(player)) {
            return true;
        }
        boolean cancelled = false;
        String worldName = player.getWorld().getName();
        long now = System.currentTimeMillis();
        boolean worldChanged = !worldName.equals(data.lastWorld);
        Location loc = player.getLocation(this.useLoc1);
        Location damagedLoc = damaged.getLocation(this.useLoc2);
        if (data.lastAttackedX == Double.MAX_VALUE || tick < data.lastAttackTick || worldChanged || tick - data.lastAttackTick > 20) {
            boolean tickAge = false;
            double targetMove = 0.0;
            normalizedMove = 0.0;
            long msAge = 0L;
        } else {
            int tickAge = tick - data.lastAttackTick;
            double targetMove = TrigUtil.distance(data.lastAttackedX, data.lastAttackedZ, damagedLoc.getX(), damagedLoc.getZ());
            long msAge = (long)(50.0f * TickTask.getLag(50L * (long)tickAge, true) * (float)tickAge);
            double d = normalizedMove = msAge == 0L ? targetMove : targetMove * Math.min(20.0, 1000.0 / (double)msAge);
        }
        if (damaged instanceof Player) {
            damagedPlayer = (Player)damaged;
            if (data.debug && damagedPlayer.hasPermission("nocheatplus.admin.debug")) {
                damagedPlayer.sendMessage("Attacked by " + player.getName() + ": inv=" + ((MCAccess)this.mcAccess.getHandle()).getInvulnerableTicks(damagedPlayer) + " ndt=" + damagedPlayer.getNoDamageTicks());
            }
            if (this.selfHit.isEnabled(player) && this.selfHit.check(player, damagedPlayer, data, cc)) {
                cancelled = true;
            }
            damagedTrace = MovingData.getData(damagedPlayer).updateTrace(damagedPlayer, damagedLoc, tick, damagedIsFake ? null : (MCAccess)this.mcAccess.getHandle());
        } else {
            damagedPlayer = null;
            damagedTrace = null;
        }
        if (data.debug) {
            this.debug(player, "Attacks " + (damagedPlayer == null ? "entity " + damaged.getType() : "player" + damagedPlayer.getName()) + " damage=" + (finalDamage == originalDamage ? Double.valueOf(finalDamage) : originalDamage + "/" + finalDamage));
        }
        if (cc.cancelDead) {
            if (damaged.isDead()) {
                cancelled = true;
            }
            if (player.isDead() && data.damageTakenByEntityTick != (long)TickTask.getTick()) {
                cancelled = true;
            }
        }
        if (BridgeHealth.DAMAGE_SWEEP == null) {
            int locHashCode = LocUtil.hashCode(loc);
            if (originalDamage == 1.0) {
                if (tick == data.sweepTick && locHashCode == data.sweepLocationHashCode) {
                    if (data.debug) {
                        this.debug(player, "(Assume sweep attack follow up damage.)");
                    }
                    return cancelled;
                }
            } else {
                data.sweepTick = tick;
                data.sweepLocationHashCode = locHashCode;
            }
        }
        if (BridgeHealth.DAMAGE_THORNS == null && originalDamage <= 4.0 && (long)tick == data.damageTakenByEntityTick && data.thornsId != Integer.MIN_VALUE && data.thornsId == damaged.getEntityId()) {
            data.thornsId = Integer.MIN_VALUE;
            return cancelled;
        }
        data.thornsId = Integer.MIN_VALUE;
        if (!cancelled && this.speed.isEnabled(player)) {
            if (this.speed.check(player, now)) {
                cancelled = true;
                if (data.speedVL > 50.0) {
                    Improbable.check(player, 2.0f, now, "fight.speed");
                } else {
                    Improbable.feed(player, 2.0f, now);
                }
            } else if (normalizedMove > 2.0 && Improbable.check(player, 1.0f, now, "fight.speed")) {
                cancelled = true;
            }
        }
        if (!cancelled && this.critical.isEnabled(player) && this.critical.check(player, loc, data, cc)) {
            cancelled = true;
        }
        if (!cancelled && this.noSwing.isEnabled(player) && this.noSwing.check(player, data, cc)) {
            cancelled = true;
        }
        if (!cancelled && player.isBlocking() && !player.hasPermission("nocheatplus.checks.moving.survivalfly.blocking")) {
            cancelled = true;
        }
        if (!cancelled) {
            boolean reachEnabled = this.reach.isEnabled(player);
            boolean directionEnabled = this.direction.isEnabled(player);
            if (reachEnabled || directionEnabled) {
                if (damagedTrace != null) {
                    cancelled = this.locationTraceChecks(player, loc, data, cc, damaged, damagedIsFake, damagedLoc, damagedTrace, tick, now, reachEnabled, directionEnabled);
                } else {
                    if (reachEnabled && this.reach.check(player, loc, damaged, damagedIsFake, damagedLoc, data, cc)) {
                        cancelled = true;
                    }
                    if (directionEnabled && this.direction.check(player, loc, damaged, damagedIsFake, damagedLoc, data, cc)) {
                        cancelled = true;
                    }
                }
            }
        }
        if (this.angle.isEnabled(player)) {
            if (Combined.checkYawRate(player, loc.getYaw(), now, worldName, cc.yawRateCheck)) {
                cancelled = true;
            }
            if (this.angle.check(player, loc, damaged, worldChanged, data, cc)) {
                if (!cancelled && data.debug) {
                    this.debug(player, "FIGHT_ANGLE cancel without yawrate cancel.");
                }
                cancelled = true;
            }
        }
        data.lastWorld = worldName;
        data.lastAttackTick = tick;
        data.lastAttackedX = damagedLoc.getX();
        data.lastAttackedY = damagedLoc.getY();
        data.lastAttackedZ = damagedLoc.getZ();
        if (!cancelled && TrigUtil.distance(loc.getX(), loc.getZ(), damagedLoc.getX(), damagedLoc.getZ()) < 4.5) {
            double hDist;
            MovingData mData = MovingData.getData(player);
            PlayerMoveData lastMove = mData.playerMoves.getFirstPastMove();
            if (lastMove.valid && mData.liftOffEnvelope == LiftOffEnvelope.NORMAL && (hDist = TrigUtil.xzDistance(loc, (IGetPosition)lastMove.from)) >= 0.23) {
                MovingConfig mCc = MovingConfig.getConfig(player);
                PlayerMoveInfo moveInfo = this.auxMoving.usePlayerMoveInfo();
                moveInfo.set(player, loc, null, mCc.yOnGround);
                if (now <= mData.timeSprinting + mCc.sprintingGrace && MovingUtil.shouldCheckSurvivalFly(player, (PlayerLocation)moveInfo.from, mData, mCc)) {
                    mData.lostSprintCount = 7;
                    if ((data.debug || mCc.debug) && BuildParameters.debugLevel > 0) {
                        this.debug(player, "lostsprint: hDist to last from: " + hDist + " | targetdist=" + TrigUtil.distance(loc.getX(), loc.getZ(), damagedLoc.getX(), damagedLoc.getZ()) + " | sprinting=" + player.isSprinting() + " | food=" + player.getFoodLevel() + " | hbuf=" + mData.sfHorizontalBuffer);
                    }
                }
                this.auxMoving.returnPlayerMoveInfo(moveInfo);
            }
        }
        if (!cancelled && data.attackPenalty.isPenalty(now)) {
            cancelled = true;
            if (data.debug) {
                this.debug(player, "~ attack penalty.");
            }
        }
        this.useLoc1.setWorld(null);
        this.useLoc2.setWorld(null);
        return cancelled;
    }

    private boolean locationTraceChecks(Player player, Location loc, FightData data, FightConfig cc, Entity damaged, boolean damagedIsFake, Location damagedLoc, LocationTrace damagedTrace, long tick, long now, boolean reachEnabled, boolean directionEnabled) {
        boolean cancelled = false;
        ReachContext reachContext = reachEnabled ? this.reach.getContext(player, loc, damaged, damagedLoc, data, cc) : null;
        DirectionContext directionContext = directionEnabled ? this.direction.getContext(player, loc, damaged, damagedIsFake, damagedLoc, data, cc) : null;
        long traceOldest = tick - cc.loopMaxLatencyTicks;
        LocationTrace.TraceIterator traceIt = damagedTrace.maxAgeIterator(traceOldest);
        boolean violation = true;
        boolean reachPassed = !reachEnabled;
        boolean directionPassed = !directionEnabled;
        long latencyEstimate = -1L;
        LocationTrace.ITraceEntry successEntry = null;
        while (traceIt.hasNext()) {
            LocationTrace.ITraceEntry entry = (LocationTrace.ITraceEntry)traceIt.next();
            boolean thisPassed = true;
            if (reachEnabled) {
                if (this.reach.loopCheck(player, loc, damaged, entry, reachContext, data, cc)) {
                    thisPassed = false;
                } else {
                    reachPassed = true;
                }
            }
            if (directionEnabled && (reachPassed || !directionPassed)) {
                if (this.direction.loopCheck(player, loc, damaged, entry, directionContext, data, cc)) {
                    thisPassed = false;
                } else {
                    directionPassed = true;
                }
            }
            if (!thisPassed) continue;
            violation = false;
            latencyEstimate = now - entry.getTime();
            successEntry = entry;
            break;
        }
        if (reachEnabled && this.reach.loopFinish(player, loc, damaged, reachContext, successEntry, violation, data, cc)) {
            cancelled = true;
        }
        if (directionEnabled && this.direction.loopFinish(player, loc, damaged, directionContext, violation, data, cc)) {
            cancelled = true;
        }
        if (data.debug && latencyEstimate >= 0L) {
            this.debug(player, "Latency estimate: " + latencyEstimate + " ms.");
        }
        return cancelled;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityDamage(EntityDamageEvent event) {
        boolean damagedIsFake;
        Entity damaged = event.getEntity();
        Player damagedPlayer = damaged instanceof Player ? (Player)damaged : null;
        FightData damagedData = damagedPlayer == null ? null : FightData.getData(damagedPlayer);
        boolean damagedIsDead = damaged.isDead();
        boolean bl = damagedIsFake = !this.crossPlugin.getHandle().isNativeEntity(damaged);
        if (damagedPlayer != null && !damagedIsDead) {
            if (this.godMode.isEnabled(damagedPlayer) && this.godMode.check(damagedPlayer, damagedIsFake, BridgeHealth.getDamage(event), damagedData)) {
                damagedPlayer.setNoDamageTicks(0);
            }
            if (BridgeHealth.getHealth((LivingEntity)damagedPlayer) >= BridgeHealth.getMaxHealth((LivingEntity)damagedPlayer)) {
                if (damagedData.fastHealBuffer < 0L) {
                    damagedData.fastHealBuffer /= 2L;
                }
                damagedData.fastHealRefTime = System.currentTimeMillis();
            }
            if (damagedData.debug) {
                UnusedVelocity.checkUnusedVelocity(damagedPlayer, CheckType.FIGHT);
            }
        }
        if (event instanceof EntityDamageByEntityEvent) {
            this.onEntityDamageByEntity(damaged, damagedPlayer, damagedIsDead, damagedIsFake, damagedData, (EntityDamageByEntityEvent)event);
        }
    }

    private void onEntityDamageByEntity(Entity damaged, Player damagedPlayer, boolean damagedIsDead, boolean damagedIsFake, FightData damagedData, EntityDamageByEntityEvent event) {
        FightData attackerData;
        Entity source;
        Player player;
        Entity damager = event.getDamager();
        int tick = TickTask.getTick();
        if (damagedPlayer != null && !damagedIsDead) {
            damagedData.damageTakenByEntityTick = tick;
            damagedData.thornsId = BridgeEnchant.hasThorns(damagedPlayer) ? damager.getEntityId() : Integer.MIN_VALUE;
        }
        EntityDamageEvent.DamageCause damageCause = event.getCause();
        Player attacker = player = damager instanceof Player ? (Player)damager : null;
        if (damager instanceof TNTPrimed && (source = ((TNTPrimed)damager).getSource()) instanceof Player) {
            attacker = (Player)source;
        }
        if (attacker != null) {
            attackerData = FightData.getData(attacker);
            if (attackerData.debug) {
                UnusedVelocity.checkUnusedVelocity(attacker, CheckType.FIGHT);
            }
            if (damageCause == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION || damageCause == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
                attackerData.lastExplosionEntityId = damaged.getEntityId();
                attackerData.lastExplosionDamageTick = tick;
                return;
            }
        } else {
            attackerData = null;
        }
        if (player != null && damageCause == EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
            if (damaged.getEntityId() == attackerData.lastExplosionEntityId && tick == attackerData.lastExplosionDamageTick) {
                attackerData.lastExplosionDamageTick = -1;
                attackerData.lastExplosionEntityId = Integer.MAX_VALUE;
            } else if (MovingUtil.hasScheduledPlayerSetBack(player)) {
                if (attackerData.debug) {
                    this.debug(attacker, "Prevent melee attack, due to a scheduled set back.");
                }
                event.setCancelled(true);
            } else if (this.handleNormalDamage(player, !this.crossPlugin.getHandle().isNativePlayer(player), damaged, damagedIsFake, BridgeHealth.getOriginalDamage((EntityDamageEvent)event), BridgeHealth.getFinalDamage((EntityDamageEvent)event), tick, attackerData)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onEntityDamageMonitor(EntityDamageEvent event) {
        Entity damaged = event.getEntity();
        if (damaged instanceof Player) {
            Player damagedPlayer = (Player)damaged;
            FightData damagedData = FightData.getData(damagedPlayer);
            int ndt = damagedPlayer.getNoDamageTicks();
            if (damagedData.lastDamageTick == TickTask.getTick() && damagedData.lastNoDamageTicks != ndt) {
                damagedData.lastNoDamageTicks = ndt;
            }
            switch (event.getCause()) {
                case ENTITY_ATTACK: {
                    Entity entity;
                    if (!(event instanceof EntityDamageByEntityEvent) || !((entity = ((EntityDamageByEntityEvent)event).getDamager()) instanceof Player) || damagedPlayer.isInsideVehicle() || !FightConfig.getConfig((Player)damagedPlayer).knockBackVelocityPvP) break;
                    this.applyKnockBack((Player)entity, damagedPlayer, damagedData);
                }
            }
        }
    }

    private void applyKnockBack(Player attacker, Player damagedPlayer, FightData damagedData) {
        double vx;
        double level = this.getKnockBackLevel(attacker);
        MovingData mdata = MovingData.getData(damagedPlayer);
        MovingConfig mcc = MovingConfig.getConfig(damagedPlayer);
        double vz = vx = level / Math.sqrt(8.0);
        double vy = 0.462;
        this.useLoc1.setWorld(null);
        if (damagedData.debug || mdata.debug) {
            this.debug(damagedPlayer, "Received knockback level: " + level);
        }
        mdata.addVelocity(damagedPlayer, mcc, vx, 0.462, vz, 1024L);
    }

    private double getKnockBackLevel(Player player) {
        double level = 1.0;
        ItemStack stack = Bridge1_9.getItemInMainHand(player);
        if (!BlockProperties.isAir(stack)) {
            level = stack.getEnchantmentLevel(Enchantment.KNOCKBACK);
        }
        if (player.isSprinting()) {
            level += 1.0;
        }
        return Math.min(20.0, level);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onEntityDeathEvent(EntityDeathEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && this.godMode.isEnabled(player = (Player)entity)) {
            this.godMode.death(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onPlayerAnimation(PlayerAnimationEvent event) {
        FightData.getData((Player)event.getPlayer()).noSwingArmSwung = true;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityRegainHealthLow(EntityRegainHealthEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.isDead() && BridgeHealth.getHealth((LivingEntity)player) <= 0.0) {
            event.setCancelled(true);
            this.counters.addPrimaryThread(this.idCancelDead, 1);
            return;
        }
        if (event.getRegainReason() != EntityRegainHealthEvent.RegainReason.SATIATED) {
            return;
        }
        if (this.fastHeal.isEnabled(player) && this.fastHeal.check(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityRegainHealth(EntityRegainHealthEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        FightData data = FightData.getData(player);
        data.regainHealthTime = System.currentTimeMillis();
        double health = Math.min(BridgeHealth.getHealth((LivingEntity)player) + BridgeHealth.getAmount(event), BridgeHealth.getMaxHealth((LivingEntity)player));
        data.godModeHealth = Math.max(data.godModeHealth, health);
    }

    public void playerJoins(Player player) {
    }

    public void playerLeaves(Player player) {
        FightData data = FightData.getData(player);
        data.angleHits.clear();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        FightData.getData(event.getPlayer()).onWorldChange();
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.MONITOR)
    public void onItemHeld(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        long penalty = FightConfig.getConfig((Player)player).toolChangeAttackPenalty;
        if (penalty > 0L) {
            FightData.getData((Player)player).attackPenalty.applyPenalty(penalty);
        }
    }
}

