/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.fight;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.fight.FightConfig;
import fr.neatmonster.nocheatplus.checks.fight.FightData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.LiftOffEnvelope;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveInfo;
import fr.neatmonster.nocheatplus.checks.moving.util.AuxMoving;
import fr.neatmonster.nocheatplus.checks.moving.util.MovingUtil;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class Critical
extends Check {
    private final AuxMoving auxMoving = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(AuxMoving.class);

    public Critical() {
        super(CheckType.FIGHT_CRITICAL);
    }

    public boolean check(Player player, Location loc, FightData data, FightConfig cc) {
        MovingData dataM;
        boolean cancel = false;
        double mcFallDistance = player.getFallDistance();
        MovingConfig mCc = MovingConfig.getConfig(player);
        if (data.debug) {
            this.debug(player, "y=" + loc.getY() + " mcfalldist=" + mcFallDistance);
        }
        if (mcFallDistance > 0.0 && !player.isInsideVehicle() && !player.hasPotionEffect(PotionEffectType.BLINDNESS) && !(dataM = MovingData.getData(player)).isVelocityJumpPhase() && (dataM.sfLowJump && !dataM.sfNoLowJump && dataM.liftOffEnvelope == LiftOffEnvelope.NORMAL || mcFallDistance < cc.criticalFallDistance && !BlockProperties.isResetCond(player, loc, mCc.yOnGround))) {
            MovingConfig ccM = MovingConfig.getConfig(player);
            PlayerMoveInfo moveInfo = this.auxMoving.usePlayerMoveInfo();
            moveInfo.set(player, loc, null, ccM.yOnGround);
            if (MovingUtil.shouldCheckSurvivalFly(player, (PlayerLocation)moveInfo.from, dataM, ccM)) {
                data.criticalVL += 1.0;
                ViolationData vd = new ViolationData(this, player, data.criticalVL, 1.0, cc.criticalActions);
                if (vd.needsParameters()) {
                    ArrayList<String> tags = new ArrayList<String>();
                    if (dataM.sfLowJump) {
                        tags.add("lowjump");
                    }
                    vd.setParameter(ParameterName.TAGS, StringUtil.join(tags, "+"));
                }
                cancel = this.executeActions(vd).willCancel();
            }
            this.auxMoving.returnPlayerMoveInfo(moveInfo);
        }
        return cancel;
    }
}

