/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.chat.analysis.engine.processors;

import fr.neatmonster.nocheatplus.checks.chat.analysis.MessageLetterCount;
import fr.neatmonster.nocheatplus.checks.chat.analysis.engine.processors.DigestedWords;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.utilities.ds.count.ActionFrequency;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatWords
extends DigestedWords {
    protected final int maxSize;
    protected final LinkedHashMap<String, ActionFrequency> entries;
    protected final long durBucket;
    protected final int nBuckets;
    protected final float factor;
    protected long lastAdd = System.currentTimeMillis();

    public FlatWords(String name, FlatWordsSettings settings) {
        super(name, settings);
        this.maxSize = settings.maxSize;
        this.entries = new LinkedHashMap(this.maxSize);
        this.nBuckets = settings.nBuckets;
        this.durBucket = settings.durBucket;
        this.factor = settings.factor;
    }

    @Override
    public void start(MessageLetterCount message) {
        if (System.currentTimeMillis() - this.lastAdd > (long)this.nBuckets * this.durBucket) {
            this.entries.clear();
        } else if (this.entries.size() + message.words.length > this.maxSize) {
            FlatWords.releaseMap(this.entries, Math.max(message.words.length, this.maxSize / 10));
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.entries.clear();
    }

    @Override
    protected float getScore(List<Character> chars, long ts) {
        this.lastAdd = ts;
        char[] a = DigestedWords.toArray(chars);
        String key = new String(a);
        ActionFrequency freq = this.entries.get(key);
        if (freq == null) {
            freq = new ActionFrequency(this.nBuckets, this.durBucket);
            this.entries.put(key, freq);
            return 0.0f;
        }
        freq.update(ts);
        float score = Math.min(1.0f, freq.score(this.factor));
        freq.add(ts, 1.0f);
        return score;
    }

    public static class FlatWordsSettings
    extends DigestedWords.DigestedWordsSettings {
        public int maxSize = 1000;
        public long durBucket = 1500L;
        public int nBuckets = 4;
        public float factor = 0.9f;

        public FlatWordsSettings() {
            this.split = true;
        }

        public FlatWordsSettings applyConfig(ConfigFile config, String prefix) {
            super.applyConfig(config, prefix);
            this.maxSize = config.getInt(prefix + "size", this.maxSize);
            this.nBuckets = config.getInt(prefix + "buckets", this.nBuckets);
            this.durBucket = (long)(config.getDouble(prefix + "time", (float)this.durBucket / 1000.0f) * 1000.0);
            this.factor = (float)config.getDouble(prefix + "factor", this.factor);
            return this;
        }
    }
}

