/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.chat.analysis.engine;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.chat.ChatConfig;
import fr.neatmonster.nocheatplus.checks.chat.ChatData;
import fr.neatmonster.nocheatplus.checks.chat.analysis.MessageLetterCount;
import fr.neatmonster.nocheatplus.checks.chat.analysis.engine.EnginePlayerData;
import fr.neatmonster.nocheatplus.checks.chat.analysis.engine.EnginePlayerDataMap;
import fr.neatmonster.nocheatplus.checks.chat.analysis.engine.processors.DigestedWords;
import fr.neatmonster.nocheatplus.checks.chat.analysis.engine.processors.FlatWords;
import fr.neatmonster.nocheatplus.checks.chat.analysis.engine.processors.SimilarWordsBKL;
import fr.neatmonster.nocheatplus.checks.chat.analysis.engine.processors.WordPrefixes;
import fr.neatmonster.nocheatplus.checks.chat.analysis.engine.processors.WordProcessor;
import fr.neatmonster.nocheatplus.components.data.IData;
import fr.neatmonster.nocheatplus.components.registry.feature.ConsistencyChecker;
import fr.neatmonster.nocheatplus.components.registry.feature.IHaveCheckType;
import fr.neatmonster.nocheatplus.components.registry.feature.IRemoveData;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LetterEngine
implements IRemoveData,
IHaveCheckType,
ConsistencyChecker {
    protected final List<WordProcessor> processors = new ArrayList<WordProcessor>();
    protected final EnginePlayerDataMap dataMap;

    public LetterEngine(ConfigFile config) {
        DigestedWords.DigestedWordsSettings settings;
        if (config.getBoolean("checks.chat.text.global.words.active", false)) {
            settings = new FlatWords.FlatWordsSettings();
            ((FlatWords.FlatWordsSettings)settings).maxSize = 1000;
            ((FlatWords.FlatWordsSettings)settings).applyConfig(config, "checks.chat.text.global.words.");
            this.processors.add(new FlatWords("glWords", (FlatWords.FlatWordsSettings)settings));
        }
        if (config.getBoolean("checks.chat.text.global.prefixes.active", false)) {
            settings = new WordPrefixes.WordPrefixesSettings();
            ((WordPrefixes.WordPrefixesSettings)settings).maxAdd = 2000;
            ((WordPrefixes.WordPrefixesSettings)settings).applyConfig(config, "checks.chat.text.global.prefixes.");
            this.processors.add(new WordPrefixes("glPrefixes", (WordPrefixes.WordPrefixesSettings)settings));
        }
        if (config.getBoolean("checks.chat.text.global.similarity.active", false)) {
            settings = new SimilarWordsBKL.SimilarWordsBKLSettings();
            ((SimilarWordsBKL.SimilarWordsBKLSettings)settings).maxSize = 1000;
            ((SimilarWordsBKL.SimilarWordsBKLSettings)settings).applyConfig(config, "checks.chat.text.global.similarity.");
            this.processors.add(new SimilarWordsBKL("glSimilarity", (SimilarWordsBKL.SimilarWordsBKLSettings)settings));
        }
        this.dataMap = new EnginePlayerDataMap(600000L, 100, 0.75f);
    }

    public Map<String, Float> process(MessageLetterCount letterCount, String playerName, ChatConfig cc, ChatData data) {
        HashMap<String, Float> result = new HashMap<String, Float>();
        if (cc.textGlobalCheck) {
            for (WordProcessor processor : this.processors) {
                try {
                    result.put(processor.getProcessorName(), Float.valueOf(processor.process(letterCount) * cc.textGlobalWeight));
                }
                catch (Exception e) {
                    StaticLog.logSevere("chat.text: processor(" + processor.getProcessorName() + ") generated an exception: " + e.getClass().getSimpleName() + ": " + e.getMessage());
                    StaticLog.logSevere(e);
                }
            }
        }
        if (cc.textPlayerCheck) {
            EnginePlayerData engineData = this.dataMap.get(playerName, cc);
            for (WordProcessor processor : engineData.processors) {
                try {
                    result.put(processor.getProcessorName(), Float.valueOf(processor.process(letterCount) * cc.textPlayerWeight));
                }
                catch (Exception e) {
                    StaticLog.logSevere("chat.text: processor(" + processor.getProcessorName() + ") generated an exception: " + e.getClass().getSimpleName() + ": " + e.getMessage());
                    StaticLog.logSevere(e);
                }
            }
        }
        return result;
    }

    public void clear() {
        for (WordProcessor processor : this.processors) {
            processor.clear();
        }
        this.processors.clear();
        this.dataMap.clear();
    }

    @Override
    public IData removeData(String playerName) {
        return (IData)this.dataMap.remove(playerName);
    }

    @Override
    public void removeAllData() {
        this.dataMap.clear();
    }

    @Override
    public final CheckType getCheckType() {
        return CheckType.CHAT_TEXT;
    }

    @Override
    public void checkConsistency(Player[] onlinePlayers) {
        long now = System.currentTimeMillis();
        if (now < this.dataMap.lastExpired) {
            this.dataMap.clear();
            return;
        }
        if (now - this.dataMap.lastExpired > this.dataMap.durExpire) {
            this.dataMap.expire(now - this.dataMap.durExpire);
        }
    }
}

