/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockplace;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.blockplace.Against;
import fr.neatmonster.nocheatplus.checks.blockplace.AutoSign;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceConfig;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceData;
import fr.neatmonster.nocheatplus.checks.blockplace.Direction;
import fr.neatmonster.nocheatplus.checks.blockplace.FastPlace;
import fr.neatmonster.nocheatplus.checks.blockplace.NoSwing;
import fr.neatmonster.nocheatplus.checks.blockplace.Reach;
import fr.neatmonster.nocheatplus.checks.blockplace.Speed;
import fr.neatmonster.nocheatplus.checks.combined.Combined;
import fr.neatmonster.nocheatplus.checks.combined.CombinedConfig;
import fr.neatmonster.nocheatplus.checks.combined.Improbable;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.util.MovingUtil;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class BlockPlaceListener
extends CheckListener {
    private static final int p1 = 73856093;
    private static final int p2 = 19349663;
    private static final int p3 = 83492791;
    private final Against against = this.addCheck(new Against());
    private final AutoSign autoSign = this.addCheck(new AutoSign());
    private final Direction direction = this.addCheck(new Direction());
    private final FastPlace fastPlace = this.addCheck(new FastPlace());
    private final NoSwing noSwing = this.addCheck(new NoSwing());
    private final Reach reach = this.addCheck(new Reach());
    private final Speed speed = this.addCheck(new Speed());
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    private final Counters counters = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class);
    private final int idBoatsAnywhere = this.counters.registerKey("boatsanywhere");
    private final int idEnderPearl = this.counters.registerKey("throwenderpearl");
    private final Class<?> blockMultiPlaceEvent = ReflectionUtil.getClass("org.bukkit.event.block.BlockMultiPlaceEvent");
    private final boolean hasGetReplacedState = ReflectionUtil.getMethodNoArgs(BlockPlaceEvent.class, "getReplacedState", BlockState.class) != null;

    private static final int getHash(int x, int y, int z) {
        return 73856093 * x ^ 19349663 * y ^ 83492791 * z;
    }

    public static int getCoordHash(Block block) {
        return BlockPlaceListener.getHash(block.getX(), block.getY(), block.getZ());
    }

    public static int getBlockPlaceHash(Block block, Material mat) {
        int hash = BlockPlaceListener.getCoordHash(block);
        if (mat != null) {
            hash |= mat.name().hashCode();
        }
        return hash |= block.getWorld().getName().hashCode();
    }

    public BlockPlaceListener() {
        super(CheckType.BLOCKPLACE);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onBlockPlace(BlockPlaceEvent event) {
        boolean shouldSkipSome;
        ItemStack stack;
        Block block = event.getBlockPlaced();
        Block blockAgainst = event.getBlockAgainst();
        if (block == null || blockAgainst == null) {
            return;
        }
        Player player = event.getPlayer();
        Material placedMat = this.hasGetReplacedState ? event.getBlockPlaced().getType() : (Bridge1_9.hasGetItemInOffHand() ? (BlockProperties.isAir(stack = event.getItemInHand()) ? Material.AIR : stack.getType()) : Bridge1_9.getItemInMainHand(player).getType());
        boolean cancelled = false;
        BlockPlaceData data = BlockPlaceData.getData(player);
        BlockPlaceConfig cc = BlockPlaceConfig.getConfig(player);
        if (this.blockMultiPlaceEvent != null && event.getClass() == this.blockMultiPlaceEvent) {
            if (placedMat == Material.BEDROCK || Bridge1_9.hasEndCrystalItem() && placedMat == Bridge1_9.END_CRYSTAL_ITEM) {
                shouldSkipSome = true;
            } else {
                if (data.debug) {
                    this.debug(player, "Block place " + event.getClass().getName() + " " + placedMat);
                }
                shouldSkipSome = false;
            }
        } else {
            shouldSkipSome = false;
        }
        if (placedMat == Material.SIGN) {
            data.autoSignPlacedTime = System.currentTimeMillis();
            data.autoSignPlacedHash = BlockPlaceListener.getBlockPlaceHash(block, Material.SIGN);
        }
        if (!cancelled && MovingUtil.hasScheduledPlayerSetBack(player)) {
            cancelled = true;
        }
        if (!cancelled && this.fastPlace.isEnabled(player)) {
            if (this.fastPlace.check(player, block, data, cc)) {
                cancelled = true;
            } else {
                Improbable.feed(player, 0.5f, System.currentTimeMillis());
            }
        }
        if (!cancelled && !cc.noSwingExceptions.contains(placedMat) && this.noSwing.isEnabled(player) && this.noSwing.check(player, data, cc)) {
            cancelled = true;
        }
        if (!cancelled && !shouldSkipSome && this.reach.isEnabled(player) && this.reach.check(player, block, data, cc)) {
            cancelled = true;
        }
        if (!cancelled && !shouldSkipSome && this.direction.isEnabled(player) && this.direction.check(player, block, blockAgainst, data, cc)) {
            cancelled = true;
        }
        if (!cancelled && this.against.isEnabled(player) && this.against.check(player, block, placedMat, blockAgainst, data, cc)) {
            cancelled = true;
        }
        if (cancelled) {
            event.setCancelled(cancelled);
        } else if (data.debug) {
            this.debug(player, "Block place(" + placedMat + "): " + block.getX() + ", " + block.getY() + ", " + block.getZ());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSignChange(SignChangeEvent event) {
        if (event.getClass() != SignChangeEvent.class) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        String[] lines = event.getLines();
        if (block == null || lines == null || player == null) {
            return;
        }
        if (this.autoSign.isEnabled(player) && this.autoSign.check(player, block, lines)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerAnimation(PlayerAnimationEvent event) {
        BlockPlaceData.getData((Player)event.getPlayer()).noSwingArmSwung = true;
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack stack = Bridge1_9.getUsedItem(player, event);
        if (stack == null) {
            return;
        }
        BlockPlaceConfig cc = BlockPlaceConfig.getConfig(player);
        Material type = stack.getType();
        if (type == Material.BOAT) {
            if (cc.preventBoatsAnywhere) {
                this.checkBoatsAnywhere(player, event);
            }
        } else if (type == Material.MONSTER_EGG && this.speed.isEnabled(player, cc) && this.speed.check(player, cc)) {
            event.setCancelled(true);
        }
    }

    private void checkBoatsAnywhere(Player player, PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        Material mat = block.getType();
        if (mat == Material.WATER || mat == Material.STATIONARY_WATER) {
            return;
        }
        Block relBlock = block.getRelative(event.getBlockFace());
        Material relMat = relBlock.getType();
        if (relMat == Material.WATER || relMat == Material.STATIONARY_WATER) {
            return;
        }
        if (!player.hasPermission("nocheatplus.checks.blockplace.boatsanywhere")) {
            Event.Result previousUseBlock = event.useInteractedBlock();
            event.setCancelled(true);
            event.setUseItemInHand(Event.Result.DENY);
            event.setUseInteractedBlock(previousUseBlock == Event.Result.DEFAULT ? Event.Result.ALLOW : previousUseBlock);
            this.counters.addPrimaryThread(this.idBoatsAnywhere, 1);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        Projectile projectile = event.getEntity();
        Player player = BridgeMisc.getShooterPlayer(projectile);
        if (player == null) {
            return;
        }
        if (MovingUtil.hasScheduledPlayerSetBack(player)) {
            event.setCancelled(true);
            return;
        }
        EntityType type = event.getEntityType();
        switch (type) {
            case ENDER_PEARL: {
                break;
            }
            case ENDER_SIGNAL: {
                break;
            }
            case EGG: {
                break;
            }
            case SNOWBALL: {
                break;
            }
            case THROWN_EXP_BOTTLE: {
                break;
            }
            case SPLASH_POTION: {
                break;
            }
            default: {
                return;
            }
        }
        BlockPlaceConfig cc = BlockPlaceConfig.getConfig(player);
        boolean cancel = false;
        if (this.speed.isEnabled(player)) {
            long now = System.currentTimeMillis();
            Location loc = player.getLocation(this.useLoc);
            if (Combined.checkYawRate(player, loc.getYaw(), now, loc.getWorld().getName())) {
                cancel = true;
            }
            if (this.speed.check(player, cc)) {
                cancel = true;
            } else if (Improbable.check(player, 0.6f, now, "blockplace.speed")) {
                cancel = true;
            }
        }
        if (!cancel && type == EntityType.ENDER_PEARL) {
            if (CombinedConfig.getConfig((Player)player).enderPearlCheck) {
                if (!BlockProperties.isPassable(projectile.getLocation(this.useLoc))) {
                    cancel = true;
                } else if (!BlockProperties.isPassable(player.getEyeLocation(), projectile.getLocation(this.useLoc))) {
                    cancel = true;
                } else {
                    Material mat = player.getLocation(this.useLoc).getBlock().getType();
                    long flags = 522L;
                    if (!(BlockProperties.isAir(mat) || (BlockProperties.getBlockFlags(mat) & 0x20AL) != 0L || ((MCAccess)this.mcAccess.getHandle()).hasGravity(mat) || BlockProperties.isPassable(player.getLocation(), projectile.getLocation()) || BlockProperties.isOnGroundOrResetCond(player, player.getLocation(), MovingConfig.getConfig((Player)player).yOnGround))) {
                        cancel = true;
                    }
                }
            }
            if (cancel) {
                this.counters.addPrimaryThread(this.idEnderPearl, 1);
            }
        }
        if (cancel) {
            event.setCancelled(true);
        }
        this.useLoc.setWorld(null);
    }
}

