/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockplace;

import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.access.ACheckConfig;
import fr.neatmonster.nocheatplus.checks.access.CheckConfigFactory;
import fr.neatmonster.nocheatplus.checks.access.ICheckConfig;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class BlockPlaceConfig
extends ACheckConfig {
    public static final CheckConfigFactory factory = new CheckConfigFactory(){

        public final ICheckConfig getConfig(Player player) {
            return BlockPlaceConfig.getConfig(player);
        }

        public void removeAllConfigs() {
            BlockPlaceConfig.clear();
        }
    };
    private static final Map<String, BlockPlaceConfig> worldsMap = new HashMap<String, BlockPlaceConfig>();
    public final boolean againstCheck;
    public final ActionList againstActions;
    public final boolean autoSignCheck;
    public final boolean autoSignSkipEmpty;
    public final ActionList autoSignActions;
    public final boolean directionCheck;
    public final ActionList directionActions;
    public final boolean fastPlaceCheck;
    public final int fastPlaceLimit;
    public final int fastPlaceShortTermTicks;
    public final int fastPlaceShortTermLimit;
    public final ActionList fastPlaceActions;
    public final boolean noSwingCheck;
    public final Set<Material> noSwingExceptions = new HashSet<Material>();
    public final ActionList noSwingActions;
    public final boolean reachCheck;
    public final ActionList reachActions;
    public final boolean speedCheck;
    public final long speedInterval;
    public final ActionList speedActions;
    public final boolean preventBoatsAnywhere;

    public static void clear() {
        worldsMap.clear();
    }

    public static BlockPlaceConfig getConfig(Player player) {
        if (!worldsMap.containsKey(player.getWorld().getName())) {
            worldsMap.put(player.getWorld().getName(), new BlockPlaceConfig(ConfigManager.getConfigFile(player.getWorld().getName())));
        }
        return worldsMap.get(player.getWorld().getName());
    }

    public BlockPlaceConfig(ConfigFile config) {
        super(config, "checks.blockplace.");
        this.againstCheck = config.getBoolean("checks.blockplace.against.active");
        this.againstActions = (ActionList)config.getOptimizedActionList("checks.blockplace.against.actions", "nocheatplus.checks.blockplace.against");
        this.autoSignCheck = config.getBoolean("checks.blockplace.autosign.active");
        this.autoSignSkipEmpty = config.getBoolean("checks.blockplace.autosign.skipempty");
        this.autoSignActions = (ActionList)config.getOptimizedActionList("checks.blockplace.autosign.actions", "nocheatplus.checks.blockplace.autosign");
        this.directionCheck = config.getBoolean("checks.blockplace.direction.active");
        this.directionActions = (ActionList)config.getOptimizedActionList("checks.blockplace.direction.actions", "nocheatplus.checks.blockplace.direction");
        this.fastPlaceCheck = config.getBoolean("checks.blockplace.fastplace.active");
        this.fastPlaceLimit = config.getInt("checks.blockplace.fastplace.limit");
        this.fastPlaceShortTermTicks = config.getInt("checks.blockplace.fastplace.shortterm.ticks");
        this.fastPlaceShortTermLimit = config.getInt("checks.blockplace.fastplace.shortterm.limit");
        this.fastPlaceActions = (ActionList)config.getOptimizedActionList("checks.blockplace.fastplace.actions", "nocheatplus.checks.blockplace.fastplace");
        this.noSwingCheck = config.getBoolean("checks.blockplace.noswing.active");
        config.readMaterialFromList("checks.blockplace.noswing.exceptions", this.noSwingExceptions);
        this.noSwingActions = (ActionList)config.getOptimizedActionList("checks.blockplace.noswing.actions", "nocheatplus.checks.blockplace.noswing");
        this.reachCheck = config.getBoolean("checks.blockplace.reach.active");
        this.reachActions = (ActionList)config.getOptimizedActionList("checks.blockplace.reach.actions", "nocheatplus.checks.blockplace.reach");
        this.speedCheck = config.getBoolean("checks.blockplace.speed.active");
        this.speedInterval = config.getLong("checks.blockplace.speed.interval");
        this.speedActions = (ActionList)config.getOptimizedActionList("checks.blockplace.speed.actions", "nocheatplus.checks.blockplace.speed");
        this.preventBoatsAnywhere = config.getBoolean("checks.blockplace.preventmisc.boatsanywhere");
    }

    public final boolean isEnabled(CheckType checkType) {
        switch (checkType) {
            case BLOCKPLACE_DIRECTION: {
                return this.directionCheck;
            }
            case BLOCKPLACE_FASTPLACE: {
                return this.fastPlaceCheck;
            }
            case BLOCKPLACE_NOSWING: {
                return this.noSwingCheck;
            }
            case BLOCKPLACE_REACH: {
                return this.reachCheck;
            }
            case BLOCKPLACE_SPEED: {
                return this.speedCheck;
            }
            case BLOCKPLACE_AGAINST: {
                return this.againstCheck;
            }
            case BLOCKPLACE_AUTOSIGN: {
                return this.autoSignCheck;
            }
        }
        return true;
    }
}

