/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockinteract;

import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractConfig;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractData;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.checks.net.model.DataPacketFlying;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.collision.InteractRayTracing;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.location.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.WrapBlockCache;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Visible
extends Check {
    private final WrapBlockCache wrapBlockCache;
    private final InteractRayTracing rayTracing = new InteractRayTracing(false);
    private final List<String> tags = new ArrayList<String>();
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);

    public Visible() {
        super(CheckType.BLOCKINTERACT_VISIBLE);
        this.wrapBlockCache = new WrapBlockCache();
        this.rayTracing.setMaxSteps(60);
    }

    public boolean check(Player player, Location loc, Block block, BlockFace face, Action action, BlockInteractData data, BlockInteractConfig cc) {
        boolean collides;
        int blockX = block.getX();
        int blockY = block.getY();
        int blockZ = block.getZ();
        double eyeX = loc.getX();
        double eyeY = loc.getY() + player.getEyeHeight();
        double eyeZ = loc.getZ();
        this.tags.clear();
        if (TrigUtil.isSameBlock(blockX, blockY, blockZ, eyeX, eyeY, eyeZ)) {
            collides = false;
        } else {
            Vector direction = loc.getDirection();
            BlockCache blockCache = this.wrapBlockCache.getBlockCache();
            blockCache.setAccess(loc.getWorld());
            this.rayTracing.setBlockCache(blockCache);
            collides = this.checkRayTracing(eyeX, eyeY, eyeZ, direction.getX(), direction.getY(), direction.getZ(), blockX, blockY, blockZ, face, this.tags, data.debug);
            if (collides) {
                if (data.debug) {
                    this.debug(player, "pitch=" + loc.getPitch() + " yaw=" + loc.getYaw() + " tags=" + StringUtil.join(this.tags, "+"));
                }
                DataPacketFlying[] flyingQueue = ((NetData)CheckType.NET.getDataFactory().getData(player)).copyFlyingQueue();
                LocUtil.set(this.useLoc, loc);
                float oldPitch = this.useLoc.getPitch();
                float oldYaw = this.useLoc.getYaw();
                int count = 0;
                for (int i = 0; i < flyingQueue.length; ++i) {
                    DataPacketFlying packetData = flyingQueue[i];
                    if (!packetData.hasLook) continue;
                    if (packetData.getPitch() == oldPitch && packetData.getYaw() == oldYaw) {
                        if (count != 0) continue;
                        count = 1;
                    } else if (count < 4) {
                        ++count;
                    }
                    this.useLoc.setPitch(packetData.getPitch());
                    this.useLoc.setYaw(packetData.getYaw());
                    direction = this.useLoc.getDirection();
                    this.tags.clear();
                    this.tags.add("flying(" + i + ")");
                    collides = this.checkRayTracing(eyeX, eyeY, eyeZ, direction.getX(), direction.getY(), direction.getZ(), blockX, blockY, blockZ, face, this.tags, data.debug);
                    if (!collides) break;
                    if (!data.debug) continue;
                    this.debug(player, "pitch=" + loc.getPitch() + " yaw=" + loc.getYaw() + " tags=" + StringUtil.join(this.tags, "+"));
                }
                this.useLoc.setWorld(null);
            }
            this.rayTracing.cleanup();
            blockCache.cleanup();
        }
        boolean cancel = false;
        if (collides) {
            data.visibleVL += 1.0;
            ViolationData vd = new ViolationData(this, player, data.visibleVL, 1.0, cc.visibleActions);
            if (this.executeActions(vd).willCancel()) {
                cancel = true;
            }
        } else {
            data.visibleVL *= 0.99;
            if (data.debug) {
                this.debug(player, "pitch=" + loc.getPitch() + " yaw=" + loc.getYaw() + " tags=" + StringUtil.join(this.tags, "+"));
            }
        }
        return cancel;
    }

    private boolean checkRayTracing(double eyeX, double eyeY, double eyeZ, double dirX, double dirY, double dirZ, int blockX, int blockY, int blockZ, BlockFace face, List<String> tags, boolean debug) {
        boolean collides;
        double collideZ;
        double collideY;
        int eyeBlockX = Location.locToBlock((double)eyeX);
        int eyeBlockY = Location.locToBlock((double)eyeY);
        int eyeBlockZ = Location.locToBlock((double)eyeZ);
        int bdX = blockX - eyeBlockX;
        int bdY = blockY - eyeBlockY;
        int bdZ = blockZ - eyeBlockZ;
        double tMinX = this.getMinTime(eyeX, eyeBlockX, dirX, bdX);
        double tMinY = this.getMinTime(eyeY, eyeBlockY, dirY, bdY);
        double tMinZ = this.getMinTime(eyeZ, eyeBlockZ, dirZ, bdZ);
        double tMaxX = this.getMaxTime(eyeX, eyeBlockX, dirX, tMinX);
        double tMaxY = this.getMaxTime(eyeY, eyeBlockY, dirY, tMinY);
        double tMaxZ = this.getMaxTime(eyeZ, eyeBlockZ, dirZ, tMinZ);
        double tCollide = Math.max(0.0, Math.max(tMinX, Math.max(tMinY, tMinZ)));
        double collideX = this.toBlock(eyeX + dirX * tCollide, blockX);
        if (TrigUtil.distanceSquared(0.5 + (double)blockX, 0.5 + (double)blockY, 0.5 + (double)blockZ, collideX, collideY = this.toBlock(eyeY + dirY * tCollide, blockY), collideZ = this.toBlock(eyeZ + dirZ * tCollide, blockZ)) > 0.75) {
            tags.add("early_block_miss");
        }
        if (tMinX > tMaxY && tMinX > tMaxZ || tMinY > tMaxX && tMinY > tMaxZ || tMinZ > tMaxX && tMaxZ > tMaxY) {
            tags.add("time_miss");
            collideX = this.postCorrect(blockX, bdX, collideX);
            collideY = this.postCorrect(blockY, bdY, collideY);
            collideZ = this.postCorrect(blockZ, bdZ, collideZ);
        }
        if (tMinX == tCollide) {
            collideX = Math.round(collideX);
        }
        if (tMinY == tCollide) {
            collideY = Math.round(collideY);
        }
        if (tMinZ == tCollide) {
            collideZ = Math.round(collideZ);
        }
        if (TrigUtil.distanceSquared(0.5 + (double)blockX, 0.5 + (double)blockY, 0.5 + (double)blockZ, collideX, collideY, collideZ) > 0.75) {
            tags.add("late_block_miss");
        }
        this.rayTracing.set(eyeX, eyeY, eyeZ, collideX, collideY, collideZ, blockX, blockY, blockZ);
        this.rayTracing.loop();
        if (this.rayTracing.collides()) {
            tags.add("raytracing");
            collides = true;
        } else if (this.rayTracing.getStepsDone() > this.rayTracing.getMaxSteps()) {
            tags.add("raytracing_maxsteps");
            collides = true;
        } else {
            collides = false;
        }
        if (!collides || debug) {
            // empty if block
        }
        return collides;
    }

    private double postCorrect(int blockC, int bdC, double collideC) {
        int ref;
        int n = ref = bdC < 0 ? blockC + 1 : blockC;
        if (Location.locToBlock((double)collideC) == ref) {
            return collideC;
        }
        return ref;
    }

    private double getMinTime(double eye, int eyeBlock, double dir, int blockDiff) {
        if (blockDiff == 0) {
            return 0.0;
        }
        double eyeOffset = Math.abs(eye - (double)eyeBlock);
        return ((dir < 0.0 ? eyeOffset : 1.0 - eyeOffset) + (double)(Math.abs(blockDiff) - 1)) / Math.abs(dir);
    }

    private double getMaxTime(double eye, int eyeBlock, double dir, double tMin) {
        if (dir == 0.0) {
            return Double.MAX_VALUE;
        }
        if (tMin == 0.0) {
            double eyeOffset = Math.abs(eye - (double)eyeBlock);
            return (dir < 0.0 ? eyeOffset : 1.0 - eyeOffset) / Math.abs(dir);
        }
        return tMin + 1.0 / Math.abs(dir);
    }

    private double toBlock(double coord, int block) {
        int blockDiff = block - Location.locToBlock((double)coord);
        if (blockDiff == 0) {
            return coord;
        }
        return Math.round(coord);
    }
}

