/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockinteract;

import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractConfig;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractData;
import fr.neatmonster.nocheatplus.utilities.collision.CollideRayVsAABB;
import fr.neatmonster.nocheatplus.utilities.collision.ICollideRayVsAABB;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Direction
extends Check {
    private final ICollideRayVsAABB boulder = new CollideRayVsAABB();

    public Direction() {
        super(CheckType.BLOCKINTERACT_DIRECTION);
    }

    public boolean check(Player player, Location loc, Block block, BlockInteractData data, BlockInteractConfig cc) {
        boolean cancel = false;
        Vector direction = loc.getDirection();
        this.boulder.setFindNearestPointIfNotCollide(true).setRay(loc.getX(), loc.getY() + player.getEyeHeight(), loc.getZ(), direction.getX(), direction.getY(), direction.getZ()).setAABB(block.getX(), block.getY(), block.getZ(), 0.1).loop();
        if (!this.boulder.collides()) {
            double distance = Math.sqrt(this.boulder.getClosestDistanceSquared());
            if (data.debug) {
                this.outputDebugFail(player, this.boulder, distance);
            }
            data.directionVL += distance;
            cancel = this.executeActions(player, data.directionVL, distance, cc.directionActions).willCancel();
        } else {
            data.directionVL *= 0.9;
        }
        return cancel;
    }

    private void outputDebugFail(Player player, ICollideRayVsAABB boulder, double distance) {
        this.debug(player, "Failed: collides: " + boulder.collides() + " , dist: " + distance + " , pos: " + LocUtil.simpleFormat(boulder));
    }
}

