/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockinteract;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractConfig;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractData;
import fr.neatmonster.nocheatplus.checks.blockinteract.Direction;
import fr.neatmonster.nocheatplus.checks.blockinteract.Reach;
import fr.neatmonster.nocheatplus.checks.blockinteract.Speed;
import fr.neatmonster.nocheatplus.checks.blockinteract.Visible;
import fr.neatmonster.nocheatplus.checks.combined.CombinedConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.util.MovingUtil;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.BridgeHealth;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.utilities.InventoryUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class BlockInteractListener
extends CheckListener {
    private final Direction direction = this.addCheck(new Direction());
    private final Reach reach = this.addCheck(new Reach());
    private final Visible visible = this.addCheck(new Visible());
    private final Speed speed = this.addCheck(new Speed());
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    private final Counters counters = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class);
    private final int idCancelDead = this.counters.registerKey("canceldead");

    public BlockInteractListener() {
        super(CheckType.BLOCKINTERACT);
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.LOWEST)
    protected void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        int cancelId = player.isDead() && BridgeHealth.getHealth((LivingEntity)player) <= 0.0 ? this.idCancelDead : (MovingUtil.hasScheduledPlayerSetBack(player) ? -1 : Integer.MIN_VALUE);
        if (cancelId != Integer.MIN_VALUE) {
            event.setUseInteractedBlock(Event.Result.DENY);
            event.setUseItemInHand(Event.Result.DENY);
            event.setCancelled(true);
            if (cancelId >= 0) {
                this.counters.addPrimaryThread(cancelId, 1);
            }
            return;
        }
        Action action = event.getAction();
        Block block = event.getClickedBlock();
        BlockInteractData data = BlockInteractData.getData(player);
        int previousLastTick = data.lastTick;
        if (block == null) {
            data.resetLastBlock();
        } else {
            data.setLastBlock(block, action);
        }
        BlockFace face = event.getBlockFace();
        switch (action) {
            case RIGHT_CLICK_AIR: 
            case LEFT_CLICK_AIR: 
            case LEFT_CLICK_BLOCK: {
                Object stack = null;
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                ItemStack stack = Bridge1_9.getUsedItem(player, event);
                if (stack == null || stack.getType() != Material.ENDER_PEARL) break;
                this.checkEnderPearlRightClickBlock(player, block, face, event, previousLastTick, data);
                break;
            }
            default: {
                return;
            }
        }
        boolean cancelled = false;
        if (event.isCancelled() && event.useInteractedBlock() != Event.Result.ALLOW) {
            ++data.subsequentCancel;
            return;
        }
        BlockInteractConfig cc = BlockInteractConfig.getConfig(player);
        boolean preventUseItem = false;
        Location loc = player.getLocation(this.useLoc);
        if (!cancelled && this.speed.isEnabled(player) && this.speed.check(player, data, cc)) {
            cancelled = true;
            preventUseItem = true;
        }
        if (block != null) {
            if (!cancelled && this.reach.isEnabled(player) && this.reach.check(player, loc, block, data, cc)) {
                cancelled = true;
            }
            if (!cancelled && this.direction.isEnabled(player) && this.direction.check(player, loc, block, data, cc)) {
                cancelled = true;
            }
            if (!cancelled && this.visible.isEnabled(player) && this.visible.check(player, loc, block, face, action, data, cc)) {
                cancelled = true;
            }
        }
        if (cancelled) {
            this.onCancelInteract(player, block, face, event, previousLastTick, preventUseItem, data, cc);
        } else {
            data.subsequentCancel = 0;
        }
        this.useLoc.setWorld(null);
    }

    private void onCancelInteract(Player player, Block block, BlockFace face, PlayerInteractEvent event, int previousLastTick, boolean preventUseItem, BlockInteractData data, BlockInteractConfig cc) {
        if (event.isCancelled()) {
            event.setUseInteractedBlock(Event.Result.DENY);
            if (data.debug) {
                this.genericDebug(player, block, face, event, "already cancelled: deny use block", previousLastTick, data, cc);
            }
        } else {
            Event.Result previousUseItem = event.useItemInHand();
            event.setCancelled(true);
            event.setUseInteractedBlock(Event.Result.DENY);
            if (previousUseItem == Event.Result.DENY || preventUseItem || !InventoryUtil.isConsumable(Bridge1_9.getUsedItem(player, event))) {
                event.setUseItemInHand(Event.Result.DENY);
                if (data.debug) {
                    this.genericDebug(player, block, face, event, "deny item use", previousLastTick, data, cc);
                }
            } else {
                event.setUseItemInHand(Event.Result.ALLOW);
                if (data.debug) {
                    this.genericDebug(player, block, face, event, "allow edible item use", previousLastTick, data, cc);
                }
            }
        }
        ++data.subsequentCancel;
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.MONITOR)
    public void onPlayerInteractMonitor(PlayerInteractEvent event) {
        Player player;
        ItemStack stack;
        if (event.getAction() == Action.RIGHT_CLICK_AIR && event.isCancelled() && event.useItemInHand() != Event.Result.DENY && (stack = Bridge1_9.getUsedItem(player = event.getPlayer(), event)) != null && BridgeMisc.maybeElytraBoost(player, stack.getType())) {
            int ticks;
            BlockInteractData data = BlockInteractData.getData(player);
            int power = BridgeMisc.getFireworksPower(stack);
            MovingData mData = MovingData.getData(player);
            mData.fireworksBoostDuration = ticks = Math.max((1 + power) * 20, 30);
            mData.fireworksBoostTickExpire = TickTask.getTick() + ticks;
            if (data.debug) {
                this.debug(player, "Elytra boost (power " + power + "): " + stack);
            }
        }
    }

    private void checkEnderPearlRightClickBlock(Player player, Block block, BlockFace face, PlayerInteractEvent event, int previousLastTick, BlockInteractData data) {
        if (block == null || !BlockProperties.isPassable(block.getType())) {
            CombinedConfig ccc = CombinedConfig.getConfig(player);
            if (ccc.enderPearlCheck && ccc.enderPearlPreventClickBlock) {
                event.setUseItemInHand(Event.Result.DENY);
                if (data.debug) {
                    BlockInteractConfig cc = BlockInteractConfig.getConfig(player);
                    this.genericDebug(player, block, face, event, "click block: deny use ender pearl", previousLastTick, data, cc);
                }
            }
        }
    }

    private void genericDebug(Player player, Block block, BlockFace face, PlayerInteractEvent event, String tag, int previousLastTick, BlockInteractData data, BlockInteractConfig cc) {
        StringBuilder builder = new StringBuilder(512);
        if (data.lastTick == previousLastTick && data.subsequentCancel > 0) {
            ++data.rateLimitSkip;
            return;
        }
        builder.append("Interact cancel: " + event.isCancelled());
        builder.append(" (");
        builder.append(tag);
        if (block == null) {
            builder.append(") block: null");
        } else {
            builder.append(") block: ");
            builder.append(block.getWorld().getName() + "/" + LocUtil.simpleFormat(block));
            builder.append(" type: " + BlockProperties.getId(block.getType()));
            builder.append(" data: " + BlockProperties.getData(block));
            builder.append(" face: " + face);
        }
        if (data.rateLimitSkip > 0) {
            builder.append(" skipped(rate-limit: " + data.rateLimitSkip);
            data.rateLimitSkip = 0;
        }
        this.debug(player, builder.toString());
    }
}

