/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.actions.types;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.Action;
import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.actions.types.ActionWithParameters;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.ConfigFileWithActions;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.logging.LogManager;
import fr.neatmonster.nocheatplus.logging.StreamID;
import fr.neatmonster.nocheatplus.utilities.ColorUtil;
import java.util.ArrayList;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericLogAction
extends ActionWithParameters<ViolationData, ActionList> {
    private final GenericLogActionConfig[] configs;
    private final boolean checkActive;
    private final boolean replaceColor;
    private final boolean stripColor;

    public GenericLogAction(String name, int delay, int repeat, String message, boolean checkActive, GenericLogActionConfig ... configs) {
        super(name, delay, repeat, message);
        ArrayList<GenericLogActionConfig> temp = new ArrayList<GenericLogActionConfig>(configs.length);
        boolean replaceColor = false;
        boolean stripColor = false;
        boolean checkActiveUseful = false;
        for (int i = 0; i < configs.length; ++i) {
            GenericLogActionConfig config = configs[i];
            if (config == null) continue;
            temp.add(config);
            if (config.chatColor) {
                replaceColor = true;
            } else {
                stripColor = true;
            }
            if (config.configPathActive == null) continue;
            checkActiveUseful = true;
        }
        this.configs = temp.toArray(new GenericLogActionConfig[temp.size()]);
        this.checkActive = checkActive ? checkActiveUseful : false;
        this.replaceColor = replaceColor;
        this.stripColor = stripColor;
    }

    @Override
    public Action<ViolationData, ActionList> getOptimizedCopy(ConfigFileWithActions<ViolationData, ActionList> config, Integer threshold) {
        if (!config.getBoolean("logging.active") || this.configs.length == 0) {
            return null;
        }
        ArrayList<GenericLogActionConfig> temp = new ArrayList<GenericLogActionConfig>(this.configs.length);
        for (int i = 0; i < this.configs.length; ++i) {
            GenericLogActionConfig logConfig = this.configs[i];
            if (this.checkActive && logConfig.configPathActive != null && !config.getBoolean(logConfig.configPathActive)) continue;
            temp.add(logConfig);
        }
        if (temp.isEmpty()) {
            return null;
        }
        GenericLogActionConfig[] logConfigs = temp.toArray(new GenericLogActionConfig[temp.size()]);
        return new GenericLogAction(this.name, this.delay, this.repeat, this.message, false, logConfigs);
    }

    @Override
    public void execute(ViolationData violationData) {
        String permissionSilent = violationData.getPermissionSilent();
        if (permissionSilent != null && violationData.player.hasPermission(permissionSilent)) {
            return;
        }
        LogManager logManager = NCPAPIProvider.getNoCheatPlusAPI().getLogManager();
        String message = super.getMessage(violationData);
        String messageNoColor = this.stripColor ? ColorUtil.removeColors(message) : null;
        String messageWithColor = this.replaceColor ? ColorUtil.replaceColors(message) : null;
        ConfigFile configFile = this.checkActive ? ConfigManager.getConfigFile() : null;
        for (int i = 0; i < this.configs.length; ++i) {
            GenericLogActionConfig config = this.configs[i];
            if (this.checkActive && config.configPathActive != null && !configFile.getBoolean(config.configPathActive)) continue;
            logManager.log(config.streamID, config.level, config.chatColor ? messageWithColor : messageNoColor);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(32 + 2 * this.configs.length);
        builder.append("log:" + this.name + ":" + this.delay + ":" + this.repeat + ":");
        for (int i = 0; i < this.configs.length; ++i) {
            builder.append(this.configs[i].actionConfigSuffix);
        }
        return builder.toString();
    }

    @Override
    public boolean isOptimized() {
        return !this.checkActive;
    }

    public boolean logsToStream(StreamID streamID) {
        for (int i = 0; i < this.configs.length; ++i) {
            if (streamID != this.configs[i].streamID) continue;
            return true;
        }
        return false;
    }

    public static class GenericLogActionConfig {
        public final String configPathActive;
        public final boolean chatColor;
        public final StreamID streamID;
        public final Level level;
        public final String actionConfigSuffix;

        public GenericLogActionConfig(String configPathActive, StreamID streamID, boolean chatColor, Level level, String actionSuffix) {
            this.configPathActive = configPathActive;
            this.streamID = streamID;
            this.chatColor = chatColor;
            this.level = level;
            this.actionConfigSuffix = actionSuffix;
        }
    }
}

