/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.actions;

import fr.neatmonster.nocheatplus.actions.Action;
import fr.neatmonster.nocheatplus.actions.ActionData;
import fr.neatmonster.nocheatplus.config.ConfigFileWithActions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractActionList<D extends ActionData, L extends AbstractActionList<D, L>> {
    protected static final Action<?, ?>[] emptyArray = new Action[0];
    public final String permissionSilent;
    private final Map<Integer, Action<D, L>[]> actions = new HashMap<Integer, Action<D, L>[]>();
    protected final List<Integer> thresholds = new ArrayList<Integer>();
    protected final ActionListFactory<D, L> listFactory;

    public AbstractActionList(String permissionSilent, ActionListFactory<D, L> listFactory) {
        this.listFactory = listFactory;
        this.permissionSilent = permissionSilent;
    }

    public Action<D, L>[] getActions(double violationLevel) {
        Integer result = null;
        for (Integer threshold : this.thresholds) {
            if (!((double)threshold.intValue() <= violationLevel)) continue;
            result = threshold;
        }
        if (result != null) {
            return this.actions.get(result);
        }
        return emptyArray;
    }

    public List<Integer> getThresholds() {
        return this.thresholds;
    }

    public void setActions(Integer threshold, Action<D, L>[] actions) {
        if (!this.thresholds.contains(threshold)) {
            this.thresholds.add(threshold);
            Collections.sort(this.thresholds);
        }
        this.actions.put(threshold, actions);
    }

    public L getOptimizedCopy(ConfigFileWithActions<D, L> config) {
        L newList = this.listFactory.getNewActionList(this.permissionSilent);
        for (Map.Entry<Integer, Action<D, L>[]> entry : this.actions.entrySet()) {
            Integer t = entry.getKey();
            Action<D, L>[] a = this.getOptimizedCopy(config, t, entry.getValue());
            if (a == null || a.length <= 0) continue;
            ((AbstractActionList)newList).setActions(t, a);
        }
        return newList;
    }

    public Action<D, L>[] getOptimizedCopy(ConfigFileWithActions<D, L> config, Integer threshold, Action<D, L>[] actions) {
        if (actions == null || actions.length == 0) {
            return null;
        }
        ArrayList<Action<D, L>> optimized = new ArrayList<Action<D, L>>();
        for (Action<D, L> action : actions) {
            Action<D, L> optAction = action.getOptimizedCopy(config, threshold);
            if (optAction == null) continue;
            optimized.add(optAction);
        }
        if (optimized.isEmpty()) {
            return null;
        }
        Action[] optActions = new Action[optimized.size()];
        optimized.toArray(optActions);
        return optActions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ActionListFactory<D extends ActionData, L extends AbstractActionList<D, L>> {
        public L getNewActionList(String var1);
    }
}

