/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.workaround;

import fr.neatmonster.nocheatplus.utilities.ds.count.acceptdeny.AcceptDenyCounter;
import fr.neatmonster.nocheatplus.utilities.ds.count.acceptdeny.IAcceptDenyCounter;
import fr.neatmonster.nocheatplus.utilities.ds.count.acceptdeny.IResettableAcceptDenyCounter;
import fr.neatmonster.nocheatplus.workaround.AbstractWorkaround;
import fr.neatmonster.nocheatplus.workaround.IStagedWorkaround;

public class WorkaroundCountDown
extends AbstractWorkaround
implements IStagedWorkaround {
    private final int initialCount;
    private int currentCount;
    private final IResettableAcceptDenyCounter stageCounter;

    public WorkaroundCountDown(String id, int initialCount) {
        super(id);
        this.initialCount = initialCount;
        this.currentCount = initialCount;
        this.stageCounter = new AcceptDenyCounter();
    }

    public void setCurrentCount(int currentCount) {
        this.currentCount = currentCount;
    }

    public int getCurrentCount() {
        return this.currentCount;
    }

    public void resetConditions() {
        this.currentCount = this.initialCount;
        this.stageCounter.resetCounter();
    }

    public WorkaroundCountDown getNewInstance() {
        return this.setParentCounters(new WorkaroundCountDown(this.getId(), this.initialCount));
    }

    public IAcceptDenyCounter getStageCounter() {
        return this.stageCounter;
    }

    public boolean testUse(boolean isUse) {
        if (!isUse) {
            return this.currentCount > 0;
        }
        if (this.currentCount > 0) {
            --this.currentCount;
            this.stageCounter.accept();
            return true;
        }
        this.stageCounter.deny();
        return false;
    }
}

