/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.ds.map;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMapLOW<K, V> {
    private final Lock lock = new ReentrantLock();
    private final int targetSize;
    private LHMBucket<K, V>[] buckets;
    private int size = 0;
    private float loadFactor = 0.75f;

    private static <K> int getHashCode(K key) {
        return key == null ? 0 : key.hashCode();
    }

    public HashMapLOW(int targetSize) {
        this.targetSize = targetSize;
        this.buckets = this.newBuckets(targetSize);
    }

    private LHMBucket<K, V>[] newBuckets(int size) {
        return new LHMBucket[Math.max((int)(1.0f / this.loadFactor * (float)size), this.targetSize)];
    }

    private void resize() {
        LHMBucket<K, V>[] newBuckets = this.newBuckets(this.size);
        int newLength = newBuckets.length;
        for (int index = 0; index < this.buckets.length; ++index) {
            LHMBucket<K, V> bucket = this.buckets[index];
            if (bucket == null || bucket.size <= 0) continue;
            for (int j = 0; j < bucket.contents.length; ++j) {
                LHMEntry entry = bucket.contents[j];
                if (entry == null) continue;
                int newIndex = entry.hashCode % newLength;
                LHMBucket newBucket = newBuckets[newIndex];
                if (newBucket == null) {
                    newBucket = new LHMBucket();
                    newBuckets[newIndex] = newBucket;
                }
                newBucket.addEntry(entry);
            }
        }
        this.buckets = newBuckets;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.lock.lock();
        this.buckets = this.newBuckets(this.targetSize);
        this.size = 0;
        this.lock.unlock();
    }

    public V put(K key, V value) {
        V oldValue;
        int hashCode = HashMapLOW.getHashCode(key);
        this.lock.lock();
        int index = hashCode % this.buckets.length;
        LHMBucket<K, V> bucket = this.buckets[index];
        if (bucket == null) {
            bucket = new LHMBucket();
            this.buckets[index] = bucket;
        }
        if ((oldValue = bucket.put(hashCode, key, value)) == null) {
            ++this.size;
            if (this.size > (int)(this.loadFactor * (float)this.buckets.length)) {
                this.resize();
            }
        }
        this.lock.unlock();
        return oldValue;
    }

    public V remove(K key) {
        int hashCode = HashMapLOW.getHashCode(key);
        this.lock.lock();
        V value = this.removeUnderLock(hashCode, key);
        this.lock.unlock();
        return value;
    }

    private V removeUnderLock(int hashCode, K key) {
        int index = hashCode % this.buckets.length;
        LHMBucket<K, V> bucket = this.buckets[index];
        if (bucket == null || bucket.size == 0) {
            return null;
        }
        V value = bucket.remove(hashCode, key);
        if (value != null) {
            --this.size;
        }
        return value;
    }

    public void remove(Collection<K> keys) {
        this.lock.lock();
        for (K key : keys) {
            int hashCode = HashMapLOW.getHashCode(key);
            this.removeUnderLock(hashCode, key);
        }
        this.lock.unlock();
    }

    public V get(K key) {
        LHMBucket<K, V>[] buckets = this.buckets;
        int hashCode = HashMapLOW.getHashCode(key);
        LHMBucket<K, V> bucket = buckets[hashCode % buckets.length];
        if (bucket == null || bucket.size == 0) {
            return null;
        }
        return bucket.get(hashCode, key);
    }

    public V getLocked(K key) {
        this.lock.lock();
        V value = this.get(key);
        this.lock.unlock();
        return value;
    }

    public boolean containsKey(K key) {
        LHMBucket<K, V>[] buckets = this.buckets;
        int hashCode = HashMapLOW.getHashCode(key);
        LHMBucket<K, V> bucket = buckets[hashCode % buckets.length];
        if (bucket == null || bucket.size == 0) {
            return false;
        }
        return bucket.containsKey(hashCode, key);
    }

    public boolean containsKeyLocked(K key) {
        this.lock.lock();
        boolean res = this.containsKey(key);
        this.lock.unlock();
        return res;
    }

    public Iterator<Map.Entry<K, V>> iterator() {
        return this.size == 0 ? new LHMIterator(null, null) : new LHMIterator<K, V>(this, this.buckets);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LHMIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final HashMapLOW<K, V> map;
        private LHMBucket<K, V>[] buckets;
        private int bucketsIndex = 0;
        private LHMEntry<K, V>[] currentBucket = null;
        private int currentBucketIndex = 0;
        private LHMEntry<K, V> currentEntry = null;
        private K lastReturnedKey = null;

        public LHMIterator(HashMapLOW<K, V> map, LHMBucket<K, V>[] buckets) {
            this.map = map;
            this.buckets = buckets;
        }

        private void advance() {
            this.currentEntry = null;
            if (this.buckets == null || this.currentBucket != null && this.advanceBucket()) {
                return;
            }
            for (int i = this.bucketsIndex; i < this.buckets.length; ++i) {
                LHMBucket<K, V> bucket = this.buckets[i];
                if (bucket == null) continue;
                this.currentBucket = bucket.contents;
                if (!this.advanceBucket()) continue;
                this.bucketsIndex = i + 1;
                return;
            }
            this.buckets = null;
        }

        private boolean advanceBucket() {
            for (int i = this.currentBucketIndex; i < this.currentBucket.length; ++i) {
                LHMEntry<K, V> entry = this.currentBucket[i];
                if (entry == null) continue;
                this.currentBucketIndex = i + 1;
                this.currentEntry = entry;
                return true;
            }
            this.currentBucket = null;
            this.currentBucketIndex = 0;
            return false;
        }

        @Override
        public boolean hasNext() {
            if (this.currentEntry != null) {
                return true;
            }
            if (this.buckets == null) {
                return false;
            }
            this.advance();
            return this.currentEntry != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.currentEntry == null) {
                this.advance();
                if (this.currentEntry == null) {
                    this.buckets = null;
                    throw new NoSuchElementException();
                }
            }
            LHMEntry<K, V> entry = this.currentEntry;
            this.lastReturnedKey = entry.getKey();
            this.currentEntry = null;
            return entry;
        }

        @Override
        public void remove() {
            if (this.lastReturnedKey == null) {
                throw new IllegalStateException();
            }
            this.map.remove(this.lastReturnedKey);
            this.lastReturnedKey = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LHMBucket<K, V> {
        int size = 0;
        LHMEntry<K, V>[] contents = new LHMEntry[3];

        LHMBucket() {
        }

        V put(int hashCode, K key, V value) {
            int emptyIndex;
            if (this.size == 0) {
                emptyIndex = 0;
                ++this.size;
            } else {
                emptyIndex = -1;
                LHMEntry<K, V> oldEntry = null;
                int entriesFound = 0;
                for (int i = 0; i < this.contents.length; ++i) {
                    LHMEntry<K, V> entry = this.contents[i];
                    if (entry != null) {
                        ++entriesFound;
                        if (entry.equalsKey(hashCode, key)) {
                            oldEntry = entry;
                            break;
                        }
                        if (entriesFound != this.size || emptyIndex == -1) continue;
                        break;
                    }
                    if (emptyIndex != -1) continue;
                    emptyIndex = i;
                }
                if (oldEntry != null) {
                    Object oldValue = oldEntry.getValue();
                    oldEntry.setValue(value);
                    return oldValue;
                }
            }
            LHMEntry<K, V> newEntry = new LHMEntry<K, V>(hashCode, key, value);
            if (emptyIndex == -1) {
                this.grow(newEntry);
            } else {
                this.contents[emptyIndex] = newEntry;
            }
            ++this.size;
            return null;
        }

        private void grow(LHMEntry<K, V> entry) {
            int oldLength = this.contents.length;
            LHMEntry[] newContents = new LHMEntry[this.contents.length + Math.max(2, this.contents.length / 3)];
            System.arraycopy(this.contents, 0, newContents, 0, this.contents.length);
            newContents[oldLength] = entry;
            this.contents = newContents;
        }

        void addEntry(LHMEntry<K, V> entry) {
            ++this.size;
            for (int i = 0; i < this.contents.length; ++i) {
                if (this.contents[i] != null) continue;
                this.contents[i] = entry;
                return;
            }
            this.grow(entry);
        }

        V remove(int hashCode, K key) {
            if (this.size == 0) {
                return null;
            }
            for (int i = 0; i < this.contents.length; ++i) {
                LHMEntry<K, V> entry = this.contents[i];
                if (entry == null || !entry.equalsKey(hashCode, key)) continue;
                this.contents[i] = null;
                --this.size;
                return entry.getValue();
            }
            return null;
        }

        V get(int hashCode, K key) {
            LHMEntry<K, V>[] contents = this.contents;
            if (this.size == 0) {
                return null;
            }
            for (int i = 0; i < contents.length; ++i) {
                LHMEntry<K, V> entry = contents[i];
                if (entry == null || !entry.equalsKey(hashCode, key)) continue;
                return entry.getValue();
            }
            return null;
        }

        boolean containsKey(int hashCode, K key) {
            LHMEntry<K, V>[] contents = this.contents;
            if (this.size == 0) {
                return false;
            }
            for (int i = 0; i < contents.length; ++i) {
                LHMEntry<K, V> entry = contents[i];
                if (entry == null || !entry.equalsKey(hashCode, key)) continue;
                return true;
            }
            return false;
        }

        void clear() {
            Arrays.fill(this.contents, null);
            this.size = 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LHMEntry<K, V>
    implements Map.Entry<K, V> {
        final int hashCode;
        final K key;
        V value;

        LHMEntry(int hashCode, K key, V value) {
            this.hashCode = hashCode;
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public int hashCode() {
            return this.hashCode ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)obj;
                return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
            }
            return false;
        }

        public boolean equalsKey(int otherHashCode, K otherKey) {
            if (otherHashCode != this.hashCode) {
                return false;
            }
            if (otherKey == this.key) {
                return true;
            }
            return this.key != null && this.key.equals(otherKey);
        }
    }
}

