/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.access.ICheckConfig;
import fr.neatmonster.nocheatplus.checks.access.ICheckData;
import fr.neatmonster.nocheatplus.checks.blockbreak.BlockBreakData;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.checks.fight.FightData;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryData;
import fr.neatmonster.nocheatplus.hooks.APIUtils;
import fr.neatmonster.nocheatplus.hooks.NCPExemptionManager;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class CheckUtils {
    private static final Set<Integer> logOnce = Collections.synchronizedSet(new HashSet());

    public static void kickIllegalMove(Player player) {
        player.kickPlayer("Illegal move.");
        StaticLog.logWarning("[NCP] Disconnect " + player.getName() + " due to illegal move!");
    }

    public static final long guessKeepAliveTime(Player player, long now, long maxAge) {
        int tick = TickTask.getTick();
        long ref = Long.MIN_VALUE;
        FightData fData = FightData.getData(player);
        ref = Math.max(ref, fData.speedBuckets.lastUpdate());
        ref = Math.max(ref, now - 50L * (long)(tick - fData.lastAttackTick));
        ref = Math.max(ref, fData.regainHealthTime);
        ref = Math.max(ref, CombinedData.getData((Player)player).lastMoveTime);
        InventoryData iData = InventoryData.getData(player);
        ref = Math.max(ref, iData.lastClickTime);
        ref = Math.max(ref, iData.instantEatInteract);
        BlockBreakData bbData = BlockBreakData.getData(player);
        ref = Math.max(ref, bbData.frequencyBuckets.lastUpdate());
        if ((ref = Math.max(ref, bbData.fastBreakfirstDamage)) > now || ref < now - maxAge) {
            return Long.MIN_VALUE;
        }
        return ref;
    }

    public static Player getFirstPlayerPassenger(Entity entity) {
        for (Entity passenger = entity.getPassenger(); passenger != null; passenger = passenger.getPassenger()) {
            if (!(passenger instanceof Player)) continue;
            return (Player)passenger;
        }
        return null;
    }

    public static Entity getLastNonPlayerVehicle(Entity entity) {
        Entity vehicle;
        for (vehicle = entity.getVehicle(); vehicle != null; vehicle = vehicle.getVehicle()) {
            if (!(vehicle instanceof Player)) continue;
            return null;
        }
        return vehicle;
    }

    public static boolean isBadCoordinate(float ... floats) {
        for (int i = 0; i < floats.length; ++i) {
            if (!Float.isNaN(floats[i]) && !Float.isInfinite(floats[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isBadCoordinate(double ... doubles) {
        for (int i = 0; i < doubles.length; ++i) {
            double x = doubles[i];
            if (!Double.isNaN(x) && !Double.isInfinite(x) && !(Math.abs(x) > 3.2E7)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnabled(CheckType checkType, Player player, ICheckData data, ICheckConfig cc) {
        if (cc == null ? !checkType.isEnabled(player) : !cc.isEnabled(checkType)) {
            return false;
        }
        return !CheckUtils.hasBypass(checkType, player, data);
    }

    public static boolean hasBypass(CheckType checkType, Player player, ICheckData data) {
        String permission = checkType.getPermission();
        if (Bukkit.isPrimaryThread()) {
            if (permission != null && player.hasPermission(permission)) {
                return true;
            }
        } else if (permission != null) {
            if (data == null ? checkType.hasCachedPermission(player, permission) : data.hasCachedPermission(permission)) {
                return true;
            }
            if (!APIUtils.needsSynchronization(checkType)) {
                CheckUtils.improperAPIAccess(checkType);
            }
        }
        return NCPExemptionManager.isExempted(player, checkType);
    }

    private static void improperAPIAccess(CheckType checkType) {
        String trace = Arrays.toString(Thread.currentThread().getStackTrace());
        int ref = trace.hashCode() ^ new Integer(trace.length()).hashCode();
        boolean details = logOnce.add(ref);
        String extra = details ? " (id=" + ref + ")" : " (see earlier log with id=" + ref + ")";
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().severe(Streams.STATUS, "Off primary thread call to hasByPass for " + (Object)((Object)checkType) + extra + ".");
        if (details) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().severe(Streams.STATUS, trace);
            if (logOnce.size() > 10000) {
                logOnce.clear();
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().severe(Streams.STATUS, "Cleared log-once ids, due to exceeding the maximum number of stored ids.");
            }
        }
    }

    public static void debug(Player player, CheckType checkType, String message) {
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, CheckUtils.getLogMessagePrefix(player, checkType) + message);
    }

    public static String getLogMessagePrefix(Player player, CheckType checkType) {
        String base = "[" + (Object)((Object)checkType) + "] ";
        if (player != null) {
            base = base + "[" + player.getName() + "] ";
        }
        return base;
    }
}

